<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for data StructType
 * Meta information extracted from the WSDL
 * - documentation: Represents each country of data available via this service, its version, and licensed availability.
 * @subpackage Structs
 */
class Data extends AbstractStructBase
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: Upper-case, two-letter country code defined by ISO-3166.
     * - use: required
     * @var string
     */
    public $country;
    /**
     * The build
     * Meta information extracted from the WSDL
     * - documentation: The unique version number for this data set.
     * - use: required
     * @var string
     */
    public $build;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - documentation: The time at which this data was published.
     * - use: required
     * @var string
     */
    public $date;
    /**
     * The licensed
     * Meta information extracted from the WSDL
     * - documentation: True if these data are licensed.
     * @var bool
     */
    public $licensed;
    /**
     * Constructor method for data
     * @uses Data::setCountry()
     * @uses Data::setBuild()
     * @uses Data::setDate()
     * @uses Data::setLicensed()
     * @param string $country
     * @param string $build
     * @param string $date
     * @param bool $licensed
     */
    public function __construct($country = null, $build = null, $date = null, $licensed = null)
    {
        $this
            ->setCountry($country)
            ->setBuild($build)
            ->setDate($date)
            ->setLicensed($licensed);
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Data
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get build value
     * @return string
     */
    public function getBuild()
    {
        return $this->build;
    }
    /**
     * Set build value
     * @param string $build
     * @return \StructType\Data
     */
    public function setBuild($build = null)
    {
        // validation for constraint: string
        if (!is_null($build) && !is_string($build)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($build, true), gettype($build)), __LINE__);
        }
        $this->build = $build;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\Data
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get licensed value
     * @return bool|null
     */
    public function getLicensed()
    {
        return $this->licensed;
    }
    /**
     * Set licensed value
     * @param bool $licensed
     * @return \StructType\Data
     */
    public function setLicensed($licensed = null)
    {
        // validation for constraint: boolean
        if (!is_null($licensed) && !is_bool($licensed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($licensed, true), gettype($licensed)), __LINE__);
        }
        $this->licensed = $licensed;
        return $this;
    }
}
