<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumerInformation StructType
 * @subpackage Structs
 */
class ConsumerInformation extends AbstractStructBase
{
    /**
     * The type
     * @var \StructType\IdentifiedString
     */
    public $type;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item[]
     */
    public $item;
    /**
     * The styleId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $styleId;
    /**
     * Constructor method for ConsumerInformation
     * @uses ConsumerInformation::setType()
     * @uses ConsumerInformation::setItem()
     * @uses ConsumerInformation::setStyleId()
     * @param \StructType\IdentifiedString $type
     * @param \StructType\Item[] $item
     * @param int[] $styleId
     */
    public function __construct(\StructType\IdentifiedString $type = null, array $item = array(), array $styleId = array())
    {
        $this
            ->setType($type)
            ->setItem($item)
            ->setStyleId($styleId);
    }
    /**
     * Get type value
     * @return \StructType\IdentifiedString|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param \StructType\IdentifiedString $type
     * @return \StructType\ConsumerInformation
     */
    public function setType(\StructType\IdentifiedString $type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\Item[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consumerInformationItemItem) {
            // validation for constraint: itemType
            if (!$consumerInformationItemItem instanceof \StructType\Item) {
                $invalidValues[] = is_object($consumerInformationItemItem) ? get_class($consumerInformationItemItem) : sprintf('%s(%s)', gettype($consumerInformationItemItem), var_export($consumerInformationItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\Item, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item[] $item
     * @return \StructType\ConsumerInformation
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item $item
     * @return \StructType\ConsumerInformation
     */
    public function addToItem(\StructType\Item $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\Item, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Get styleId value
     * @return int[]|null
     */
    public function getStyleId()
    {
        return $this->styleId;
    }
    /**
     * This method is responsible for validating the values passed to the setStyleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyleId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStyleIdForArrayConstraintsFromSetStyleId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consumerInformationStyleIdItem) {
            // validation for constraint: itemType
            if (!(is_int($consumerInformationStyleIdItem) || ctype_digit($consumerInformationStyleIdItem))) {
                $invalidValues[] = is_object($consumerInformationStyleIdItem) ? get_class($consumerInformationStyleIdItem) : sprintf('%s(%s)', gettype($consumerInformationStyleIdItem), var_export($consumerInformationStyleIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The styleId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set styleId value
     * @throws \InvalidArgumentException
     * @param int[] $styleId
     * @return \StructType\ConsumerInformation
     */
    public function setStyleId(array $styleId = array())
    {
        // validation for constraint: array
        if ('' !== ($styleIdArrayErrorMessage = self::validateStyleIdForArrayConstraintsFromSetStyleId($styleId))) {
            throw new \InvalidArgumentException($styleIdArrayErrorMessage, __LINE__);
        }
        $this->styleId = $styleId;
        return $this;
    }
    /**
     * Add item to styleId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ConsumerInformation
     */
    public function addToStyleId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The styleId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->styleId[] = $item;
        return $this;
    }
}
