<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Color StructType
 * @subpackage Structs
 */
class Color extends AbstractStructBase
{
    /**
     * The colorCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $colorCode;
    /**
     * The colorName
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $colorName;
    /**
     * The genericColor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GenericColor[]
     */
    public $genericColor;
    /**
     * The styleId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $styleId;
    /**
     * The installed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallationCause
     */
    public $installed;
    /**
     * The rgbValue
     * @var string
     */
    public $rgbValue;
    /**
     * Constructor method for Color
     * @uses Color::setColorCode()
     * @uses Color::setColorName()
     * @uses Color::setGenericColor()
     * @uses Color::setStyleId()
     * @uses Color::setInstalled()
     * @uses Color::setRgbValue()
     * @param string $colorCode
     * @param string $colorName
     * @param \StructType\GenericColor[] $genericColor
     * @param int[] $styleId
     * @param \StructType\InstallationCause $installed
     * @param string $rgbValue
     */
    public function __construct($colorCode = null, $colorName = null, array $genericColor = array(), array $styleId = array(), \StructType\InstallationCause $installed = null, $rgbValue = null)
    {
        $this
            ->setColorCode($colorCode)
            ->setColorName($colorName)
            ->setGenericColor($genericColor)
            ->setStyleId($styleId)
            ->setInstalled($installed)
            ->setRgbValue($rgbValue);
    }
    /**
     * Get colorCode value
     * @return string
     */
    public function getColorCode()
    {
        return $this->colorCode;
    }
    /**
     * Set colorCode value
     * @param string $colorCode
     * @return \StructType\Color
     */
    public function setColorCode($colorCode = null)
    {
        // validation for constraint: string
        if (!is_null($colorCode) && !is_string($colorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorCode, true), gettype($colorCode)), __LINE__);
        }
        $this->colorCode = $colorCode;
        return $this;
    }
    /**
     * Get colorName value
     * @return string
     */
    public function getColorName()
    {
        return $this->colorName;
    }
    /**
     * Set colorName value
     * @param string $colorName
     * @return \StructType\Color
     */
    public function setColorName($colorName = null)
    {
        // validation for constraint: string
        if (!is_null($colorName) && !is_string($colorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorName, true), gettype($colorName)), __LINE__);
        }
        $this->colorName = $colorName;
        return $this;
    }
    /**
     * Get genericColor value
     * @return \StructType\GenericColor[]|null
     */
    public function getGenericColor()
    {
        return $this->genericColor;
    }
    /**
     * This method is responsible for validating the values passed to the setGenericColor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGenericColor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGenericColorForArrayConstraintsFromSetGenericColor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $colorGenericColorItem) {
            // validation for constraint: itemType
            if (!$colorGenericColorItem instanceof \StructType\GenericColor) {
                $invalidValues[] = is_object($colorGenericColorItem) ? get_class($colorGenericColorItem) : sprintf('%s(%s)', gettype($colorGenericColorItem), var_export($colorGenericColorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The genericColor property can only contain items of type \StructType\GenericColor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set genericColor value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericColor[] $genericColor
     * @return \StructType\Color
     */
    public function setGenericColor(array $genericColor = array())
    {
        // validation for constraint: array
        if ('' !== ($genericColorArrayErrorMessage = self::validateGenericColorForArrayConstraintsFromSetGenericColor($genericColor))) {
            throw new \InvalidArgumentException($genericColorArrayErrorMessage, __LINE__);
        }
        $this->genericColor = $genericColor;
        return $this;
    }
    /**
     * Add item to genericColor value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericColor $item
     * @return \StructType\Color
     */
    public function addToGenericColor(\StructType\GenericColor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericColor) {
            throw new \InvalidArgumentException(sprintf('The genericColor property can only contain items of type \StructType\GenericColor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->genericColor[] = $item;
        return $this;
    }
    /**
     * Get styleId value
     * @return int[]|null
     */
    public function getStyleId()
    {
        return $this->styleId;
    }
    /**
     * This method is responsible for validating the values passed to the setStyleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyleId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStyleIdForArrayConstraintsFromSetStyleId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $colorStyleIdItem) {
            // validation for constraint: itemType
            if (!(is_int($colorStyleIdItem) || ctype_digit($colorStyleIdItem))) {
                $invalidValues[] = is_object($colorStyleIdItem) ? get_class($colorStyleIdItem) : sprintf('%s(%s)', gettype($colorStyleIdItem), var_export($colorStyleIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The styleId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set styleId value
     * @throws \InvalidArgumentException
     * @param int[] $styleId
     * @return \StructType\Color
     */
    public function setStyleId(array $styleId = array())
    {
        // validation for constraint: array
        if ('' !== ($styleIdArrayErrorMessage = self::validateStyleIdForArrayConstraintsFromSetStyleId($styleId))) {
            throw new \InvalidArgumentException($styleIdArrayErrorMessage, __LINE__);
        }
        $this->styleId = $styleId;
        return $this;
    }
    /**
     * Add item to styleId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Color
     */
    public function addToStyleId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The styleId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->styleId[] = $item;
        return $this;
    }
    /**
     * Get installed value
     * @return \StructType\InstallationCause|null
     */
    public function getInstalled()
    {
        return $this->installed;
    }
    /**
     * Set installed value
     * @param \StructType\InstallationCause $installed
     * @return \StructType\Color
     */
    public function setInstalled(\StructType\InstallationCause $installed = null)
    {
        $this->installed = $installed;
        return $this;
    }
    /**
     * Get rgbValue value
     * @return string|null
     */
    public function getRgbValue()
    {
        return $this->rgbValue;
    }
    /**
     * Set rgbValue value
     * @param string $rgbValue
     * @return \StructType\Color
     */
    public function setRgbValue($rgbValue = null)
    {
        // validation for constraint: string
        if (!is_null($rgbValue) && !is_string($rgbValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rgbValue, true), gettype($rgbValue)), __LINE__);
        }
        $this->rgbValue = $rgbValue;
        return $this;
    }
}
