<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Describe ServiceType
 * @subpackage Services
 */
class Describe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named describeVehicle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VehicleDescriptionRequest $request
     * @return \StructType\VehicleDescription|bool
     */
    public function describeVehicle(\StructType\VehicleDescriptionRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->describeVehicle($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VehicleDescription
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
