<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SwitchAvailability EnumType
 * @subpackage Enumerations
 */
class SwitchAvailability extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ExcludeFleetOnly'
     * Meta information extracted from the WSDL
     * - documentation: Excludes Fleet Only information. (Default is "both.")
     * @return string 'ExcludeFleetOnly'
     */
    const VALUE_EXCLUDE_FLEET_ONLY = 'ExcludeFleetOnly';
    /**
     * Constant for value 'ExcludeRetailOnly'
     * Meta information extracted from the WSDL
     * - documentation: Excludes Retail Only information. (Default is "both".)
     * @return string 'ExcludeRetailOnly'
     */
    const VALUE_EXCLUDE_RETAIL_ONLY = 'ExcludeRetailOnly';
    /**
     * Return allowed values
     * @uses self::VALUE_EXCLUDE_FLEET_ONLY
     * @uses self::VALUE_EXCLUDE_RETAIL_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXCLUDE_FLEET_ONLY,
            self::VALUE_EXCLUDE_RETAIL_ONLY,
        );
    }
}
