<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services.chromedata.com/Description/7b?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services.chromedata.com/Description/7b?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getVersionInfo operation/method
 */
if ($get->getVersionInfo(new \StructType\BaseRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModelYears operation/method
 */
if ($get->getModelYears(new \StructType\BaseRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDivisions operation/method
 */
if ($get->getDivisions(new \StructType\DivisionsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSubdivisions operation/method
 */
if ($get->getSubdivisions(new \StructType\SubdivisionsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModels operation/method
 */
if ($get->getModels(new \StructType\ModelsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStyles operation/method
 */
if ($get->getStyles(new \StructType\StylesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCategoryDefinitions operation/method
 */
if ($get->getCategoryDefinitions(new \StructType\BaseRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTechnicalSpecificationDefinitions operation/method
 */
if ($get->getTechnicalSpecificationDefinitions(new \StructType\BaseRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Describe ServiceType
 */
$describe = new \ServiceType\Describe($options);
/**
 * Sample call for describeVehicle operation/method
 */
if ($describe->describeVehicle(new \StructType\VehicleDescriptionRequest()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
