<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleDescription StructType
 * @subpackage Structs
 */
class VehicleDescription extends BaseResponse
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $country;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $language;
    /**
     * The vinDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VinDescription
     */
    public $vinDescription;
    /**
     * The style
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Style[]
     */
    public $style;
    /**
     * The engine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Engine[]
     */
    public $engine;
    /**
     * The standard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Standard[]
     */
    public $standard;
    /**
     * The factoryOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Option[]
     */
    public $factoryOption;
    /**
     * The genericEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GenericEquipment[]
     */
    public $genericEquipment;
    /**
     * The consumerInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ConsumerInformation[]
     */
    public $consumerInformation;
    /**
     * The technicalSpecification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TechnicalSpecification[]
     */
    public $technicalSpecification;
    /**
     * The exteriorColor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Color[]
     */
    public $exteriorColor;
    /**
     * The interiorColor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Color[]
     */
    public $interiorColor;
    /**
     * The genericColor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GenericColor[]
     */
    public $genericColor;
    /**
     * The basePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceRange
     */
    public $basePrice;
    /**
     * The modelYear
     * @var int
     */
    public $modelYear;
    /**
     * The bestMakeName
     * @var string
     */
    public $bestMakeName;
    /**
     * The bestModelName
     * @var string
     */
    public $bestModelName;
    /**
     * The bestStyleName
     * @var string
     */
    public $bestStyleName;
    /**
     * The bestTrimName
     * @var string
     */
    public $bestTrimName;
    /**
     * Constructor method for VehicleDescription
     * @uses VehicleDescription::setCountry()
     * @uses VehicleDescription::setLanguage()
     * @uses VehicleDescription::setVinDescription()
     * @uses VehicleDescription::setStyle()
     * @uses VehicleDescription::setEngine()
     * @uses VehicleDescription::setStandard()
     * @uses VehicleDescription::setFactoryOption()
     * @uses VehicleDescription::setGenericEquipment()
     * @uses VehicleDescription::setConsumerInformation()
     * @uses VehicleDescription::setTechnicalSpecification()
     * @uses VehicleDescription::setExteriorColor()
     * @uses VehicleDescription::setInteriorColor()
     * @uses VehicleDescription::setGenericColor()
     * @uses VehicleDescription::setBasePrice()
     * @uses VehicleDescription::setModelYear()
     * @uses VehicleDescription::setBestMakeName()
     * @uses VehicleDescription::setBestModelName()
     * @uses VehicleDescription::setBestStyleName()
     * @uses VehicleDescription::setBestTrimName()
     * @param string $country
     * @param string $language
     * @param \StructType\VinDescription $vinDescription
     * @param \StructType\Style[] $style
     * @param \StructType\Engine[] $engine
     * @param \StructType\Standard[] $standard
     * @param \StructType\Option[] $factoryOption
     * @param \StructType\GenericEquipment[] $genericEquipment
     * @param \StructType\ConsumerInformation[] $consumerInformation
     * @param \StructType\TechnicalSpecification[] $technicalSpecification
     * @param \StructType\Color[] $exteriorColor
     * @param \StructType\Color[] $interiorColor
     * @param \StructType\GenericColor[] $genericColor
     * @param \StructType\PriceRange $basePrice
     * @param int $modelYear
     * @param string $bestMakeName
     * @param string $bestModelName
     * @param string $bestStyleName
     * @param string $bestTrimName
     */
    public function __construct($country = null, $language = null, \StructType\VinDescription $vinDescription = null, array $style = array(), array $engine = array(), array $standard = array(), array $factoryOption = array(), array $genericEquipment = array(), array $consumerInformation = array(), array $technicalSpecification = array(), array $exteriorColor = array(), array $interiorColor = array(), array $genericColor = array(), \StructType\PriceRange $basePrice = null, $modelYear = null, $bestMakeName = null, $bestModelName = null, $bestStyleName = null, $bestTrimName = null)
    {
        $this
            ->setCountry($country)
            ->setLanguage($language)
            ->setVinDescription($vinDescription)
            ->setStyle($style)
            ->setEngine($engine)
            ->setStandard($standard)
            ->setFactoryOption($factoryOption)
            ->setGenericEquipment($genericEquipment)
            ->setConsumerInformation($consumerInformation)
            ->setTechnicalSpecification($technicalSpecification)
            ->setExteriorColor($exteriorColor)
            ->setInteriorColor($interiorColor)
            ->setGenericColor($genericColor)
            ->setBasePrice($basePrice)
            ->setModelYear($modelYear)
            ->setBestMakeName($bestMakeName)
            ->setBestModelName($bestModelName)
            ->setBestStyleName($bestStyleName)
            ->setBestTrimName($bestTrimName);
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\VehicleDescription
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\VehicleDescription
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get vinDescription value
     * @return \StructType\VinDescription|null
     */
    public function getVinDescription()
    {
        return $this->vinDescription;
    }
    /**
     * Set vinDescription value
     * @param \StructType\VinDescription $vinDescription
     * @return \StructType\VehicleDescription
     */
    public function setVinDescription(\StructType\VinDescription $vinDescription = null)
    {
        $this->vinDescription = $vinDescription;
        return $this;
    }
    /**
     * Get style value
     * @return \StructType\Style[]|null
     */
    public function getStyle()
    {
        return $this->style;
    }
    /**
     * This method is responsible for validating the values passed to the setStyle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStyleForArrayConstraintsFromSetStyle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionStyleItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionStyleItem instanceof \StructType\Style) {
                $invalidValues[] = is_object($vehicleDescriptionStyleItem) ? get_class($vehicleDescriptionStyleItem) : sprintf('%s(%s)', gettype($vehicleDescriptionStyleItem), var_export($vehicleDescriptionStyleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The style property can only contain items of type \StructType\Style, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set style value
     * @throws \InvalidArgumentException
     * @param \StructType\Style[] $style
     * @return \StructType\VehicleDescription
     */
    public function setStyle(array $style = array())
    {
        // validation for constraint: array
        if ('' !== ($styleArrayErrorMessage = self::validateStyleForArrayConstraintsFromSetStyle($style))) {
            throw new \InvalidArgumentException($styleArrayErrorMessage, __LINE__);
        }
        $this->style = $style;
        return $this;
    }
    /**
     * Add item to style value
     * @throws \InvalidArgumentException
     * @param \StructType\Style $item
     * @return \StructType\VehicleDescription
     */
    public function addToStyle(\StructType\Style $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Style) {
            throw new \InvalidArgumentException(sprintf('The style property can only contain items of type \StructType\Style, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->style[] = $item;
        return $this;
    }
    /**
     * Get engine value
     * @return \StructType\Engine[]|null
     */
    public function getEngine()
    {
        return $this->engine;
    }
    /**
     * This method is responsible for validating the values passed to the setEngine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEngine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEngineForArrayConstraintsFromSetEngine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionEngineItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionEngineItem instanceof \StructType\Engine) {
                $invalidValues[] = is_object($vehicleDescriptionEngineItem) ? get_class($vehicleDescriptionEngineItem) : sprintf('%s(%s)', gettype($vehicleDescriptionEngineItem), var_export($vehicleDescriptionEngineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The engine property can only contain items of type \StructType\Engine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set engine value
     * @throws \InvalidArgumentException
     * @param \StructType\Engine[] $engine
     * @return \StructType\VehicleDescription
     */
    public function setEngine(array $engine = array())
    {
        // validation for constraint: array
        if ('' !== ($engineArrayErrorMessage = self::validateEngineForArrayConstraintsFromSetEngine($engine))) {
            throw new \InvalidArgumentException($engineArrayErrorMessage, __LINE__);
        }
        $this->engine = $engine;
        return $this;
    }
    /**
     * Add item to engine value
     * @throws \InvalidArgumentException
     * @param \StructType\Engine $item
     * @return \StructType\VehicleDescription
     */
    public function addToEngine(\StructType\Engine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Engine) {
            throw new \InvalidArgumentException(sprintf('The engine property can only contain items of type \StructType\Engine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->engine[] = $item;
        return $this;
    }
    /**
     * Get standard value
     * @return \StructType\Standard[]|null
     */
    public function getStandard()
    {
        return $this->standard;
    }
    /**
     * This method is responsible for validating the values passed to the setStandard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandardForArrayConstraintsFromSetStandard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionStandardItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionStandardItem instanceof \StructType\Standard) {
                $invalidValues[] = is_object($vehicleDescriptionStandardItem) ? get_class($vehicleDescriptionStandardItem) : sprintf('%s(%s)', gettype($vehicleDescriptionStandardItem), var_export($vehicleDescriptionStandardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The standard property can only contain items of type \StructType\Standard, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set standard value
     * @throws \InvalidArgumentException
     * @param \StructType\Standard[] $standard
     * @return \StructType\VehicleDescription
     */
    public function setStandard(array $standard = array())
    {
        // validation for constraint: array
        if ('' !== ($standardArrayErrorMessage = self::validateStandardForArrayConstraintsFromSetStandard($standard))) {
            throw new \InvalidArgumentException($standardArrayErrorMessage, __LINE__);
        }
        $this->standard = $standard;
        return $this;
    }
    /**
     * Add item to standard value
     * @throws \InvalidArgumentException
     * @param \StructType\Standard $item
     * @return \StructType\VehicleDescription
     */
    public function addToStandard(\StructType\Standard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Standard) {
            throw new \InvalidArgumentException(sprintf('The standard property can only contain items of type \StructType\Standard, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->standard[] = $item;
        return $this;
    }
    /**
     * Get factoryOption value
     * @return \StructType\Option[]|null
     */
    public function getFactoryOption()
    {
        return $this->factoryOption;
    }
    /**
     * This method is responsible for validating the values passed to the setFactoryOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFactoryOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFactoryOptionForArrayConstraintsFromSetFactoryOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionFactoryOptionItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionFactoryOptionItem instanceof \StructType\Option) {
                $invalidValues[] = is_object($vehicleDescriptionFactoryOptionItem) ? get_class($vehicleDescriptionFactoryOptionItem) : sprintf('%s(%s)', gettype($vehicleDescriptionFactoryOptionItem), var_export($vehicleDescriptionFactoryOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The factoryOption property can only contain items of type \StructType\Option, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set factoryOption value
     * @throws \InvalidArgumentException
     * @param \StructType\Option[] $factoryOption
     * @return \StructType\VehicleDescription
     */
    public function setFactoryOption(array $factoryOption = array())
    {
        // validation for constraint: array
        if ('' !== ($factoryOptionArrayErrorMessage = self::validateFactoryOptionForArrayConstraintsFromSetFactoryOption($factoryOption))) {
            throw new \InvalidArgumentException($factoryOptionArrayErrorMessage, __LINE__);
        }
        $this->factoryOption = $factoryOption;
        return $this;
    }
    /**
     * Add item to factoryOption value
     * @throws \InvalidArgumentException
     * @param \StructType\Option $item
     * @return \StructType\VehicleDescription
     */
    public function addToFactoryOption(\StructType\Option $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Option) {
            throw new \InvalidArgumentException(sprintf('The factoryOption property can only contain items of type \StructType\Option, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->factoryOption[] = $item;
        return $this;
    }
    /**
     * Get genericEquipment value
     * @return \StructType\GenericEquipment[]|null
     */
    public function getGenericEquipment()
    {
        return $this->genericEquipment;
    }
    /**
     * This method is responsible for validating the values passed to the setGenericEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGenericEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGenericEquipmentForArrayConstraintsFromSetGenericEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionGenericEquipmentItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionGenericEquipmentItem instanceof \StructType\GenericEquipment) {
                $invalidValues[] = is_object($vehicleDescriptionGenericEquipmentItem) ? get_class($vehicleDescriptionGenericEquipmentItem) : sprintf('%s(%s)', gettype($vehicleDescriptionGenericEquipmentItem), var_export($vehicleDescriptionGenericEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The genericEquipment property can only contain items of type \StructType\GenericEquipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set genericEquipment value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericEquipment[] $genericEquipment
     * @return \StructType\VehicleDescription
     */
    public function setGenericEquipment(array $genericEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($genericEquipmentArrayErrorMessage = self::validateGenericEquipmentForArrayConstraintsFromSetGenericEquipment($genericEquipment))) {
            throw new \InvalidArgumentException($genericEquipmentArrayErrorMessage, __LINE__);
        }
        $this->genericEquipment = $genericEquipment;
        return $this;
    }
    /**
     * Add item to genericEquipment value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericEquipment $item
     * @return \StructType\VehicleDescription
     */
    public function addToGenericEquipment(\StructType\GenericEquipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericEquipment) {
            throw new \InvalidArgumentException(sprintf('The genericEquipment property can only contain items of type \StructType\GenericEquipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->genericEquipment[] = $item;
        return $this;
    }
    /**
     * Get consumerInformation value
     * @return \StructType\ConsumerInformation[]|null
     */
    public function getConsumerInformation()
    {
        return $this->consumerInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setConsumerInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConsumerInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConsumerInformationForArrayConstraintsFromSetConsumerInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionConsumerInformationItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionConsumerInformationItem instanceof \StructType\ConsumerInformation) {
                $invalidValues[] = is_object($vehicleDescriptionConsumerInformationItem) ? get_class($vehicleDescriptionConsumerInformationItem) : sprintf('%s(%s)', gettype($vehicleDescriptionConsumerInformationItem), var_export($vehicleDescriptionConsumerInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The consumerInformation property can only contain items of type \StructType\ConsumerInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set consumerInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsumerInformation[] $consumerInformation
     * @return \StructType\VehicleDescription
     */
    public function setConsumerInformation(array $consumerInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($consumerInformationArrayErrorMessage = self::validateConsumerInformationForArrayConstraintsFromSetConsumerInformation($consumerInformation))) {
            throw new \InvalidArgumentException($consumerInformationArrayErrorMessage, __LINE__);
        }
        $this->consumerInformation = $consumerInformation;
        return $this;
    }
    /**
     * Add item to consumerInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsumerInformation $item
     * @return \StructType\VehicleDescription
     */
    public function addToConsumerInformation(\StructType\ConsumerInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConsumerInformation) {
            throw new \InvalidArgumentException(sprintf('The consumerInformation property can only contain items of type \StructType\ConsumerInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->consumerInformation[] = $item;
        return $this;
    }
    /**
     * Get technicalSpecification value
     * @return \StructType\TechnicalSpecification[]|null
     */
    public function getTechnicalSpecification()
    {
        return $this->technicalSpecification;
    }
    /**
     * This method is responsible for validating the values passed to the setTechnicalSpecification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTechnicalSpecification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTechnicalSpecificationForArrayConstraintsFromSetTechnicalSpecification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionTechnicalSpecificationItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionTechnicalSpecificationItem instanceof \StructType\TechnicalSpecification) {
                $invalidValues[] = is_object($vehicleDescriptionTechnicalSpecificationItem) ? get_class($vehicleDescriptionTechnicalSpecificationItem) : sprintf('%s(%s)', gettype($vehicleDescriptionTechnicalSpecificationItem), var_export($vehicleDescriptionTechnicalSpecificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The technicalSpecification property can only contain items of type \StructType\TechnicalSpecification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set technicalSpecification value
     * @throws \InvalidArgumentException
     * @param \StructType\TechnicalSpecification[] $technicalSpecification
     * @return \StructType\VehicleDescription
     */
    public function setTechnicalSpecification(array $technicalSpecification = array())
    {
        // validation for constraint: array
        if ('' !== ($technicalSpecificationArrayErrorMessage = self::validateTechnicalSpecificationForArrayConstraintsFromSetTechnicalSpecification($technicalSpecification))) {
            throw new \InvalidArgumentException($technicalSpecificationArrayErrorMessage, __LINE__);
        }
        $this->technicalSpecification = $technicalSpecification;
        return $this;
    }
    /**
     * Add item to technicalSpecification value
     * @throws \InvalidArgumentException
     * @param \StructType\TechnicalSpecification $item
     * @return \StructType\VehicleDescription
     */
    public function addToTechnicalSpecification(\StructType\TechnicalSpecification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TechnicalSpecification) {
            throw new \InvalidArgumentException(sprintf('The technicalSpecification property can only contain items of type \StructType\TechnicalSpecification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->technicalSpecification[] = $item;
        return $this;
    }
    /**
     * Get exteriorColor value
     * @return \StructType\Color[]|null
     */
    public function getExteriorColor()
    {
        return $this->exteriorColor;
    }
    /**
     * This method is responsible for validating the values passed to the setExteriorColor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExteriorColor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExteriorColorForArrayConstraintsFromSetExteriorColor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionExteriorColorItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionExteriorColorItem instanceof \StructType\Color) {
                $invalidValues[] = is_object($vehicleDescriptionExteriorColorItem) ? get_class($vehicleDescriptionExteriorColorItem) : sprintf('%s(%s)', gettype($vehicleDescriptionExteriorColorItem), var_export($vehicleDescriptionExteriorColorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The exteriorColor property can only contain items of type \StructType\Color, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set exteriorColor value
     * @throws \InvalidArgumentException
     * @param \StructType\Color[] $exteriorColor
     * @return \StructType\VehicleDescription
     */
    public function setExteriorColor(array $exteriorColor = array())
    {
        // validation for constraint: array
        if ('' !== ($exteriorColorArrayErrorMessage = self::validateExteriorColorForArrayConstraintsFromSetExteriorColor($exteriorColor))) {
            throw new \InvalidArgumentException($exteriorColorArrayErrorMessage, __LINE__);
        }
        $this->exteriorColor = $exteriorColor;
        return $this;
    }
    /**
     * Add item to exteriorColor value
     * @throws \InvalidArgumentException
     * @param \StructType\Color $item
     * @return \StructType\VehicleDescription
     */
    public function addToExteriorColor(\StructType\Color $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Color) {
            throw new \InvalidArgumentException(sprintf('The exteriorColor property can only contain items of type \StructType\Color, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->exteriorColor[] = $item;
        return $this;
    }
    /**
     * Get interiorColor value
     * @return \StructType\Color[]|null
     */
    public function getInteriorColor()
    {
        return $this->interiorColor;
    }
    /**
     * This method is responsible for validating the values passed to the setInteriorColor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInteriorColor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInteriorColorForArrayConstraintsFromSetInteriorColor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionInteriorColorItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionInteriorColorItem instanceof \StructType\Color) {
                $invalidValues[] = is_object($vehicleDescriptionInteriorColorItem) ? get_class($vehicleDescriptionInteriorColorItem) : sprintf('%s(%s)', gettype($vehicleDescriptionInteriorColorItem), var_export($vehicleDescriptionInteriorColorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The interiorColor property can only contain items of type \StructType\Color, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set interiorColor value
     * @throws \InvalidArgumentException
     * @param \StructType\Color[] $interiorColor
     * @return \StructType\VehicleDescription
     */
    public function setInteriorColor(array $interiorColor = array())
    {
        // validation for constraint: array
        if ('' !== ($interiorColorArrayErrorMessage = self::validateInteriorColorForArrayConstraintsFromSetInteriorColor($interiorColor))) {
            throw new \InvalidArgumentException($interiorColorArrayErrorMessage, __LINE__);
        }
        $this->interiorColor = $interiorColor;
        return $this;
    }
    /**
     * Add item to interiorColor value
     * @throws \InvalidArgumentException
     * @param \StructType\Color $item
     * @return \StructType\VehicleDescription
     */
    public function addToInteriorColor(\StructType\Color $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Color) {
            throw new \InvalidArgumentException(sprintf('The interiorColor property can only contain items of type \StructType\Color, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->interiorColor[] = $item;
        return $this;
    }
    /**
     * Get genericColor value
     * @return \StructType\GenericColor[]|null
     */
    public function getGenericColor()
    {
        return $this->genericColor;
    }
    /**
     * This method is responsible for validating the values passed to the setGenericColor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGenericColor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGenericColorForArrayConstraintsFromSetGenericColor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionGenericColorItem) {
            // validation for constraint: itemType
            if (!$vehicleDescriptionGenericColorItem instanceof \StructType\GenericColor) {
                $invalidValues[] = is_object($vehicleDescriptionGenericColorItem) ? get_class($vehicleDescriptionGenericColorItem) : sprintf('%s(%s)', gettype($vehicleDescriptionGenericColorItem), var_export($vehicleDescriptionGenericColorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The genericColor property can only contain items of type \StructType\GenericColor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set genericColor value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericColor[] $genericColor
     * @return \StructType\VehicleDescription
     */
    public function setGenericColor(array $genericColor = array())
    {
        // validation for constraint: array
        if ('' !== ($genericColorArrayErrorMessage = self::validateGenericColorForArrayConstraintsFromSetGenericColor($genericColor))) {
            throw new \InvalidArgumentException($genericColorArrayErrorMessage, __LINE__);
        }
        $this->genericColor = $genericColor;
        return $this;
    }
    /**
     * Add item to genericColor value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericColor $item
     * @return \StructType\VehicleDescription
     */
    public function addToGenericColor(\StructType\GenericColor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericColor) {
            throw new \InvalidArgumentException(sprintf('The genericColor property can only contain items of type \StructType\GenericColor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->genericColor[] = $item;
        return $this;
    }
    /**
     * Get basePrice value
     * @return \StructType\PriceRange|null
     */
    public function getBasePrice()
    {
        return $this->basePrice;
    }
    /**
     * Set basePrice value
     * @param \StructType\PriceRange $basePrice
     * @return \StructType\VehicleDescription
     */
    public function setBasePrice(\StructType\PriceRange $basePrice = null)
    {
        $this->basePrice = $basePrice;
        return $this;
    }
    /**
     * Get modelYear value
     * @return int|null
     */
    public function getModelYear()
    {
        return $this->modelYear;
    }
    /**
     * Set modelYear value
     * @param int $modelYear
     * @return \StructType\VehicleDescription
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        $this->modelYear = $modelYear;
        return $this;
    }
    /**
     * Get bestMakeName value
     * @return string|null
     */
    public function getBestMakeName()
    {
        return $this->bestMakeName;
    }
    /**
     * Set bestMakeName value
     * @param string $bestMakeName
     * @return \StructType\VehicleDescription
     */
    public function setBestMakeName($bestMakeName = null)
    {
        // validation for constraint: string
        if (!is_null($bestMakeName) && !is_string($bestMakeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestMakeName, true), gettype($bestMakeName)), __LINE__);
        }
        $this->bestMakeName = $bestMakeName;
        return $this;
    }
    /**
     * Get bestModelName value
     * @return string|null
     */
    public function getBestModelName()
    {
        return $this->bestModelName;
    }
    /**
     * Set bestModelName value
     * @param string $bestModelName
     * @return \StructType\VehicleDescription
     */
    public function setBestModelName($bestModelName = null)
    {
        // validation for constraint: string
        if (!is_null($bestModelName) && !is_string($bestModelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestModelName, true), gettype($bestModelName)), __LINE__);
        }
        $this->bestModelName = $bestModelName;
        return $this;
    }
    /**
     * Get bestStyleName value
     * @return string|null
     */
    public function getBestStyleName()
    {
        return $this->bestStyleName;
    }
    /**
     * Set bestStyleName value
     * @param string $bestStyleName
     * @return \StructType\VehicleDescription
     */
    public function setBestStyleName($bestStyleName = null)
    {
        // validation for constraint: string
        if (!is_null($bestStyleName) && !is_string($bestStyleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestStyleName, true), gettype($bestStyleName)), __LINE__);
        }
        $this->bestStyleName = $bestStyleName;
        return $this;
    }
    /**
     * Get bestTrimName value
     * @return string|null
     */
    public function getBestTrimName()
    {
        return $this->bestTrimName;
    }
    /**
     * Set bestTrimName value
     * @param string $bestTrimName
     * @return \StructType\VehicleDescription
     */
    public function setBestTrimName($bestTrimName = null)
    {
        // validation for constraint: string
        if (!is_null($bestTrimName) && !is_string($bestTrimName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestTrimName, true), gettype($bestTrimName)), __LINE__);
        }
        $this->bestTrimName = $bestTrimName;
        return $this;
    }
}
