<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueRPM StructType
 * @subpackage Structs
 */
class ValueRPM extends AbstractStructBase
{
    /**
     * The value
     * @var float
     */
    public $value;
    /**
     * The rpm
     * @var int
     */
    public $rpm;
    /**
     * Constructor method for ValueRPM
     * @uses ValueRPM::setValue()
     * @uses ValueRPM::setRpm()
     * @param float $value
     * @param int $rpm
     */
    public function __construct($value = null, $rpm = null)
    {
        $this
            ->setValue($value)
            ->setRpm($rpm);
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\ValueRPM
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get rpm value
     * @return int|null
     */
    public function getRpm()
    {
        return $this->rpm;
    }
    /**
     * Set rpm value
     * @param int $rpm
     * @return \StructType\ValueRPM
     */
    public function setRpm($rpm = null)
    {
        // validation for constraint: int
        if (!is_null($rpm) && !(is_int($rpm) || ctype_digit($rpm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rpm, true), gettype($rpm)), __LINE__);
        }
        $this->rpm = $rpm;
        return $this;
    }
}
