<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TechnicalSpecificationDefinitions StructType
 * @subpackage Structs
 */
class TechnicalSpecificationDefinitions extends BaseResponse
{
    /**
     * The definition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TechnicalSpecificationDefinition[]
     */
    public $definition;
    /**
     * Constructor method for TechnicalSpecificationDefinitions
     * @uses TechnicalSpecificationDefinitions::setDefinition()
     * @param \StructType\TechnicalSpecificationDefinition[] $definition
     */
    public function __construct(array $definition = array())
    {
        $this
            ->setDefinition($definition);
    }
    /**
     * Get definition value
     * @return \StructType\TechnicalSpecificationDefinition[]|null
     */
    public function getDefinition()
    {
        return $this->definition;
    }
    /**
     * This method is responsible for validating the values passed to the setDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefinition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefinitionForArrayConstraintsFromSetDefinition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $technicalSpecificationDefinitionsDefinitionItem) {
            // validation for constraint: itemType
            if (!$technicalSpecificationDefinitionsDefinitionItem instanceof \StructType\TechnicalSpecificationDefinition) {
                $invalidValues[] = is_object($technicalSpecificationDefinitionsDefinitionItem) ? get_class($technicalSpecificationDefinitionsDefinitionItem) : sprintf('%s(%s)', gettype($technicalSpecificationDefinitionsDefinitionItem), var_export($technicalSpecificationDefinitionsDefinitionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The definition property can only contain items of type \StructType\TechnicalSpecificationDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set definition value
     * @throws \InvalidArgumentException
     * @param \StructType\TechnicalSpecificationDefinition[] $definition
     * @return \StructType\TechnicalSpecificationDefinitions
     */
    public function setDefinition(array $definition = array())
    {
        // validation for constraint: array
        if ('' !== ($definitionArrayErrorMessage = self::validateDefinitionForArrayConstraintsFromSetDefinition($definition))) {
            throw new \InvalidArgumentException($definitionArrayErrorMessage, __LINE__);
        }
        $this->definition = $definition;
        return $this;
    }
    /**
     * Add item to definition value
     * @throws \InvalidArgumentException
     * @param \StructType\TechnicalSpecificationDefinition $item
     * @return \StructType\TechnicalSpecificationDefinitions
     */
    public function addToDefinition(\StructType\TechnicalSpecificationDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TechnicalSpecificationDefinition) {
            throw new \InvalidArgumentException(sprintf('The definition property can only contain items of type \StructType\TechnicalSpecificationDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->definition[] = $item;
        return $this;
    }
}
