<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubdivisionsRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a list of Chrome subdivision ID's associated with the provided year.
 * @subpackage Structs
 */
class SubdivisionsRequest extends BaseRequest
{
    /**
     * The modelYear
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $modelYear;
    /**
     * Constructor method for SubdivisionsRequest
     * @uses SubdivisionsRequest::setModelYear()
     * @param int $modelYear
     */
    public function __construct($modelYear = null)
    {
        $this
            ->setModelYear($modelYear);
    }
    /**
     * Get modelYear value
     * @return int
     */
    public function getModelYear()
    {
        return $this->modelYear;
    }
    /**
     * Set modelYear value
     * @param int $modelYear
     * @return \StructType\SubdivisionsRequest
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        $this->modelYear = $modelYear;
        return $this;
    }
}
