<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Styles StructType
 * @subpackage Structs
 */
class Styles extends BaseResponse
{
    /**
     * The style
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IdentifiedString[]
     */
    public $style;
    /**
     * Constructor method for Styles
     * @uses Styles::setStyle()
     * @param \StructType\IdentifiedString[] $style
     */
    public function __construct(array $style = array())
    {
        $this
            ->setStyle($style);
    }
    /**
     * Get style value
     * @return \StructType\IdentifiedString[]|null
     */
    public function getStyle()
    {
        return $this->style;
    }
    /**
     * This method is responsible for validating the values passed to the setStyle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStyleForArrayConstraintsFromSetStyle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stylesStyleItem) {
            // validation for constraint: itemType
            if (!$stylesStyleItem instanceof \StructType\IdentifiedString) {
                $invalidValues[] = is_object($stylesStyleItem) ? get_class($stylesStyleItem) : sprintf('%s(%s)', gettype($stylesStyleItem), var_export($stylesStyleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The style property can only contain items of type \StructType\IdentifiedString, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set style value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString[] $style
     * @return \StructType\Styles
     */
    public function setStyle(array $style = array())
    {
        // validation for constraint: array
        if ('' !== ($styleArrayErrorMessage = self::validateStyleForArrayConstraintsFromSetStyle($style))) {
            throw new \InvalidArgumentException($styleArrayErrorMessage, __LINE__);
        }
        $this->style = $style;
        return $this;
    }
    /**
     * Add item to style value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString $item
     * @return \StructType\Styles
     */
    public function addToStyle(\StructType\IdentifiedString $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifiedString) {
            throw new \InvalidArgumentException(sprintf('The style property can only contain items of type \StructType\IdentifiedString, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->style[] = $item;
        return $this;
    }
}
