<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Style StructType
 * @subpackage Structs
 */
class Style extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $id;
    /**
     * The modelYear
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $modelYear;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The division
     * @var \StructType\IdentifiedString
     */
    public $division;
    /**
     * The subdivision
     * @var \StructType\IdentifiedString
     */
    public $subdivision;
    /**
     * The model
     * @var \StructType\IdentifiedString
     */
    public $model;
    /**
     * The basePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Price
     */
    public $basePrice;
    /**
     * The bodyType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BodyType[]
     */
    public $bodyType;
    /**
     * The marketClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentifiedString
     */
    public $marketClass;
    /**
     * The stockImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StockImage
     */
    public $stockImage;
    /**
     * The mediaGallery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MediaGallery
     */
    public $mediaGallery;
    /**
     * The acode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Acode[]
     */
    public $acode;
    /**
     * The nameWoTrim
     * @var string
     */
    public $nameWoTrim;
    /**
     * The trim
     * @var string
     */
    public $trim;
    /**
     * The mfrModelCode
     * @var string
     */
    public $mfrModelCode;
    /**
     * The fleetOnly
     * @var bool
     */
    public $fleetOnly;
    /**
     * The modelFleet
     * @var bool
     */
    public $modelFleet;
    /**
     * The passDoors
     * @var int
     */
    public $passDoors;
    /**
     * The altModelName
     * @var string
     */
    public $altModelName;
    /**
     * The altStyleName
     * @var string
     */
    public $altStyleName;
    /**
     * The altBodyType
     * @var string
     */
    public $altBodyType;
    /**
     * The drivetrain
     * @var string
     */
    public $drivetrain;
    /**
     * Constructor method for Style
     * @uses Style::setId()
     * @uses Style::setModelYear()
     * @uses Style::setName()
     * @uses Style::setDivision()
     * @uses Style::setSubdivision()
     * @uses Style::setModel()
     * @uses Style::setBasePrice()
     * @uses Style::setBodyType()
     * @uses Style::setMarketClass()
     * @uses Style::setStockImage()
     * @uses Style::setMediaGallery()
     * @uses Style::setAcode()
     * @uses Style::setNameWoTrim()
     * @uses Style::setTrim()
     * @uses Style::setMfrModelCode()
     * @uses Style::setFleetOnly()
     * @uses Style::setModelFleet()
     * @uses Style::setPassDoors()
     * @uses Style::setAltModelName()
     * @uses Style::setAltStyleName()
     * @uses Style::setAltBodyType()
     * @uses Style::setDrivetrain()
     * @param int $id
     * @param int $modelYear
     * @param string $name
     * @param \StructType\IdentifiedString $division
     * @param \StructType\IdentifiedString $subdivision
     * @param \StructType\IdentifiedString $model
     * @param \StructType\Price $basePrice
     * @param \StructType\BodyType[] $bodyType
     * @param \StructType\IdentifiedString $marketClass
     * @param \StructType\StockImage $stockImage
     * @param \StructType\MediaGallery $mediaGallery
     * @param \StructType\Acode[] $acode
     * @param string $nameWoTrim
     * @param string $trim
     * @param string $mfrModelCode
     * @param bool $fleetOnly
     * @param bool $modelFleet
     * @param int $passDoors
     * @param string $altModelName
     * @param string $altStyleName
     * @param string $altBodyType
     * @param string $drivetrain
     */
    public function __construct($id = null, $modelYear = null, $name = null, \StructType\IdentifiedString $division = null, \StructType\IdentifiedString $subdivision = null, \StructType\IdentifiedString $model = null, \StructType\Price $basePrice = null, array $bodyType = array(), \StructType\IdentifiedString $marketClass = null, \StructType\StockImage $stockImage = null, \StructType\MediaGallery $mediaGallery = null, array $acode = array(), $nameWoTrim = null, $trim = null, $mfrModelCode = null, $fleetOnly = null, $modelFleet = null, $passDoors = null, $altModelName = null, $altStyleName = null, $altBodyType = null, $drivetrain = null)
    {
        $this
            ->setId($id)
            ->setModelYear($modelYear)
            ->setName($name)
            ->setDivision($division)
            ->setSubdivision($subdivision)
            ->setModel($model)
            ->setBasePrice($basePrice)
            ->setBodyType($bodyType)
            ->setMarketClass($marketClass)
            ->setStockImage($stockImage)
            ->setMediaGallery($mediaGallery)
            ->setAcode($acode)
            ->setNameWoTrim($nameWoTrim)
            ->setTrim($trim)
            ->setMfrModelCode($mfrModelCode)
            ->setFleetOnly($fleetOnly)
            ->setModelFleet($modelFleet)
            ->setPassDoors($passDoors)
            ->setAltModelName($altModelName)
            ->setAltStyleName($altStyleName)
            ->setAltBodyType($altBodyType)
            ->setDrivetrain($drivetrain);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Style
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get modelYear value
     * @return int
     */
    public function getModelYear()
    {
        return $this->modelYear;
    }
    /**
     * Set modelYear value
     * @param int $modelYear
     * @return \StructType\Style
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        $this->modelYear = $modelYear;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Style
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get division value
     * @return \StructType\IdentifiedString|null
     */
    public function getDivision()
    {
        return $this->division;
    }
    /**
     * Set division value
     * @param \StructType\IdentifiedString $division
     * @return \StructType\Style
     */
    public function setDivision(\StructType\IdentifiedString $division = null)
    {
        $this->division = $division;
        return $this;
    }
    /**
     * Get subdivision value
     * @return \StructType\IdentifiedString|null
     */
    public function getSubdivision()
    {
        return $this->subdivision;
    }
    /**
     * Set subdivision value
     * @param \StructType\IdentifiedString $subdivision
     * @return \StructType\Style
     */
    public function setSubdivision(\StructType\IdentifiedString $subdivision = null)
    {
        $this->subdivision = $subdivision;
        return $this;
    }
    /**
     * Get model value
     * @return \StructType\IdentifiedString|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param \StructType\IdentifiedString $model
     * @return \StructType\Style
     */
    public function setModel(\StructType\IdentifiedString $model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get basePrice value
     * @return \StructType\Price|null
     */
    public function getBasePrice()
    {
        return $this->basePrice;
    }
    /**
     * Set basePrice value
     * @param \StructType\Price $basePrice
     * @return \StructType\Style
     */
    public function setBasePrice(\StructType\Price $basePrice = null)
    {
        $this->basePrice = $basePrice;
        return $this;
    }
    /**
     * Get bodyType value
     * @return \StructType\BodyType[]|null
     */
    public function getBodyType()
    {
        return $this->bodyType;
    }
    /**
     * This method is responsible for validating the values passed to the setBodyType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBodyType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBodyTypeForArrayConstraintsFromSetBodyType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $styleBodyTypeItem) {
            // validation for constraint: itemType
            if (!$styleBodyTypeItem instanceof \StructType\BodyType) {
                $invalidValues[] = is_object($styleBodyTypeItem) ? get_class($styleBodyTypeItem) : sprintf('%s(%s)', gettype($styleBodyTypeItem), var_export($styleBodyTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bodyType property can only contain items of type \StructType\BodyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bodyType value
     * @throws \InvalidArgumentException
     * @param \StructType\BodyType[] $bodyType
     * @return \StructType\Style
     */
    public function setBodyType(array $bodyType = array())
    {
        // validation for constraint: array
        if ('' !== ($bodyTypeArrayErrorMessage = self::validateBodyTypeForArrayConstraintsFromSetBodyType($bodyType))) {
            throw new \InvalidArgumentException($bodyTypeArrayErrorMessage, __LINE__);
        }
        $this->bodyType = $bodyType;
        return $this;
    }
    /**
     * Add item to bodyType value
     * @throws \InvalidArgumentException
     * @param \StructType\BodyType $item
     * @return \StructType\Style
     */
    public function addToBodyType(\StructType\BodyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BodyType) {
            throw new \InvalidArgumentException(sprintf('The bodyType property can only contain items of type \StructType\BodyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bodyType[] = $item;
        return $this;
    }
    /**
     * Get marketClass value
     * @return \StructType\IdentifiedString|null
     */
    public function getMarketClass()
    {
        return $this->marketClass;
    }
    /**
     * Set marketClass value
     * @param \StructType\IdentifiedString $marketClass
     * @return \StructType\Style
     */
    public function setMarketClass(\StructType\IdentifiedString $marketClass = null)
    {
        $this->marketClass = $marketClass;
        return $this;
    }
    /**
     * Get stockImage value
     * @return \StructType\StockImage|null
     */
    public function getStockImage()
    {
        return $this->stockImage;
    }
    /**
     * Set stockImage value
     * @param \StructType\StockImage $stockImage
     * @return \StructType\Style
     */
    public function setStockImage(\StructType\StockImage $stockImage = null)
    {
        $this->stockImage = $stockImage;
        return $this;
    }
    /**
     * Get mediaGallery value
     * @return \StructType\MediaGallery|null
     */
    public function getMediaGallery()
    {
        return $this->mediaGallery;
    }
    /**
     * Set mediaGallery value
     * @param \StructType\MediaGallery $mediaGallery
     * @return \StructType\Style
     */
    public function setMediaGallery(\StructType\MediaGallery $mediaGallery = null)
    {
        $this->mediaGallery = $mediaGallery;
        return $this;
    }
    /**
     * Get acode value
     * @return \StructType\Acode[]|null
     */
    public function getAcode()
    {
        return $this->acode;
    }
    /**
     * This method is responsible for validating the values passed to the setAcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcodeForArrayConstraintsFromSetAcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $styleAcodeItem) {
            // validation for constraint: itemType
            if (!$styleAcodeItem instanceof \StructType\Acode) {
                $invalidValues[] = is_object($styleAcodeItem) ? get_class($styleAcodeItem) : sprintf('%s(%s)', gettype($styleAcodeItem), var_export($styleAcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The acode property can only contain items of type \StructType\Acode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set acode value
     * @throws \InvalidArgumentException
     * @param \StructType\Acode[] $acode
     * @return \StructType\Style
     */
    public function setAcode(array $acode = array())
    {
        // validation for constraint: array
        if ('' !== ($acodeArrayErrorMessage = self::validateAcodeForArrayConstraintsFromSetAcode($acode))) {
            throw new \InvalidArgumentException($acodeArrayErrorMessage, __LINE__);
        }
        $this->acode = $acode;
        return $this;
    }
    /**
     * Add item to acode value
     * @throws \InvalidArgumentException
     * @param \StructType\Acode $item
     * @return \StructType\Style
     */
    public function addToAcode(\StructType\Acode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Acode) {
            throw new \InvalidArgumentException(sprintf('The acode property can only contain items of type \StructType\Acode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->acode[] = $item;
        return $this;
    }
    /**
     * Get nameWoTrim value
     * @return string|null
     */
    public function getNameWoTrim()
    {
        return $this->nameWoTrim;
    }
    /**
     * Set nameWoTrim value
     * @param string $nameWoTrim
     * @return \StructType\Style
     */
    public function setNameWoTrim($nameWoTrim = null)
    {
        // validation for constraint: string
        if (!is_null($nameWoTrim) && !is_string($nameWoTrim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameWoTrim, true), gettype($nameWoTrim)), __LINE__);
        }
        $this->nameWoTrim = $nameWoTrim;
        return $this;
    }
    /**
     * Get trim value
     * @return string|null
     */
    public function getTrim()
    {
        return $this->trim;
    }
    /**
     * Set trim value
     * @param string $trim
     * @return \StructType\Style
     */
    public function setTrim($trim = null)
    {
        // validation for constraint: string
        if (!is_null($trim) && !is_string($trim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trim, true), gettype($trim)), __LINE__);
        }
        $this->trim = $trim;
        return $this;
    }
    /**
     * Get mfrModelCode value
     * @return string|null
     */
    public function getMfrModelCode()
    {
        return $this->mfrModelCode;
    }
    /**
     * Set mfrModelCode value
     * @param string $mfrModelCode
     * @return \StructType\Style
     */
    public function setMfrModelCode($mfrModelCode = null)
    {
        // validation for constraint: string
        if (!is_null($mfrModelCode) && !is_string($mfrModelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mfrModelCode, true), gettype($mfrModelCode)), __LINE__);
        }
        $this->mfrModelCode = $mfrModelCode;
        return $this;
    }
    /**
     * Get fleetOnly value
     * @return bool|null
     */
    public function getFleetOnly()
    {
        return $this->fleetOnly;
    }
    /**
     * Set fleetOnly value
     * @param bool $fleetOnly
     * @return \StructType\Style
     */
    public function setFleetOnly($fleetOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($fleetOnly) && !is_bool($fleetOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fleetOnly, true), gettype($fleetOnly)), __LINE__);
        }
        $this->fleetOnly = $fleetOnly;
        return $this;
    }
    /**
     * Get modelFleet value
     * @return bool|null
     */
    public function getModelFleet()
    {
        return $this->modelFleet;
    }
    /**
     * Set modelFleet value
     * @param bool $modelFleet
     * @return \StructType\Style
     */
    public function setModelFleet($modelFleet = null)
    {
        // validation for constraint: boolean
        if (!is_null($modelFleet) && !is_bool($modelFleet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modelFleet, true), gettype($modelFleet)), __LINE__);
        }
        $this->modelFleet = $modelFleet;
        return $this;
    }
    /**
     * Get passDoors value
     * @return int|null
     */
    public function getPassDoors()
    {
        return $this->passDoors;
    }
    /**
     * Set passDoors value
     * @param int $passDoors
     * @return \StructType\Style
     */
    public function setPassDoors($passDoors = null)
    {
        // validation for constraint: int
        if (!is_null($passDoors) && !(is_int($passDoors) || ctype_digit($passDoors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passDoors, true), gettype($passDoors)), __LINE__);
        }
        $this->passDoors = $passDoors;
        return $this;
    }
    /**
     * Get altModelName value
     * @return string|null
     */
    public function getAltModelName()
    {
        return $this->altModelName;
    }
    /**
     * Set altModelName value
     * @param string $altModelName
     * @return \StructType\Style
     */
    public function setAltModelName($altModelName = null)
    {
        // validation for constraint: string
        if (!is_null($altModelName) && !is_string($altModelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altModelName, true), gettype($altModelName)), __LINE__);
        }
        $this->altModelName = $altModelName;
        return $this;
    }
    /**
     * Get altStyleName value
     * @return string|null
     */
    public function getAltStyleName()
    {
        return $this->altStyleName;
    }
    /**
     * Set altStyleName value
     * @param string $altStyleName
     * @return \StructType\Style
     */
    public function setAltStyleName($altStyleName = null)
    {
        // validation for constraint: string
        if (!is_null($altStyleName) && !is_string($altStyleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altStyleName, true), gettype($altStyleName)), __LINE__);
        }
        $this->altStyleName = $altStyleName;
        return $this;
    }
    /**
     * Get altBodyType value
     * @return string|null
     */
    public function getAltBodyType()
    {
        return $this->altBodyType;
    }
    /**
     * Set altBodyType value
     * @param string $altBodyType
     * @return \StructType\Style
     */
    public function setAltBodyType($altBodyType = null)
    {
        // validation for constraint: string
        if (!is_null($altBodyType) && !is_string($altBodyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altBodyType, true), gettype($altBodyType)), __LINE__);
        }
        $this->altBodyType = $altBodyType;
        return $this;
    }
    /**
     * Get drivetrain value
     * @return string|null
     */
    public function getDrivetrain()
    {
        return $this->drivetrain;
    }
    /**
     * Set drivetrain value
     * @uses \EnumType\DriveTrain::valueIsValid()
     * @uses \EnumType\DriveTrain::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $drivetrain
     * @return \StructType\Style
     */
    public function setDrivetrain($drivetrain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DriveTrain::valueIsValid($drivetrain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DriveTrain', is_array($drivetrain) ? implode(', ', $drivetrain) : var_export($drivetrain, true), implode(', ', \EnumType\DriveTrain::getValidValues())), __LINE__);
        }
        $this->drivetrain = $drivetrain;
        return $this;
    }
}
