<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Standard StructType
 * @subpackage Structs
 */
class Standard extends AbstractStructBase
{
    /**
     * The header
     * @var \StructType\IdentifiedString
     */
    public $header;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryAssociation[]
     */
    public $category;
    /**
     * The styleId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $styleId;
    /**
     * The installed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallationCause
     */
    public $installed;
    /**
     * Constructor method for Standard
     * @uses Standard::setHeader()
     * @uses Standard::setDescription()
     * @uses Standard::setCategory()
     * @uses Standard::setStyleId()
     * @uses Standard::setInstalled()
     * @param \StructType\IdentifiedString $header
     * @param string $description
     * @param \StructType\CategoryAssociation[] $category
     * @param int[] $styleId
     * @param \StructType\InstallationCause $installed
     */
    public function __construct(\StructType\IdentifiedString $header = null, $description = null, array $category = array(), array $styleId = array(), \StructType\InstallationCause $installed = null)
    {
        $this
            ->setHeader($header)
            ->setDescription($description)
            ->setCategory($category)
            ->setStyleId($styleId)
            ->setInstalled($installed);
    }
    /**
     * Get header value
     * @return \StructType\IdentifiedString|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param \StructType\IdentifiedString $header
     * @return \StructType\Standard
     */
    public function setHeader(\StructType\IdentifiedString $header = null)
    {
        $this->header = $header;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Standard
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\CategoryAssociation[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryForArrayConstraintsFromSetCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $standardCategoryItem) {
            // validation for constraint: itemType
            if (!$standardCategoryItem instanceof \StructType\CategoryAssociation) {
                $invalidValues[] = is_object($standardCategoryItem) ? get_class($standardCategoryItem) : sprintf('%s(%s)', gettype($standardCategoryItem), var_export($standardCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category property can only contain items of type \StructType\CategoryAssociation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAssociation[] $category
     * @return \StructType\Standard
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryArrayErrorMessage = self::validateCategoryForArrayConstraintsFromSetCategory($category))) {
            throw new \InvalidArgumentException($categoryArrayErrorMessage, __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAssociation $item
     * @return \StructType\Standard
     */
    public function addToCategory(\StructType\CategoryAssociation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryAssociation) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of type \StructType\CategoryAssociation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
    /**
     * Get styleId value
     * @return int[]|null
     */
    public function getStyleId()
    {
        return $this->styleId;
    }
    /**
     * This method is responsible for validating the values passed to the setStyleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyleId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStyleIdForArrayConstraintsFromSetStyleId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $standardStyleIdItem) {
            // validation for constraint: itemType
            if (!(is_int($standardStyleIdItem) || ctype_digit($standardStyleIdItem))) {
                $invalidValues[] = is_object($standardStyleIdItem) ? get_class($standardStyleIdItem) : sprintf('%s(%s)', gettype($standardStyleIdItem), var_export($standardStyleIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The styleId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set styleId value
     * @throws \InvalidArgumentException
     * @param int[] $styleId
     * @return \StructType\Standard
     */
    public function setStyleId(array $styleId = array())
    {
        // validation for constraint: array
        if ('' !== ($styleIdArrayErrorMessage = self::validateStyleIdForArrayConstraintsFromSetStyleId($styleId))) {
            throw new \InvalidArgumentException($styleIdArrayErrorMessage, __LINE__);
        }
        $this->styleId = $styleId;
        return $this;
    }
    /**
     * Add item to styleId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Standard
     */
    public function addToStyleId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The styleId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->styleId[] = $item;
        return $this;
    }
    /**
     * Get installed value
     * @return \StructType\InstallationCause|null
     */
    public function getInstalled()
    {
        return $this->installed;
    }
    /**
     * Set installed value
     * @param \StructType\InstallationCause $installed
     * @return \StructType\Standard
     */
    public function setInstalled(\StructType\InstallationCause $installed = null)
    {
        $this->installed = $installed;
        return $this;
    }
}
