<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for range StructType
 * @subpackage Structs
 */
class Range_1 extends AbstractStructBase
{
    /**
     * The min
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $min;
    /**
     * The max
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $max;
    /**
     * Constructor method for range
     * @uses Range_1::setMin()
     * @uses Range_1::setMax()
     * @param float $min
     * @param float $max
     */
    public function __construct($min = null, $max = null)
    {
        $this
            ->setMin($min)
            ->setMax($max);
    }
    /**
     * Get min value
     * @return float
     */
    public function getMin()
    {
        return $this->min;
    }
    /**
     * Set min value
     * @param float $min
     * @return \StructType\Range_1
     */
    public function setMin($min = null)
    {
        // validation for constraint: float
        if (!is_null($min) && !(is_float($min) || is_numeric($min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($min, true), gettype($min)), __LINE__);
        }
        $this->min = $min;
        return $this;
    }
    /**
     * Get max value
     * @return float
     */
    public function getMax()
    {
        return $this->max;
    }
    /**
     * Set max value
     * @param float $max
     * @return \StructType\Range_1
     */
    public function setMax($max = null)
    {
        // validation for constraint: float
        if (!is_null($max) && !(is_float($max) || is_numeric($max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max, true), gettype($max)), __LINE__);
        }
        $this->max = $max;
        return $this;
    }
}
