<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Range StructType
 * @subpackage Structs
 */
class Range extends AbstractStructBase
{
    /**
     * The low
     * @var float
     */
    public $low;
    /**
     * The high
     * @var float
     */
    public $high;
    /**
     * Constructor method for Range
     * @uses Range::setLow()
     * @uses Range::setHigh()
     * @param float $low
     * @param float $high
     */
    public function __construct($low = null, $high = null)
    {
        $this
            ->setLow($low)
            ->setHigh($high);
    }
    /**
     * Get low value
     * @return float|null
     */
    public function getLow()
    {
        return $this->low;
    }
    /**
     * Set low value
     * @param float $low
     * @return \StructType\Range
     */
    public function setLow($low = null)
    {
        // validation for constraint: float
        if (!is_null($low) && !(is_float($low) || is_numeric($low))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($low, true), gettype($low)), __LINE__);
        }
        $this->low = $low;
        return $this;
    }
    /**
     * Get high value
     * @return float|null
     */
    public function getHigh()
    {
        return $this->high;
    }
    /**
     * Set high value
     * @param float $high
     * @return \StructType\Range
     */
    public function setHigh($high = null)
    {
        // validation for constraint: float
        if (!is_null($high) && !(is_float($high) || is_numeric($high))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($high, true), gettype($high)), __LINE__);
        }
        $this->high = $high;
        return $this;
    }
}
