<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Price StructType
 * @subpackage Structs
 */
class Price extends AbstractStructBase
{
    /**
     * The unknown
     * @var bool
     */
    public $unknown;
    /**
     * The invoice
     * @var float
     */
    public $invoice;
    /**
     * The msrp
     * @var float
     */
    public $msrp;
    /**
     * The destination
     * @var float
     */
    public $destination;
    /**
     * Constructor method for Price
     * @uses Price::setUnknown()
     * @uses Price::setInvoice()
     * @uses Price::setMsrp()
     * @uses Price::setDestination()
     * @param bool $unknown
     * @param float $invoice
     * @param float $msrp
     * @param float $destination
     */
    public function __construct($unknown = null, $invoice = null, $msrp = null, $destination = null)
    {
        $this
            ->setUnknown($unknown)
            ->setInvoice($invoice)
            ->setMsrp($msrp)
            ->setDestination($destination);
    }
    /**
     * Get unknown value
     * @return bool|null
     */
    public function getUnknown()
    {
        return $this->unknown;
    }
    /**
     * Set unknown value
     * @param bool $unknown
     * @return \StructType\Price
     */
    public function setUnknown($unknown = null)
    {
        // validation for constraint: boolean
        if (!is_null($unknown) && !is_bool($unknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unknown, true), gettype($unknown)), __LINE__);
        }
        $this->unknown = $unknown;
        return $this;
    }
    /**
     * Get invoice value
     * @return float|null
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param float $invoice
     * @return \StructType\Price
     */
    public function setInvoice($invoice = null)
    {
        // validation for constraint: float
        if (!is_null($invoice) && !(is_float($invoice) || is_numeric($invoice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoice, true), gettype($invoice)), __LINE__);
        }
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Get msrp value
     * @return float|null
     */
    public function getMsrp()
    {
        return $this->msrp;
    }
    /**
     * Set msrp value
     * @param float $msrp
     * @return \StructType\Price
     */
    public function setMsrp($msrp = null)
    {
        // validation for constraint: float
        if (!is_null($msrp) && !(is_float($msrp) || is_numeric($msrp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($msrp, true), gettype($msrp)), __LINE__);
        }
        $this->msrp = $msrp;
        return $this;
    }
    /**
     * Get destination value
     * @return float|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param float $destination
     * @return \StructType\Price
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: float
        if (!is_null($destination) && !(is_float($destination) || is_numeric($destination))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
}
