<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionPrice StructType
 * @subpackage Structs
 */
class OptionPrice extends AbstractStructBase
{
    /**
     * The unknown
     * @var bool
     */
    public $unknown;
    /**
     * The invoiceMin
     * @var float
     */
    public $invoiceMin;
    /**
     * The invoiceMax
     * @var float
     */
    public $invoiceMax;
    /**
     * The msrpMin
     * @var float
     */
    public $msrpMin;
    /**
     * The msrpMax
     * @var float
     */
    public $msrpMax;
    /**
     * Constructor method for OptionPrice
     * @uses OptionPrice::setUnknown()
     * @uses OptionPrice::setInvoiceMin()
     * @uses OptionPrice::setInvoiceMax()
     * @uses OptionPrice::setMsrpMin()
     * @uses OptionPrice::setMsrpMax()
     * @param bool $unknown
     * @param float $invoiceMin
     * @param float $invoiceMax
     * @param float $msrpMin
     * @param float $msrpMax
     */
    public function __construct($unknown = null, $invoiceMin = null, $invoiceMax = null, $msrpMin = null, $msrpMax = null)
    {
        $this
            ->setUnknown($unknown)
            ->setInvoiceMin($invoiceMin)
            ->setInvoiceMax($invoiceMax)
            ->setMsrpMin($msrpMin)
            ->setMsrpMax($msrpMax);
    }
    /**
     * Get unknown value
     * @return bool|null
     */
    public function getUnknown()
    {
        return $this->unknown;
    }
    /**
     * Set unknown value
     * @param bool $unknown
     * @return \StructType\OptionPrice
     */
    public function setUnknown($unknown = null)
    {
        // validation for constraint: boolean
        if (!is_null($unknown) && !is_bool($unknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unknown, true), gettype($unknown)), __LINE__);
        }
        $this->unknown = $unknown;
        return $this;
    }
    /**
     * Get invoiceMin value
     * @return float|null
     */
    public function getInvoiceMin()
    {
        return $this->invoiceMin;
    }
    /**
     * Set invoiceMin value
     * @param float $invoiceMin
     * @return \StructType\OptionPrice
     */
    public function setInvoiceMin($invoiceMin = null)
    {
        // validation for constraint: float
        if (!is_null($invoiceMin) && !(is_float($invoiceMin) || is_numeric($invoiceMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoiceMin, true), gettype($invoiceMin)), __LINE__);
        }
        $this->invoiceMin = $invoiceMin;
        return $this;
    }
    /**
     * Get invoiceMax value
     * @return float|null
     */
    public function getInvoiceMax()
    {
        return $this->invoiceMax;
    }
    /**
     * Set invoiceMax value
     * @param float $invoiceMax
     * @return \StructType\OptionPrice
     */
    public function setInvoiceMax($invoiceMax = null)
    {
        // validation for constraint: float
        if (!is_null($invoiceMax) && !(is_float($invoiceMax) || is_numeric($invoiceMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoiceMax, true), gettype($invoiceMax)), __LINE__);
        }
        $this->invoiceMax = $invoiceMax;
        return $this;
    }
    /**
     * Get msrpMin value
     * @return float|null
     */
    public function getMsrpMin()
    {
        return $this->msrpMin;
    }
    /**
     * Set msrpMin value
     * @param float $msrpMin
     * @return \StructType\OptionPrice
     */
    public function setMsrpMin($msrpMin = null)
    {
        // validation for constraint: float
        if (!is_null($msrpMin) && !(is_float($msrpMin) || is_numeric($msrpMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($msrpMin, true), gettype($msrpMin)), __LINE__);
        }
        $this->msrpMin = $msrpMin;
        return $this;
    }
    /**
     * Get msrpMax value
     * @return float|null
     */
    public function getMsrpMax()
    {
        return $this->msrpMax;
    }
    /**
     * Set msrpMax value
     * @param float $msrpMax
     * @return \StructType\OptionPrice
     */
    public function setMsrpMax($msrpMax = null)
    {
        // validation for constraint: float
        if (!is_null($msrpMax) && !(is_float($msrpMax) || is_numeric($msrpMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($msrpMax, true), gettype($msrpMax)), __LINE__);
        }
        $this->msrpMax = $msrpMax;
        return $this;
    }
}
