<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Models StructType
 * @subpackage Structs
 */
class Models extends BaseResponse
{
    /**
     * The model
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IdentifiedString[]
     */
    public $model;
    /**
     * Constructor method for Models
     * @uses Models::setModel()
     * @param \StructType\IdentifiedString[] $model
     */
    public function __construct(array $model = array())
    {
        $this
            ->setModel($model);
    }
    /**
     * Get model value
     * @return \StructType\IdentifiedString[]|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * This method is responsible for validating the values passed to the setModel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModelForArrayConstraintsFromSetModel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $modelsModelItem) {
            // validation for constraint: itemType
            if (!$modelsModelItem instanceof \StructType\IdentifiedString) {
                $invalidValues[] = is_object($modelsModelItem) ? get_class($modelsModelItem) : sprintf('%s(%s)', gettype($modelsModelItem), var_export($modelsModelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The model property can only contain items of type \StructType\IdentifiedString, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set model value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString[] $model
     * @return \StructType\Models
     */
    public function setModel(array $model = array())
    {
        // validation for constraint: array
        if ('' !== ($modelArrayErrorMessage = self::validateModelForArrayConstraintsFromSetModel($model))) {
            throw new \InvalidArgumentException($modelArrayErrorMessage, __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Add item to model value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString $item
     * @return \StructType\Models
     */
    public function addToModel(\StructType\IdentifiedString $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifiedString) {
            throw new \InvalidArgumentException(sprintf('The model property can only contain items of type \StructType\IdentifiedString, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->model[] = $item;
        return $this;
    }
}
