<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModelYears StructType
 * @subpackage Structs
 */
class ModelYears extends BaseResponse
{
    /**
     * The modelYear
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $modelYear;
    /**
     * Constructor method for ModelYears
     * @uses ModelYears::setModelYear()
     * @param int[] $modelYear
     */
    public function __construct(array $modelYear = array())
    {
        $this
            ->setModelYear($modelYear);
    }
    /**
     * Get modelYear value
     * @return int[]|null
     */
    public function getModelYear()
    {
        return $this->modelYear;
    }
    /**
     * This method is responsible for validating the values passed to the setModelYear method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModelYear method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModelYearForArrayConstraintsFromSetModelYear(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $modelYearsModelYearItem) {
            // validation for constraint: itemType
            if (!(is_int($modelYearsModelYearItem) || ctype_digit($modelYearsModelYearItem))) {
                $invalidValues[] = is_object($modelYearsModelYearItem) ? get_class($modelYearsModelYearItem) : sprintf('%s(%s)', gettype($modelYearsModelYearItem), var_export($modelYearsModelYearItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The modelYear property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set modelYear value
     * @throws \InvalidArgumentException
     * @param int[] $modelYear
     * @return \StructType\ModelYears
     */
    public function setModelYear(array $modelYear = array())
    {
        // validation for constraint: array
        if ('' !== ($modelYearArrayErrorMessage = self::validateModelYearForArrayConstraintsFromSetModelYear($modelYear))) {
            throw new \InvalidArgumentException($modelYearArrayErrorMessage, __LINE__);
        }
        $this->modelYear = $modelYear;
        return $this;
    }
    /**
     * Add item to modelYear value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ModelYears
     */
    public function addToModelYear($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The modelYear property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->modelYear[] = $item;
        return $this;
    }
}
