<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MediaGallery StructType
 * @subpackage Structs
 */
class MediaGallery extends AbstractStructBase
{
    /**
     * The view
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\View[]
     */
    public $view;
    /**
     * The colorized
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Colorized[]
     */
    public $colorized;
    /**
     * The styleId
     * @var int
     */
    public $styleId;
    /**
     * Constructor method for MediaGallery
     * @uses MediaGallery::setView()
     * @uses MediaGallery::setColorized()
     * @uses MediaGallery::setStyleId()
     * @param \StructType\View[] $view
     * @param \StructType\Colorized[] $colorized
     * @param int $styleId
     */
    public function __construct(array $view = array(), array $colorized = array(), $styleId = null)
    {
        $this
            ->setView($view)
            ->setColorized($colorized)
            ->setStyleId($styleId);
    }
    /**
     * Get view value
     * @return \StructType\View[]|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * This method is responsible for validating the values passed to the setView method
     * This method is willingly generated in order to preserve the one-line inline validation within the setView method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViewForArrayConstraintsFromSetView(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mediaGalleryViewItem) {
            // validation for constraint: itemType
            if (!$mediaGalleryViewItem instanceof \StructType\View) {
                $invalidValues[] = is_object($mediaGalleryViewItem) ? get_class($mediaGalleryViewItem) : sprintf('%s(%s)', gettype($mediaGalleryViewItem), var_export($mediaGalleryViewItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The view property can only contain items of type \StructType\View, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set view value
     * @throws \InvalidArgumentException
     * @param \StructType\View[] $view
     * @return \StructType\MediaGallery
     */
    public function setView(array $view = array())
    {
        // validation for constraint: array
        if ('' !== ($viewArrayErrorMessage = self::validateViewForArrayConstraintsFromSetView($view))) {
            throw new \InvalidArgumentException($viewArrayErrorMessage, __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Add item to view value
     * @throws \InvalidArgumentException
     * @param \StructType\View $item
     * @return \StructType\MediaGallery
     */
    public function addToView(\StructType\View $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\View) {
            throw new \InvalidArgumentException(sprintf('The view property can only contain items of type \StructType\View, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->view[] = $item;
        return $this;
    }
    /**
     * Get colorized value
     * @return \StructType\Colorized[]|null
     */
    public function getColorized()
    {
        return $this->colorized;
    }
    /**
     * This method is responsible for validating the values passed to the setColorized method
     * This method is willingly generated in order to preserve the one-line inline validation within the setColorized method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateColorizedForArrayConstraintsFromSetColorized(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mediaGalleryColorizedItem) {
            // validation for constraint: itemType
            if (!$mediaGalleryColorizedItem instanceof \StructType\Colorized) {
                $invalidValues[] = is_object($mediaGalleryColorizedItem) ? get_class($mediaGalleryColorizedItem) : sprintf('%s(%s)', gettype($mediaGalleryColorizedItem), var_export($mediaGalleryColorizedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The colorized property can only contain items of type \StructType\Colorized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set colorized value
     * @throws \InvalidArgumentException
     * @param \StructType\Colorized[] $colorized
     * @return \StructType\MediaGallery
     */
    public function setColorized(array $colorized = array())
    {
        // validation for constraint: array
        if ('' !== ($colorizedArrayErrorMessage = self::validateColorizedForArrayConstraintsFromSetColorized($colorized))) {
            throw new \InvalidArgumentException($colorizedArrayErrorMessage, __LINE__);
        }
        $this->colorized = $colorized;
        return $this;
    }
    /**
     * Add item to colorized value
     * @throws \InvalidArgumentException
     * @param \StructType\Colorized $item
     * @return \StructType\MediaGallery
     */
    public function addToColorized(\StructType\Colorized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Colorized) {
            throw new \InvalidArgumentException(sprintf('The colorized property can only contain items of type \StructType\Colorized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->colorized[] = $item;
        return $this;
    }
    /**
     * Get styleId value
     * @return int|null
     */
    public function getStyleId()
    {
        return $this->styleId;
    }
    /**
     * Set styleId value
     * @param int $styleId
     * @return \StructType\MediaGallery
     */
    public function setStyleId($styleId = null)
    {
        // validation for constraint: int
        if (!is_null($styleId) && !(is_int($styleId) || ctype_digit($styleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($styleId, true), gettype($styleId)), __LINE__);
        }
        $this->styleId = $styleId;
        return $this;
    }
}
