<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchedNonFactoryEquipment StructType
 * @subpackage Structs
 */
class MatchedNonFactoryEquipment extends AbstractStructBase
{
    /**
     * The equipmentDescription
     * @var string
     */
    public $equipmentDescription;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CategoryDefinition[]
     */
    public $category;
    /**
     * The installed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallationCause
     */
    public $installed;
    /**
     * Constructor method for MatchedNonFactoryEquipment
     * @uses MatchedNonFactoryEquipment::setEquipmentDescription()
     * @uses MatchedNonFactoryEquipment::setCategory()
     * @uses MatchedNonFactoryEquipment::setInstalled()
     * @param string $equipmentDescription
     * @param \StructType\CategoryDefinition[] $category
     * @param \StructType\InstallationCause $installed
     */
    public function __construct($equipmentDescription = null, array $category = array(), \StructType\InstallationCause $installed = null)
    {
        $this
            ->setEquipmentDescription($equipmentDescription)
            ->setCategory($category)
            ->setInstalled($installed);
    }
    /**
     * Get equipmentDescription value
     * @return string|null
     */
    public function getEquipmentDescription()
    {
        return $this->equipmentDescription;
    }
    /**
     * Set equipmentDescription value
     * @param string $equipmentDescription
     * @return \StructType\MatchedNonFactoryEquipment
     */
    public function setEquipmentDescription($equipmentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentDescription) && !is_string($equipmentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentDescription, true), gettype($equipmentDescription)), __LINE__);
        }
        $this->equipmentDescription = $equipmentDescription;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\CategoryDefinition[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryForArrayConstraintsFromSetCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $matchedNonFactoryEquipmentCategoryItem) {
            // validation for constraint: itemType
            if (!$matchedNonFactoryEquipmentCategoryItem instanceof \StructType\CategoryDefinition) {
                $invalidValues[] = is_object($matchedNonFactoryEquipmentCategoryItem) ? get_class($matchedNonFactoryEquipmentCategoryItem) : sprintf('%s(%s)', gettype($matchedNonFactoryEquipmentCategoryItem), var_export($matchedNonFactoryEquipmentCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category property can only contain items of type \StructType\CategoryDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDefinition[] $category
     * @return \StructType\MatchedNonFactoryEquipment
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryArrayErrorMessage = self::validateCategoryForArrayConstraintsFromSetCategory($category))) {
            throw new \InvalidArgumentException($categoryArrayErrorMessage, __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDefinition $item
     * @return \StructType\MatchedNonFactoryEquipment
     */
    public function addToCategory(\StructType\CategoryDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryDefinition) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of type \StructType\CategoryDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
    /**
     * Get installed value
     * @return \StructType\InstallationCause|null
     */
    public function getInstalled()
    {
        return $this->installed;
    }
    /**
     * Set installed value
     * @param \StructType\InstallationCause $installed
     * @return \StructType\MatchedNonFactoryEquipment
     */
    public function setInstalled(\StructType\InstallationCause $installed = null)
    {
        $this->installed = $installed;
        return $this;
    }
}
