<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstallationCause StructType
 * @subpackage Structs
 */
class InstallationCause extends AbstractStructBase
{
    /**
     * The cause
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $cause;
    /**
     * The detail
     * @var string
     */
    public $detail;
    /**
     * Constructor method for InstallationCause
     * @uses InstallationCause::setCause()
     * @uses InstallationCause::setDetail()
     * @param string $cause
     * @param string $detail
     */
    public function __construct($cause = null, $detail = null)
    {
        $this
            ->setCause($cause)
            ->setDetail($detail);
    }
    /**
     * Get cause value
     * @return string
     */
    public function getCause()
    {
        return $this->cause;
    }
    /**
     * Set cause value
     * @param string $cause
     * @return \StructType\InstallationCause
     */
    public function setCause($cause = null)
    {
        // validation for constraint: string
        if (!is_null($cause) && !is_string($cause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cause, true), gettype($cause)), __LINE__);
        }
        $this->cause = $cause;
        return $this;
    }
    /**
     * Get detail value
     * @return string|null
     */
    public function getDetail()
    {
        return $this->detail;
    }
    /**
     * Set detail value
     * @param string $detail
     * @return \StructType\InstallationCause
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        $this->detail = $detail;
        return $this;
    }
}
