<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericEquipment StructType
 * @subpackage Structs
 */
class GenericEquipment extends AbstractStructBase
{
    /**
     * The categoryId
     * Meta information extracted from the WSDL
     * - choice: categoryId | definition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $categoryId;
    /**
     * The definition
     * Meta information extracted from the WSDL
     * - choice: categoryId | definition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CategoryDefinition
     */
    public $definition;
    /**
     * The styleId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $styleId;
    /**
     * The installed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallationCause
     */
    public $installed;
    /**
     * Constructor method for GenericEquipment
     * @uses GenericEquipment::setCategoryId()
     * @uses GenericEquipment::setDefinition()
     * @uses GenericEquipment::setStyleId()
     * @uses GenericEquipment::setInstalled()
     * @param int $categoryId
     * @param \StructType\CategoryDefinition $definition
     * @param int[] $styleId
     * @param \StructType\InstallationCause $installed
     */
    public function __construct($categoryId = null, \StructType\CategoryDefinition $definition = null, array $styleId = array(), \StructType\InstallationCause $installed = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setDefinition($definition)
            ->setStyleId($styleId)
            ->setInstalled($installed);
    }
    /**
     * Get categoryId value
     * @return int|null
     */
    public function getCategoryId()
    {
        return isset($this->categoryId) ? $this->categoryId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCategoryId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategoryId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCategoryIdForChoiceConstraintsFromSetCategoryId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'definition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property categoryId can\'t be set as the property %s is already set. Only one property must be set among these properties: categoryId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set categoryId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $categoryId
     * @return \StructType\GenericEquipment
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: choice(categoryId, definition)
        if ('' !== ($categoryIdChoiceErrorMessage = self::validateCategoryIdForChoiceConstraintsFromSetCategoryId($categoryId))) {
            throw new \InvalidArgumentException($categoryIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->categoryId);
        } else {
            $this->categoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get definition value
     * @return \StructType\CategoryDefinition|null
     */
    public function getDefinition()
    {
        return isset($this->definition) ? $this->definition : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefinition method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDefinitionForChoiceConstraintsFromSetDefinition($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'categoryId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property definition can\'t be set as the property %s is already set. Only one property must be set among these properties: definition, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set definition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDefinition $definition
     * @return \StructType\GenericEquipment
     */
    public function setDefinition(\StructType\CategoryDefinition $definition = null)
    {
        // validation for constraint: choice(categoryId, definition)
        if ('' !== ($definitionChoiceErrorMessage = self::validateDefinitionForChoiceConstraintsFromSetDefinition($definition))) {
            throw new \InvalidArgumentException($definitionChoiceErrorMessage, __LINE__);
        }
        if (is_null($definition) || (is_array($definition) && empty($definition))) {
            unset($this->definition);
        } else {
            $this->definition = $definition;
        }
        return $this;
    }
    /**
     * Get styleId value
     * @return int[]|null
     */
    public function getStyleId()
    {
        return $this->styleId;
    }
    /**
     * This method is responsible for validating the values passed to the setStyleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyleId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStyleIdForArrayConstraintsFromSetStyleId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $genericEquipmentStyleIdItem) {
            // validation for constraint: itemType
            if (!(is_int($genericEquipmentStyleIdItem) || ctype_digit($genericEquipmentStyleIdItem))) {
                $invalidValues[] = is_object($genericEquipmentStyleIdItem) ? get_class($genericEquipmentStyleIdItem) : sprintf('%s(%s)', gettype($genericEquipmentStyleIdItem), var_export($genericEquipmentStyleIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The styleId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set styleId value
     * @throws \InvalidArgumentException
     * @param int[] $styleId
     * @return \StructType\GenericEquipment
     */
    public function setStyleId(array $styleId = array())
    {
        // validation for constraint: array
        if ('' !== ($styleIdArrayErrorMessage = self::validateStyleIdForArrayConstraintsFromSetStyleId($styleId))) {
            throw new \InvalidArgumentException($styleIdArrayErrorMessage, __LINE__);
        }
        $this->styleId = $styleId;
        return $this;
    }
    /**
     * Add item to styleId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\GenericEquipment
     */
    public function addToStyleId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The styleId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->styleId[] = $item;
        return $this;
    }
    /**
     * Get installed value
     * @return \StructType\InstallationCause|null
     */
    public function getInstalled()
    {
        return $this->installed;
    }
    /**
     * Set installed value
     * @param \StructType\InstallationCause $installed
     * @return \StructType\GenericEquipment
     */
    public function setInstalled(\StructType\InstallationCause $installed = null)
    {
        $this->installed = $installed;
        return $this;
    }
}
