<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericColor StructType
 * @subpackage Structs
 */
class GenericColor extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The installed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallationCause
     */
    public $installed;
    /**
     * The primary
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $primary;
    /**
     * Constructor method for GenericColor
     * @uses GenericColor::setName()
     * @uses GenericColor::setInstalled()
     * @uses GenericColor::setPrimary()
     * @param string $name
     * @param \StructType\InstallationCause $installed
     * @param bool $primary
     */
    public function __construct($name = null, \StructType\InstallationCause $installed = null, $primary = null)
    {
        $this
            ->setName($name)
            ->setInstalled($installed)
            ->setPrimary($primary);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GenericColor
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get installed value
     * @return \StructType\InstallationCause|null
     */
    public function getInstalled()
    {
        return $this->installed;
    }
    /**
     * Set installed value
     * @param \StructType\InstallationCause $installed
     * @return \StructType\GenericColor
     */
    public function setInstalled(\StructType\InstallationCause $installed = null)
    {
        $this->installed = $installed;
        return $this;
    }
    /**
     * Get primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param bool $primary
     * @return \StructType\GenericColor
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary) && !is_bool($primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary, true), gettype($primary)), __LINE__);
        }
        $this->primary = $primary;
        return $this;
    }
}
