<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Divisions StructType
 * @subpackage Structs
 */
class Divisions extends BaseResponse
{
    /**
     * The division
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IdentifiedString[]
     */
    public $division;
    /**
     * Constructor method for Divisions
     * @uses Divisions::setDivision()
     * @param \StructType\IdentifiedString[] $division
     */
    public function __construct(array $division = array())
    {
        $this
            ->setDivision($division);
    }
    /**
     * Get division value
     * @return \StructType\IdentifiedString[]|null
     */
    public function getDivision()
    {
        return $this->division;
    }
    /**
     * This method is responsible for validating the values passed to the setDivision method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDivision method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDivisionForArrayConstraintsFromSetDivision(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $divisionsDivisionItem) {
            // validation for constraint: itemType
            if (!$divisionsDivisionItem instanceof \StructType\IdentifiedString) {
                $invalidValues[] = is_object($divisionsDivisionItem) ? get_class($divisionsDivisionItem) : sprintf('%s(%s)', gettype($divisionsDivisionItem), var_export($divisionsDivisionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The division property can only contain items of type \StructType\IdentifiedString, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set division value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString[] $division
     * @return \StructType\Divisions
     */
    public function setDivision(array $division = array())
    {
        // validation for constraint: array
        if ('' !== ($divisionArrayErrorMessage = self::validateDivisionForArrayConstraintsFromSetDivision($division))) {
            throw new \InvalidArgumentException($divisionArrayErrorMessage, __LINE__);
        }
        $this->division = $division;
        return $this;
    }
    /**
     * Add item to division value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString $item
     * @return \StructType\Divisions
     */
    public function addToDivision(\StructType\IdentifiedString $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifiedString) {
            throw new \InvalidArgumentException(sprintf('The division property can only contain items of type \StructType\IdentifiedString, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->division[] = $item;
        return $this;
    }
}
