<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for displacement StructType
 * @subpackage Structs
 */
class Displacement extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DisplacementValue[]
     */
    public $value;
    /**
     * Constructor method for displacement
     * @uses Displacement::setValue()
     * @param \StructType\DisplacementValue[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get value value
     * @return \StructType\DisplacementValue[]|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $displacementValueItem) {
            // validation for constraint: itemType
            if (!$displacementValueItem instanceof \StructType\DisplacementValue) {
                $invalidValues[] = is_object($displacementValueItem) ? get_class($displacementValueItem) : sprintf('%s(%s)', gettype($displacementValueItem), var_export($displacementValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The value property can only contain items of type \StructType\DisplacementValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param \StructType\DisplacementValue[] $value
     * @return \StructType\Displacement
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param \StructType\DisplacementValue $item
     * @return \StructType\Displacement
     */
    public function addToValue(\StructType\DisplacementValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DisplacementValue) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of type \StructType\DisplacementValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
}
