<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for colorized StructType
 * @subpackage Structs
 */
class Colorized extends Image
{
    /**
     * The primaryColorOptionCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $primaryColorOptionCode;
    /**
     * The secondaryColorOptionCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $secondaryColorOptionCode;
    /**
     * The match
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $match;
    /**
     * The shotCode
     * @var string
     */
    public $shotCode;
    /**
     * The backgroundDescription
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $backgroundDescription;
    /**
     * The primaryRGBHexCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $primaryRGBHexCode;
    /**
     * The secondaryRGBHexCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $secondaryRGBHexCode;
    /**
     * Constructor method for colorized
     * @uses Colorized::setPrimaryColorOptionCode()
     * @uses Colorized::setSecondaryColorOptionCode()
     * @uses Colorized::setMatch()
     * @uses Colorized::setShotCode()
     * @uses Colorized::setBackgroundDescription()
     * @uses Colorized::setPrimaryRGBHexCode()
     * @uses Colorized::setSecondaryRGBHexCode()
     * @param string $primaryColorOptionCode
     * @param string $secondaryColorOptionCode
     * @param bool $match
     * @param string $shotCode
     * @param string $backgroundDescription
     * @param string $primaryRGBHexCode
     * @param string $secondaryRGBHexCode
     */
    public function __construct($primaryColorOptionCode = null, $secondaryColorOptionCode = null, $match = null, $shotCode = null, $backgroundDescription = null, $primaryRGBHexCode = null, $secondaryRGBHexCode = null)
    {
        $this
            ->setPrimaryColorOptionCode($primaryColorOptionCode)
            ->setSecondaryColorOptionCode($secondaryColorOptionCode)
            ->setMatch($match)
            ->setShotCode($shotCode)
            ->setBackgroundDescription($backgroundDescription)
            ->setPrimaryRGBHexCode($primaryRGBHexCode)
            ->setSecondaryRGBHexCode($secondaryRGBHexCode);
    }
    /**
     * Get primaryColorOptionCode value
     * @return string
     */
    public function getPrimaryColorOptionCode()
    {
        return $this->primaryColorOptionCode;
    }
    /**
     * Set primaryColorOptionCode value
     * @param string $primaryColorOptionCode
     * @return \StructType\Colorized
     */
    public function setPrimaryColorOptionCode($primaryColorOptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($primaryColorOptionCode) && !is_string($primaryColorOptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryColorOptionCode, true), gettype($primaryColorOptionCode)), __LINE__);
        }
        $this->primaryColorOptionCode = $primaryColorOptionCode;
        return $this;
    }
    /**
     * Get secondaryColorOptionCode value
     * @return string|null
     */
    public function getSecondaryColorOptionCode()
    {
        return $this->secondaryColorOptionCode;
    }
    /**
     * Set secondaryColorOptionCode value
     * @param string $secondaryColorOptionCode
     * @return \StructType\Colorized
     */
    public function setSecondaryColorOptionCode($secondaryColorOptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryColorOptionCode) && !is_string($secondaryColorOptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryColorOptionCode, true), gettype($secondaryColorOptionCode)), __LINE__);
        }
        $this->secondaryColorOptionCode = $secondaryColorOptionCode;
        return $this;
    }
    /**
     * Get match value
     * @return bool|null
     */
    public function getMatch()
    {
        return $this->match;
    }
    /**
     * Set match value
     * @param bool $match
     * @return \StructType\Colorized
     */
    public function setMatch($match = null)
    {
        // validation for constraint: boolean
        if (!is_null($match) && !is_bool($match)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($match, true), gettype($match)), __LINE__);
        }
        $this->match = $match;
        return $this;
    }
    /**
     * Get shotCode value
     * @return string|null
     */
    public function getShotCode()
    {
        return $this->shotCode;
    }
    /**
     * Set shotCode value
     * @param string $shotCode
     * @return \StructType\Colorized
     */
    public function setShotCode($shotCode = null)
    {
        // validation for constraint: string
        if (!is_null($shotCode) && !is_string($shotCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shotCode, true), gettype($shotCode)), __LINE__);
        }
        $this->shotCode = $shotCode;
        return $this;
    }
    /**
     * Get backgroundDescription value
     * @return string|null
     */
    public function getBackgroundDescription()
    {
        return $this->backgroundDescription;
    }
    /**
     * Set backgroundDescription value
     * @param string $backgroundDescription
     * @return \StructType\Colorized
     */
    public function setBackgroundDescription($backgroundDescription = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundDescription) && !is_string($backgroundDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backgroundDescription, true), gettype($backgroundDescription)), __LINE__);
        }
        $this->backgroundDescription = $backgroundDescription;
        return $this;
    }
    /**
     * Get primaryRGBHexCode value
     * @return string|null
     */
    public function getPrimaryRGBHexCode()
    {
        return $this->primaryRGBHexCode;
    }
    /**
     * Set primaryRGBHexCode value
     * @param string $primaryRGBHexCode
     * @return \StructType\Colorized
     */
    public function setPrimaryRGBHexCode($primaryRGBHexCode = null)
    {
        // validation for constraint: string
        if (!is_null($primaryRGBHexCode) && !is_string($primaryRGBHexCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryRGBHexCode, true), gettype($primaryRGBHexCode)), __LINE__);
        }
        $this->primaryRGBHexCode = $primaryRGBHexCode;
        return $this;
    }
    /**
     * Get secondaryRGBHexCode value
     * @return string|null
     */
    public function getSecondaryRGBHexCode()
    {
        return $this->secondaryRGBHexCode;
    }
    /**
     * Set secondaryRGBHexCode value
     * @param string $secondaryRGBHexCode
     * @return \StructType\Colorized
     */
    public function setSecondaryRGBHexCode($secondaryRGBHexCode = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryRGBHexCode) && !is_string($secondaryRGBHexCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryRGBHexCode, true), gettype($secondaryRGBHexCode)), __LINE__);
        }
        $this->secondaryRGBHexCode = $secondaryRGBHexCode;
        return $this;
    }
}
