<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryDefinitions StructType
 * @subpackage Structs
 */
class CategoryDefinitions extends BaseResponse
{
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryDefinition[]
     */
    public $category;
    /**
     * Constructor method for CategoryDefinitions
     * @uses CategoryDefinitions::setCategory()
     * @param \StructType\CategoryDefinition[] $category
     */
    public function __construct(array $category = array())
    {
        $this
            ->setCategory($category);
    }
    /**
     * Get category value
     * @return \StructType\CategoryDefinition[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryForArrayConstraintsFromSetCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryDefinitionsCategoryItem) {
            // validation for constraint: itemType
            if (!$categoryDefinitionsCategoryItem instanceof \StructType\CategoryDefinition) {
                $invalidValues[] = is_object($categoryDefinitionsCategoryItem) ? get_class($categoryDefinitionsCategoryItem) : sprintf('%s(%s)', gettype($categoryDefinitionsCategoryItem), var_export($categoryDefinitionsCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category property can only contain items of type \StructType\CategoryDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDefinition[] $category
     * @return \StructType\CategoryDefinitions
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryArrayErrorMessage = self::validateCategoryForArrayConstraintsFromSetCategory($category))) {
            throw new \InvalidArgumentException($categoryArrayErrorMessage, __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDefinition $item
     * @return \StructType\CategoryDefinitions
     */
    public function addToCategory(\StructType\CategoryDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryDefinition) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of type \StructType\CategoryDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
}
