<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountInfo StructType
 * @subpackage Structs
 */
class AccountInfo extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - documentation: Account Number provided by Chrome.
     * - use: required
     * @var string
     */
    public $number;
    /**
     * The secret
     * Meta information extracted from the WSDL
     * - documentation: Account Secret/Password provided by Chrome.
     * - use: required
     * @var string
     */
    public $secret;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: Upper-case, two-letter code defined by ISO-3166.
     * - use: required
     * @var string
     */
    public $country;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - documentation: Lower-case, two-letter code defined by ISO-639.
     * - use: required
     * @var string
     */
    public $language;
    /**
     * The behalfOf
     * @var string
     */
    public $behalfOf;
    /**
     * Constructor method for AccountInfo
     * @uses AccountInfo::setNumber()
     * @uses AccountInfo::setSecret()
     * @uses AccountInfo::setCountry()
     * @uses AccountInfo::setLanguage()
     * @uses AccountInfo::setBehalfOf()
     * @param string $number
     * @param string $secret
     * @param string $country
     * @param string $language
     * @param string $behalfOf
     */
    public function __construct($number = null, $secret = null, $country = null, $language = null, $behalfOf = null)
    {
        $this
            ->setNumber($number)
            ->setSecret($secret)
            ->setCountry($country)
            ->setLanguage($language)
            ->setBehalfOf($behalfOf);
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\AccountInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get secret value
     * @return string
     */
    public function getSecret()
    {
        return $this->secret;
    }
    /**
     * Set secret value
     * @param string $secret
     * @return \StructType\AccountInfo
     */
    public function setSecret($secret = null)
    {
        // validation for constraint: string
        if (!is_null($secret) && !is_string($secret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secret, true), gettype($secret)), __LINE__);
        }
        $this->secret = $secret;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\AccountInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\AccountInfo
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get behalfOf value
     * @return string|null
     */
    public function getBehalfOf()
    {
        return $this->behalfOf;
    }
    /**
     * Set behalfOf value
     * @param string $behalfOf
     * @return \StructType\AccountInfo
     */
    public function setBehalfOf($behalfOf = null)
    {
        // validation for constraint: string
        if (!is_null($behalfOf) && !is_string($behalfOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($behalfOf, true), gettype($behalfOf)), __LINE__);
        }
        $this->behalfOf = $behalfOf;
        return $this;
    }
}
