<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getVersionInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BaseRequest $request
     * @return \StructType\VersionInfo|bool
     */
    public function getVersionInfo(\StructType\BaseRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getVersionInfo($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModelYears
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BaseRequest $request
     * @return \StructType\ModelYears|bool
     */
    public function getModelYears(\StructType\BaseRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getModelYears($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDivisions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DivisionsRequest $request
     * @return \StructType\Divisions|bool
     */
    public function getDivisions(\StructType\DivisionsRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getDivisions($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubdivisions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubdivisionsRequest $request
     * @return \StructType\Subdivisions|bool
     */
    public function getSubdivisions(\StructType\SubdivisionsRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getSubdivisions($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModelsRequest $request
     * @return \StructType\Models|bool
     */
    public function getModels(\StructType\ModelsRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getModels($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStyles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StylesRequest $request
     * @return \StructType\Styles|bool
     */
    public function getStyles(\StructType\StylesRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getStyles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCategoryDefinitions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BaseRequest $request
     * @return \StructType\CategoryDefinitions|bool
     */
    public function getCategoryDefinitions(\StructType\BaseRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getCategoryDefinitions($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getTechnicalSpecificationDefinitions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BaseRequest $request
     * @return \StructType\TechnicalSpecificationDefinitions|bool
     */
    public function getTechnicalSpecificationDefinitions(\StructType\BaseRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->getTechnicalSpecificationDefinitions($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CategoryDefinitions|\StructType\Divisions|\StructType\Models|\StructType\ModelYears|\StructType\Styles|\StructType\Subdivisions|\StructType\TechnicalSpecificationDefinitions|\StructType\VersionInfo
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
