<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DriveTrain EnumType
 * @subpackage Enumerations
 */
class DriveTrain extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Front Wheel Drive'
     * @return string 'Front Wheel Drive'
     */
    const VALUE_FRONT_WHEEL_DRIVE = 'Front Wheel Drive';
    /**
     * Constant for value 'Rear Wheel Drive'
     * @return string 'Rear Wheel Drive'
     */
    const VALUE_REAR_WHEEL_DRIVE = 'Rear Wheel Drive';
    /**
     * Constant for value 'All Wheel Drive'
     * @return string 'All Wheel Drive'
     */
    const VALUE_ALL_WHEEL_DRIVE = 'All Wheel Drive';
    /**
     * Constant for value 'Four Wheel Drive'
     * @return string 'Four Wheel Drive'
     */
    const VALUE_FOUR_WHEEL_DRIVE = 'Four Wheel Drive';
    /**
     * Return allowed values
     * @uses self::VALUE_FRONT_WHEEL_DRIVE
     * @uses self::VALUE_REAR_WHEEL_DRIVE
     * @uses self::VALUE_ALL_WHEEL_DRIVE
     * @uses self::VALUE_FOUR_WHEEL_DRIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FRONT_WHEEL_DRIVE,
            self::VALUE_REAR_WHEEL_DRIVE,
            self::VALUE_ALL_WHEEL_DRIVE,
            self::VALUE_FOUR_WHEEL_DRIVE,
        );
    }
}
