<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vinDescription StructType
 * @subpackage Structs
 */
class VinDescription extends AbstractStructBase
{
    /**
     * The vin
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $vin;
    /**
     * The modelYear
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $modelYear;
    /**
     * The division
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $division;
    /**
     * The modelName
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $modelName;
    /**
     * The gvwr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Range
     */
    public $gvwr;
    /**
     * The WorldManufacturerIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WorldManufacturerIdentifier;
    /**
     * The ManufacturerIdentificationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerIdentificationCode;
    /**
     * The restraintTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryDefinition[]
     */
    public $restraintTypes;
    /**
     * The marketClass
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\IdentifiedString[]
     */
    public $marketClass;
    /**
     * The styleName
     * @var string
     */
    public $styleName;
    /**
     * The bodyType
     * @var string
     */
    public $bodyType;
    /**
     * The drivingWheels
     * @var string
     */
    public $drivingWheels;
    /**
     * The builddata
     * @var string
     */
    public $builddata;
    /**
     * The built
     * @var string
     */
    public $built;
    /**
     * The builtMSRP
     * @var float
     */
    public $builtMSRP;
    /**
     * Constructor method for vinDescription
     * @uses VinDescription::setVin()
     * @uses VinDescription::setModelYear()
     * @uses VinDescription::setDivision()
     * @uses VinDescription::setModelName()
     * @uses VinDescription::setGvwr()
     * @uses VinDescription::setWorldManufacturerIdentifier()
     * @uses VinDescription::setManufacturerIdentificationCode()
     * @uses VinDescription::setRestraintTypes()
     * @uses VinDescription::setMarketClass()
     * @uses VinDescription::setStyleName()
     * @uses VinDescription::setBodyType()
     * @uses VinDescription::setDrivingWheels()
     * @uses VinDescription::setBuilddata()
     * @uses VinDescription::setBuilt()
     * @uses VinDescription::setBuiltMSRP()
     * @param string $vin
     * @param int $modelYear
     * @param string $division
     * @param string $modelName
     * @param \StructType\Range $gvwr
     * @param string $worldManufacturerIdentifier
     * @param string $manufacturerIdentificationCode
     * @param \StructType\CategoryDefinition[] $restraintTypes
     * @param \StructType\IdentifiedString[] $marketClass
     * @param string $styleName
     * @param string $bodyType
     * @param string $drivingWheels
     * @param string $builddata
     * @param string $built
     * @param float $builtMSRP
     */
    public function __construct($vin = null, $modelYear = null, $division = null, $modelName = null, \StructType\Range $gvwr = null, $worldManufacturerIdentifier = null, $manufacturerIdentificationCode = null, array $restraintTypes = array(), array $marketClass = array(), $styleName = null, $bodyType = null, $drivingWheels = null, $builddata = null, $built = null, $builtMSRP = null)
    {
        $this
            ->setVin($vin)
            ->setModelYear($modelYear)
            ->setDivision($division)
            ->setModelName($modelName)
            ->setGvwr($gvwr)
            ->setWorldManufacturerIdentifier($worldManufacturerIdentifier)
            ->setManufacturerIdentificationCode($manufacturerIdentificationCode)
            ->setRestraintTypes($restraintTypes)
            ->setMarketClass($marketClass)
            ->setStyleName($styleName)
            ->setBodyType($bodyType)
            ->setDrivingWheels($drivingWheels)
            ->setBuilddata($builddata)
            ->setBuilt($built)
            ->setBuiltMSRP($builtMSRP);
    }
    /**
     * Get vin value
     * @return string
     */
    public function getVin()
    {
        return $this->vin;
    }
    /**
     * Set vin value
     * @param string $vin
     * @return \StructType\VinDescription
     */
    public function setVin($vin = null)
    {
        // validation for constraint: string
        if (!is_null($vin) && !is_string($vin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vin, true), gettype($vin)), __LINE__);
        }
        $this->vin = $vin;
        return $this;
    }
    /**
     * Get modelYear value
     * @return int
     */
    public function getModelYear()
    {
        return $this->modelYear;
    }
    /**
     * Set modelYear value
     * @param int $modelYear
     * @return \StructType\VinDescription
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        $this->modelYear = $modelYear;
        return $this;
    }
    /**
     * Get division value
     * @return string
     */
    public function getDivision()
    {
        return $this->division;
    }
    /**
     * Set division value
     * @param string $division
     * @return \StructType\VinDescription
     */
    public function setDivision($division = null)
    {
        // validation for constraint: string
        if (!is_null($division) && !is_string($division)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($division, true), gettype($division)), __LINE__);
        }
        $this->division = $division;
        return $this;
    }
    /**
     * Get modelName value
     * @return string
     */
    public function getModelName()
    {
        return $this->modelName;
    }
    /**
     * Set modelName value
     * @param string $modelName
     * @return \StructType\VinDescription
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelName, true), gettype($modelName)), __LINE__);
        }
        $this->modelName = $modelName;
        return $this;
    }
    /**
     * Get gvwr value
     * @return \StructType\Range|null
     */
    public function getGvwr()
    {
        return $this->gvwr;
    }
    /**
     * Set gvwr value
     * @param \StructType\Range $gvwr
     * @return \StructType\VinDescription
     */
    public function setGvwr(\StructType\Range $gvwr = null)
    {
        $this->gvwr = $gvwr;
        return $this;
    }
    /**
     * Get WorldManufacturerIdentifier value
     * @return string|null
     */
    public function getWorldManufacturerIdentifier()
    {
        return $this->WorldManufacturerIdentifier;
    }
    /**
     * Set WorldManufacturerIdentifier value
     * @param string $worldManufacturerIdentifier
     * @return \StructType\VinDescription
     */
    public function setWorldManufacturerIdentifier($worldManufacturerIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($worldManufacturerIdentifier) && !is_string($worldManufacturerIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worldManufacturerIdentifier, true), gettype($worldManufacturerIdentifier)), __LINE__);
        }
        $this->WorldManufacturerIdentifier = $worldManufacturerIdentifier;
        return $this;
    }
    /**
     * Get ManufacturerIdentificationCode value
     * @return string|null
     */
    public function getManufacturerIdentificationCode()
    {
        return $this->ManufacturerIdentificationCode;
    }
    /**
     * Set ManufacturerIdentificationCode value
     * @param string $manufacturerIdentificationCode
     * @return \StructType\VinDescription
     */
    public function setManufacturerIdentificationCode($manufacturerIdentificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerIdentificationCode) && !is_string($manufacturerIdentificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerIdentificationCode, true), gettype($manufacturerIdentificationCode)), __LINE__);
        }
        $this->ManufacturerIdentificationCode = $manufacturerIdentificationCode;
        return $this;
    }
    /**
     * Get restraintTypes value
     * @return \StructType\CategoryDefinition[]|null
     */
    public function getRestraintTypes()
    {
        return $this->restraintTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setRestraintTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestraintTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestraintTypesForArrayConstraintsFromSetRestraintTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vinDescriptionRestraintTypesItem) {
            // validation for constraint: itemType
            if (!$vinDescriptionRestraintTypesItem instanceof \StructType\CategoryDefinition) {
                $invalidValues[] = is_object($vinDescriptionRestraintTypesItem) ? get_class($vinDescriptionRestraintTypesItem) : sprintf('%s(%s)', gettype($vinDescriptionRestraintTypesItem), var_export($vinDescriptionRestraintTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The restraintTypes property can only contain items of type \StructType\CategoryDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set restraintTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDefinition[] $restraintTypes
     * @return \StructType\VinDescription
     */
    public function setRestraintTypes(array $restraintTypes = array())
    {
        // validation for constraint: array
        if ('' !== ($restraintTypesArrayErrorMessage = self::validateRestraintTypesForArrayConstraintsFromSetRestraintTypes($restraintTypes))) {
            throw new \InvalidArgumentException($restraintTypesArrayErrorMessage, __LINE__);
        }
        $this->restraintTypes = $restraintTypes;
        return $this;
    }
    /**
     * Add item to restraintTypes value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryDefinition $item
     * @return \StructType\VinDescription
     */
    public function addToRestraintTypes(\StructType\CategoryDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryDefinition) {
            throw new \InvalidArgumentException(sprintf('The restraintTypes property can only contain items of type \StructType\CategoryDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->restraintTypes[] = $item;
        return $this;
    }
    /**
     * Get marketClass value
     * @return \StructType\IdentifiedString[]|null
     */
    public function getMarketClass()
    {
        return $this->marketClass;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketClassForArrayConstraintsFromSetMarketClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vinDescriptionMarketClassItem) {
            // validation for constraint: itemType
            if (!$vinDescriptionMarketClassItem instanceof \StructType\IdentifiedString) {
                $invalidValues[] = is_object($vinDescriptionMarketClassItem) ? get_class($vinDescriptionMarketClassItem) : sprintf('%s(%s)', gettype($vinDescriptionMarketClassItem), var_export($vinDescriptionMarketClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The marketClass property can only contain items of type \StructType\IdentifiedString, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set marketClass value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString[] $marketClass
     * @return \StructType\VinDescription
     */
    public function setMarketClass(array $marketClass = array())
    {
        // validation for constraint: array
        if ('' !== ($marketClassArrayErrorMessage = self::validateMarketClassForArrayConstraintsFromSetMarketClass($marketClass))) {
            throw new \InvalidArgumentException($marketClassArrayErrorMessage, __LINE__);
        }
        $this->marketClass = $marketClass;
        return $this;
    }
    /**
     * Add item to marketClass value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifiedString $item
     * @return \StructType\VinDescription
     */
    public function addToMarketClass(\StructType\IdentifiedString $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifiedString) {
            throw new \InvalidArgumentException(sprintf('The marketClass property can only contain items of type \StructType\IdentifiedString, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->marketClass[] = $item;
        return $this;
    }
    /**
     * Get styleName value
     * @return string|null
     */
    public function getStyleName()
    {
        return $this->styleName;
    }
    /**
     * Set styleName value
     * @param string $styleName
     * @return \StructType\VinDescription
     */
    public function setStyleName($styleName = null)
    {
        // validation for constraint: string
        if (!is_null($styleName) && !is_string($styleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($styleName, true), gettype($styleName)), __LINE__);
        }
        $this->styleName = $styleName;
        return $this;
    }
    /**
     * Get bodyType value
     * @return string|null
     */
    public function getBodyType()
    {
        return $this->bodyType;
    }
    /**
     * Set bodyType value
     * @param string $bodyType
     * @return \StructType\VinDescription
     */
    public function setBodyType($bodyType = null)
    {
        // validation for constraint: string
        if (!is_null($bodyType) && !is_string($bodyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bodyType, true), gettype($bodyType)), __LINE__);
        }
        $this->bodyType = $bodyType;
        return $this;
    }
    /**
     * Get drivingWheels value
     * @return string|null
     */
    public function getDrivingWheels()
    {
        return $this->drivingWheels;
    }
    /**
     * Set drivingWheels value
     * @param string $drivingWheels
     * @return \StructType\VinDescription
     */
    public function setDrivingWheels($drivingWheels = null)
    {
        // validation for constraint: string
        if (!is_null($drivingWheels) && !is_string($drivingWheels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($drivingWheels, true), gettype($drivingWheels)), __LINE__);
        }
        $this->drivingWheels = $drivingWheels;
        return $this;
    }
    /**
     * Get builddata value
     * @return string|null
     */
    public function getBuilddata()
    {
        return $this->builddata;
    }
    /**
     * Set builddata value
     * @param string $builddata
     * @return \StructType\VinDescription
     */
    public function setBuilddata($builddata = null)
    {
        // validation for constraint: string
        if (!is_null($builddata) && !is_string($builddata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($builddata, true), gettype($builddata)), __LINE__);
        }
        $this->builddata = $builddata;
        return $this;
    }
    /**
     * Get built value
     * @return string|null
     */
    public function getBuilt()
    {
        return $this->built;
    }
    /**
     * Set built value
     * @param string $built
     * @return \StructType\VinDescription
     */
    public function setBuilt($built = null)
    {
        // validation for constraint: string
        if (!is_null($built) && !is_string($built)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($built, true), gettype($built)), __LINE__);
        }
        $this->built = $built;
        return $this;
    }
    /**
     * Get builtMSRP value
     * @return float|null
     */
    public function getBuiltMSRP()
    {
        return $this->builtMSRP;
    }
    /**
     * Set builtMSRP value
     * @param float $builtMSRP
     * @return \StructType\VinDescription
     */
    public function setBuiltMSRP($builtMSRP = null)
    {
        // validation for constraint: float
        if (!is_null($builtMSRP) && !(is_float($builtMSRP) || is_numeric($builtMSRP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($builtMSRP, true), gettype($builtMSRP)), __LINE__);
        }
        $this->builtMSRP = $builtMSRP;
        return $this;
    }
}
