<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleDescriptionRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Describe a vehicle. You must provide one of: vehicle identifier (VIN or HIN); Chrome style ID; or year, make name, and model name. Optional input fields can help identification by limiting color, trim, wheelbase, and installed
 * options.
 * @subpackage Structs
 */
class VehicleDescriptionRequest extends BaseRequest
{
    /**
     * The modelYear
     * Meta information extracted from the WSDL
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $modelYear;
    /**
     * The makeName
     * Meta information extracted from the WSDL
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $makeName;
    /**
     * The modelName
     * Meta information extracted from the WSDL
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $modelName;
    /**
     * The vin
     * Meta information extracted from the WSDL
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $vin;
    /**
     * The reducingStyleId
     * Meta information extracted from the WSDL
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $reducingStyleId;
    /**
     * The reducingAcode
     * Meta information extracted from the WSDL
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $reducingAcode;
    /**
     * The styleId
     * Meta information extracted from the WSDL
     * - documentation: Causes ADS to find and describe the given vehicle.
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $styleId;
    /**
     * The acode
     * Meta information extracted from the WSDL
     * - documentation: Causes ADS to find and describe the given vehicle by Acode.
     * - choice: modelYear | makeName | modelName | vin | reducingStyleId | reducingAcode | styleId | acode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $acode;
    /**
     * The styleName
     * Meta information extracted from the WSDL
     * - documentation: Styles to be reduced to the exactly matched style name.
     * - minOccurs: 0
     * @var string
     */
    public $styleName;
    /**
     * The trimName
     * Meta information extracted from the WSDL
     * - documentation: Trim names are typically things like "XLT", "Sport" or "Eddie Bauer".
     * - minOccurs: 0
     * @var string
     */
    public $trimName;
    /**
     * The manufacturerModelCode
     * Meta information extracted from the WSDL
     * - documentation: MMC are typically things like "TK10743"or "CC10706".
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerModelCode;
    /**
     * The wheelBase
     * Meta information extracted from the WSDL
     * - documentation: Give wheel base in inches. ADS will try to find vehicles where (1) the wheel base matters in the identification (usually Ford pickups) and (2) within +/- 2" of the given value. Round to the nearest whole inch. If you don't, ADS will.
     * - minOccurs: 0
     * @var float
     */
    public $wheelBase;
    /**
     * The OEMOptionCode
     * Meta information extracted from the WSDL
     * - documentation: OEM option codes are identifiers that manufacturers use to identify which options and packages to install on a specific vehicle. The codes to use are unique to each manufacturer and will look like "FF3" or "AJX". You can provide as
     * many of these as you know, but only one per element.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OEMOptionCode;
    /**
     * The primaryOptionName
     * Meta information extracted from the WSDL
     * - documentation: Primary Name of the Option, usually the description part before the word incldues.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $primaryOptionName;
    /**
     * The equipmentDescription
     * Meta information extracted from the WSDL
     * - documentation: Provide the name and or description of equipment you know to be installed. If you know the manufacturer's actual name use it. Otherwise use the most descriptive name you can think of. You can provide as many of these as you know, but
     * only one per element.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $equipmentDescription;
    /**
     * The exteriorColorName
     * Meta information extracted from the WSDL
     * - documentation: The name of the exterior color. If you know the manufacturer's actual color name, use it. Otherwise use the most reasonable color you can think of.
     * - minOccurs: 0
     * @var string
     */
    public $exteriorColorName;
    /**
     * The interiorColorName
     * Meta information extracted from the WSDL
     * - documentation: The name of the interior color or interior color pair. If you know the manufacturer's actual color name, use it. Otherwise use the most reasonable color you can think of.
     * - minOccurs: 0
     * @var string
     */
    public $interiorColorName;
    /**
     * The nonFactoryEquipmentDescription
     * Meta information extracted from the WSDL
     * - documentation: Provide the name and or description of non-factory (aftermarket) equipment you know to be installed. This equipment will be listed as installed non-factory equipment, without validation against manufacturer's install logic and will
     * not affect the identification or installation of factory options, packages or equipment. You can provide as many of these as you know, but only one per element.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $nonFactoryEquipmentDescription;
    /**
     * The switch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $switch;
    /**
     * The vehicleProcessMode
     * Meta information extracted from the WSDL
     * - documentation: The default behavior of ADS is to include both fleet-only and retail only styles when discovering vehicles. Use this switch to tell ADS to ignore either or both.
     * - minOccurs: 0
     * @var string
     */
    public $vehicleProcessMode;
    /**
     * The optionsProcessMode
     * Meta information extracted from the WSDL
     * - documentation: The default behavior of ADS is to include both fleet-only and retail only options when discovering equipment. Use this switch to tell ADS to ignore either or both.
     * - minOccurs: 0
     * @var string
     */
    public $optionsProcessMode;
    /**
     * The includeMediaGallery
     * Meta information extracted from the WSDL
     * - documentation: If your license allows, ADS will provide additional images (beyond the stock image) for each style described in the output. Chrome Media gallery supports "colorMatch" (where the image is the designated color), "multiView" (where the
     * vehicle is seen from several angles) and "both." See the documentation for the switch type for specific instructions.
     * - minOccurs: 0
     * @var string
     */
    public $includeMediaGallery;
    /**
     * The includeTechnicalSpecificationTitleId
     * Meta information extracted from the WSDL
     * - documentation: The default behavior of ADS is to include all available technical specifications. Use this switch to tell ADS specific technical specifications (by title id) to be shown.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $includeTechnicalSpecificationTitleId;
    /**
     * Constructor method for VehicleDescriptionRequest
     * @uses VehicleDescriptionRequest::setModelYear()
     * @uses VehicleDescriptionRequest::setMakeName()
     * @uses VehicleDescriptionRequest::setModelName()
     * @uses VehicleDescriptionRequest::setVin()
     * @uses VehicleDescriptionRequest::setReducingStyleId()
     * @uses VehicleDescriptionRequest::setReducingAcode()
     * @uses VehicleDescriptionRequest::setStyleId()
     * @uses VehicleDescriptionRequest::setAcode()
     * @uses VehicleDescriptionRequest::setStyleName()
     * @uses VehicleDescriptionRequest::setTrimName()
     * @uses VehicleDescriptionRequest::setManufacturerModelCode()
     * @uses VehicleDescriptionRequest::setWheelBase()
     * @uses VehicleDescriptionRequest::setOEMOptionCode()
     * @uses VehicleDescriptionRequest::setPrimaryOptionName()
     * @uses VehicleDescriptionRequest::setEquipmentDescription()
     * @uses VehicleDescriptionRequest::setExteriorColorName()
     * @uses VehicleDescriptionRequest::setInteriorColorName()
     * @uses VehicleDescriptionRequest::setNonFactoryEquipmentDescription()
     * @uses VehicleDescriptionRequest::setSwitch()
     * @uses VehicleDescriptionRequest::setVehicleProcessMode()
     * @uses VehicleDescriptionRequest::setOptionsProcessMode()
     * @uses VehicleDescriptionRequest::setIncludeMediaGallery()
     * @uses VehicleDescriptionRequest::setIncludeTechnicalSpecificationTitleId()
     * @param int $modelYear
     * @param string $makeName
     * @param string $modelName
     * @param string $vin
     * @param int $reducingStyleId
     * @param string $reducingAcode
     * @param int $styleId
     * @param string $acode
     * @param string $styleName
     * @param string $trimName
     * @param string $manufacturerModelCode
     * @param float $wheelBase
     * @param string[] $oEMOptionCode
     * @param string[] $primaryOptionName
     * @param string[] $equipmentDescription
     * @param string $exteriorColorName
     * @param string $interiorColorName
     * @param string[] $nonFactoryEquipmentDescription
     * @param string[] $switch
     * @param string $vehicleProcessMode
     * @param string $optionsProcessMode
     * @param string $includeMediaGallery
     * @param int[] $includeTechnicalSpecificationTitleId
     */
    public function __construct($modelYear = null, $makeName = null, $modelName = null, $vin = null, $reducingStyleId = null, $reducingAcode = null, $styleId = null, $acode = null, $styleName = null, $trimName = null, $manufacturerModelCode = null, $wheelBase = null, array $oEMOptionCode = array(), array $primaryOptionName = array(), array $equipmentDescription = array(), $exteriorColorName = null, $interiorColorName = null, array $nonFactoryEquipmentDescription = array(), array $switch = array(), $vehicleProcessMode = null, $optionsProcessMode = null, $includeMediaGallery = null, array $includeTechnicalSpecificationTitleId = array())
    {
        $this
            ->setModelYear($modelYear)
            ->setMakeName($makeName)
            ->setModelName($modelName)
            ->setVin($vin)
            ->setReducingStyleId($reducingStyleId)
            ->setReducingAcode($reducingAcode)
            ->setStyleId($styleId)
            ->setAcode($acode)
            ->setStyleName($styleName)
            ->setTrimName($trimName)
            ->setManufacturerModelCode($manufacturerModelCode)
            ->setWheelBase($wheelBase)
            ->setOEMOptionCode($oEMOptionCode)
            ->setPrimaryOptionName($primaryOptionName)
            ->setEquipmentDescription($equipmentDescription)
            ->setExteriorColorName($exteriorColorName)
            ->setInteriorColorName($interiorColorName)
            ->setNonFactoryEquipmentDescription($nonFactoryEquipmentDescription)
            ->setSwitch($switch)
            ->setVehicleProcessMode($vehicleProcessMode)
            ->setOptionsProcessMode($optionsProcessMode)
            ->setIncludeMediaGallery($includeMediaGallery)
            ->setIncludeTechnicalSpecificationTitleId($includeTechnicalSpecificationTitleId);
    }
    /**
     * Get modelYear value
     * @return int|null
     */
    public function getModelYear()
    {
        return isset($this->modelYear) ? $this->modelYear : null;
    }
    /**
     * This method is responsible for validating the value passed to the setModelYear method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModelYear method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateModelYearForChoiceConstraintsFromSetModelYear($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'makeName',
            'modelName',
            'vin',
            'reducingStyleId',
            'reducingAcode',
            'styleId',
            'acode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property modelYear can\'t be set as the property %s is already set. Only one property must be set among these properties: modelYear, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set modelYear value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $modelYear
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setModelYear($modelYear = null)
    {
        // validation for constraint: int
        if (!is_null($modelYear) && !(is_int($modelYear) || ctype_digit($modelYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modelYear, true), gettype($modelYear)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($modelYearChoiceErrorMessage = self::validateModelYearForChoiceConstraintsFromSetModelYear($modelYear))) {
            throw new \InvalidArgumentException($modelYearChoiceErrorMessage, __LINE__);
        }
        if (is_null($modelYear) || (is_array($modelYear) && empty($modelYear))) {
            unset($this->modelYear);
        } else {
            $this->modelYear = $modelYear;
        }
        return $this;
    }
    /**
     * Get makeName value
     * @return string|null
     */
    public function getMakeName()
    {
        return isset($this->makeName) ? $this->makeName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMakeName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMakeName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMakeNameForChoiceConstraintsFromSetMakeName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'modelYear',
            'modelName',
            'vin',
            'reducingStyleId',
            'reducingAcode',
            'styleId',
            'acode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property makeName can\'t be set as the property %s is already set. Only one property must be set among these properties: makeName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set makeName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $makeName
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setMakeName($makeName = null)
    {
        // validation for constraint: string
        if (!is_null($makeName) && !is_string($makeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($makeName, true), gettype($makeName)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($makeNameChoiceErrorMessage = self::validateMakeNameForChoiceConstraintsFromSetMakeName($makeName))) {
            throw new \InvalidArgumentException($makeNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($makeName) || (is_array($makeName) && empty($makeName))) {
            unset($this->makeName);
        } else {
            $this->makeName = $makeName;
        }
        return $this;
    }
    /**
     * Get modelName value
     * @return string|null
     */
    public function getModelName()
    {
        return isset($this->modelName) ? $this->modelName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setModelName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModelName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateModelNameForChoiceConstraintsFromSetModelName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'modelYear',
            'makeName',
            'vin',
            'reducingStyleId',
            'reducingAcode',
            'styleId',
            'acode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property modelName can\'t be set as the property %s is already set. Only one property must be set among these properties: modelName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set modelName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $modelName
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelName, true), gettype($modelName)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($modelNameChoiceErrorMessage = self::validateModelNameForChoiceConstraintsFromSetModelName($modelName))) {
            throw new \InvalidArgumentException($modelNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($modelName) || (is_array($modelName) && empty($modelName))) {
            unset($this->modelName);
        } else {
            $this->modelName = $modelName;
        }
        return $this;
    }
    /**
     * Get vin value
     * @return string|null
     */
    public function getVin()
    {
        return isset($this->vin) ? $this->vin : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVin method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVinForChoiceConstraintsFromSetVin($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'modelYear',
            'makeName',
            'modelName',
            'reducingStyleId',
            'reducingAcode',
            'styleId',
            'acode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property vin can\'t be set as the property %s is already set. Only one property must be set among these properties: vin, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set vin value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $vin
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setVin($vin = null)
    {
        // validation for constraint: string
        if (!is_null($vin) && !is_string($vin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vin, true), gettype($vin)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($vinChoiceErrorMessage = self::validateVinForChoiceConstraintsFromSetVin($vin))) {
            throw new \InvalidArgumentException($vinChoiceErrorMessage, __LINE__);
        }
        if (is_null($vin) || (is_array($vin) && empty($vin))) {
            unset($this->vin);
        } else {
            $this->vin = $vin;
        }
        return $this;
    }
    /**
     * Get reducingStyleId value
     * @return int|null
     */
    public function getReducingStyleId()
    {
        return isset($this->reducingStyleId) ? $this->reducingStyleId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReducingStyleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReducingStyleId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReducingStyleIdForChoiceConstraintsFromSetReducingStyleId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'modelYear',
            'makeName',
            'modelName',
            'vin',
            'reducingAcode',
            'styleId',
            'acode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property reducingStyleId can\'t be set as the property %s is already set. Only one property must be set among these properties: reducingStyleId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set reducingStyleId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $reducingStyleId
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setReducingStyleId($reducingStyleId = null)
    {
        // validation for constraint: int
        if (!is_null($reducingStyleId) && !(is_int($reducingStyleId) || ctype_digit($reducingStyleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reducingStyleId, true), gettype($reducingStyleId)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($reducingStyleIdChoiceErrorMessage = self::validateReducingStyleIdForChoiceConstraintsFromSetReducingStyleId($reducingStyleId))) {
            throw new \InvalidArgumentException($reducingStyleIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($reducingStyleId) || (is_array($reducingStyleId) && empty($reducingStyleId))) {
            unset($this->reducingStyleId);
        } else {
            $this->reducingStyleId = $reducingStyleId;
        }
        return $this;
    }
    /**
     * Get reducingAcode value
     * @return string|null
     */
    public function getReducingAcode()
    {
        return isset($this->reducingAcode) ? $this->reducingAcode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setReducingAcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReducingAcode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReducingAcodeForChoiceConstraintsFromSetReducingAcode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'modelYear',
            'makeName',
            'modelName',
            'vin',
            'reducingStyleId',
            'styleId',
            'acode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property reducingAcode can\'t be set as the property %s is already set. Only one property must be set among these properties: reducingAcode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set reducingAcode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $reducingAcode
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setReducingAcode($reducingAcode = null)
    {
        // validation for constraint: string
        if (!is_null($reducingAcode) && !is_string($reducingAcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reducingAcode, true), gettype($reducingAcode)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($reducingAcodeChoiceErrorMessage = self::validateReducingAcodeForChoiceConstraintsFromSetReducingAcode($reducingAcode))) {
            throw new \InvalidArgumentException($reducingAcodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($reducingAcode) || (is_array($reducingAcode) && empty($reducingAcode))) {
            unset($this->reducingAcode);
        } else {
            $this->reducingAcode = $reducingAcode;
        }
        return $this;
    }
    /**
     * Get styleId value
     * @return int|null
     */
    public function getStyleId()
    {
        return isset($this->styleId) ? $this->styleId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setStyleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyleId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateStyleIdForChoiceConstraintsFromSetStyleId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'modelYear',
            'makeName',
            'modelName',
            'vin',
            'reducingStyleId',
            'reducingAcode',
            'acode',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property styleId can\'t be set as the property %s is already set. Only one property must be set among these properties: styleId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set styleId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $styleId
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setStyleId($styleId = null)
    {
        // validation for constraint: int
        if (!is_null($styleId) && !(is_int($styleId) || ctype_digit($styleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($styleId, true), gettype($styleId)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($styleIdChoiceErrorMessage = self::validateStyleIdForChoiceConstraintsFromSetStyleId($styleId))) {
            throw new \InvalidArgumentException($styleIdChoiceErrorMessage, __LINE__);
        }
        if (is_null($styleId) || (is_array($styleId) && empty($styleId))) {
            unset($this->styleId);
        } else {
            $this->styleId = $styleId;
        }
        return $this;
    }
    /**
     * Get acode value
     * @return string|null
     */
    public function getAcode()
    {
        return isset($this->acode) ? $this->acode : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcodeForChoiceConstraintsFromSetAcode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'modelYear',
            'makeName',
            'modelName',
            'vin',
            'reducingStyleId',
            'reducingAcode',
            'styleId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property acode can\'t be set as the property %s is already set. Only one property must be set among these properties: acode, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set acode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $acode
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setAcode($acode = null)
    {
        // validation for constraint: string
        if (!is_null($acode) && !is_string($acode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acode, true), gettype($acode)), __LINE__);
        }
        // validation for constraint: choice(modelYear, makeName, modelName, vin, reducingStyleId, reducingAcode, styleId, acode)
        if ('' !== ($acodeChoiceErrorMessage = self::validateAcodeForChoiceConstraintsFromSetAcode($acode))) {
            throw new \InvalidArgumentException($acodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($acode) || (is_array($acode) && empty($acode))) {
            unset($this->acode);
        } else {
            $this->acode = $acode;
        }
        return $this;
    }
    /**
     * Get styleName value
     * @return string|null
     */
    public function getStyleName()
    {
        return $this->styleName;
    }
    /**
     * Set styleName value
     * @param string $styleName
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setStyleName($styleName = null)
    {
        // validation for constraint: string
        if (!is_null($styleName) && !is_string($styleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($styleName, true), gettype($styleName)), __LINE__);
        }
        $this->styleName = $styleName;
        return $this;
    }
    /**
     * Get trimName value
     * @return string|null
     */
    public function getTrimName()
    {
        return $this->trimName;
    }
    /**
     * Set trimName value
     * @param string $trimName
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setTrimName($trimName = null)
    {
        // validation for constraint: string
        if (!is_null($trimName) && !is_string($trimName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trimName, true), gettype($trimName)), __LINE__);
        }
        $this->trimName = $trimName;
        return $this;
    }
    /**
     * Get manufacturerModelCode value
     * @return string|null
     */
    public function getManufacturerModelCode()
    {
        return $this->manufacturerModelCode;
    }
    /**
     * Set manufacturerModelCode value
     * @param string $manufacturerModelCode
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setManufacturerModelCode($manufacturerModelCode = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerModelCode) && !is_string($manufacturerModelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerModelCode, true), gettype($manufacturerModelCode)), __LINE__);
        }
        $this->manufacturerModelCode = $manufacturerModelCode;
        return $this;
    }
    /**
     * Get wheelBase value
     * @return float|null
     */
    public function getWheelBase()
    {
        return $this->wheelBase;
    }
    /**
     * Set wheelBase value
     * @param float $wheelBase
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setWheelBase($wheelBase = null)
    {
        // validation for constraint: float
        if (!is_null($wheelBase) && !(is_float($wheelBase) || is_numeric($wheelBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wheelBase, true), gettype($wheelBase)), __LINE__);
        }
        $this->wheelBase = $wheelBase;
        return $this;
    }
    /**
     * Get OEMOptionCode value
     * @return string[]|null
     */
    public function getOEMOptionCode()
    {
        return $this->OEMOptionCode;
    }
    /**
     * This method is responsible for validating the values passed to the setOEMOptionCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOEMOptionCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOEMOptionCodeForArrayConstraintsFromSetOEMOptionCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionRequestOEMOptionCodeItem) {
            // validation for constraint: itemType
            if (!is_string($vehicleDescriptionRequestOEMOptionCodeItem)) {
                $invalidValues[] = is_object($vehicleDescriptionRequestOEMOptionCodeItem) ? get_class($vehicleDescriptionRequestOEMOptionCodeItem) : sprintf('%s(%s)', gettype($vehicleDescriptionRequestOEMOptionCodeItem), var_export($vehicleDescriptionRequestOEMOptionCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OEMOptionCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OEMOptionCode value
     * @throws \InvalidArgumentException
     * @param string[] $oEMOptionCode
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setOEMOptionCode(array $oEMOptionCode = array())
    {
        // validation for constraint: array
        if ('' !== ($oEMOptionCodeArrayErrorMessage = self::validateOEMOptionCodeForArrayConstraintsFromSetOEMOptionCode($oEMOptionCode))) {
            throw new \InvalidArgumentException($oEMOptionCodeArrayErrorMessage, __LINE__);
        }
        $this->OEMOptionCode = $oEMOptionCode;
        return $this;
    }
    /**
     * Add item to OEMOptionCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VehicleDescriptionRequest
     */
    public function addToOEMOptionCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OEMOptionCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OEMOptionCode[] = $item;
        return $this;
    }
    /**
     * Get primaryOptionName value
     * @return string[]|null
     */
    public function getPrimaryOptionName()
    {
        return $this->primaryOptionName;
    }
    /**
     * This method is responsible for validating the values passed to the setPrimaryOptionName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimaryOptionName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrimaryOptionNameForArrayConstraintsFromSetPrimaryOptionName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionRequestPrimaryOptionNameItem) {
            // validation for constraint: itemType
            if (!is_string($vehicleDescriptionRequestPrimaryOptionNameItem)) {
                $invalidValues[] = is_object($vehicleDescriptionRequestPrimaryOptionNameItem) ? get_class($vehicleDescriptionRequestPrimaryOptionNameItem) : sprintf('%s(%s)', gettype($vehicleDescriptionRequestPrimaryOptionNameItem), var_export($vehicleDescriptionRequestPrimaryOptionNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The primaryOptionName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set primaryOptionName value
     * @throws \InvalidArgumentException
     * @param string[] $primaryOptionName
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setPrimaryOptionName(array $primaryOptionName = array())
    {
        // validation for constraint: array
        if ('' !== ($primaryOptionNameArrayErrorMessage = self::validatePrimaryOptionNameForArrayConstraintsFromSetPrimaryOptionName($primaryOptionName))) {
            throw new \InvalidArgumentException($primaryOptionNameArrayErrorMessage, __LINE__);
        }
        $this->primaryOptionName = $primaryOptionName;
        return $this;
    }
    /**
     * Add item to primaryOptionName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VehicleDescriptionRequest
     */
    public function addToPrimaryOptionName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The primaryOptionName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->primaryOptionName[] = $item;
        return $this;
    }
    /**
     * Get equipmentDescription value
     * @return string[]|null
     */
    public function getEquipmentDescription()
    {
        return $this->equipmentDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipmentDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipmentDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipmentDescriptionForArrayConstraintsFromSetEquipmentDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionRequestEquipmentDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($vehicleDescriptionRequestEquipmentDescriptionItem)) {
                $invalidValues[] = is_object($vehicleDescriptionRequestEquipmentDescriptionItem) ? get_class($vehicleDescriptionRequestEquipmentDescriptionItem) : sprintf('%s(%s)', gettype($vehicleDescriptionRequestEquipmentDescriptionItem), var_export($vehicleDescriptionRequestEquipmentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The equipmentDescription property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set equipmentDescription value
     * @throws \InvalidArgumentException
     * @param string[] $equipmentDescription
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setEquipmentDescription(array $equipmentDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($equipmentDescriptionArrayErrorMessage = self::validateEquipmentDescriptionForArrayConstraintsFromSetEquipmentDescription($equipmentDescription))) {
            throw new \InvalidArgumentException($equipmentDescriptionArrayErrorMessage, __LINE__);
        }
        $this->equipmentDescription = $equipmentDescription;
        return $this;
    }
    /**
     * Add item to equipmentDescription value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VehicleDescriptionRequest
     */
    public function addToEquipmentDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The equipmentDescription property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->equipmentDescription[] = $item;
        return $this;
    }
    /**
     * Get exteriorColorName value
     * @return string|null
     */
    public function getExteriorColorName()
    {
        return $this->exteriorColorName;
    }
    /**
     * Set exteriorColorName value
     * @param string $exteriorColorName
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setExteriorColorName($exteriorColorName = null)
    {
        // validation for constraint: string
        if (!is_null($exteriorColorName) && !is_string($exteriorColorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exteriorColorName, true), gettype($exteriorColorName)), __LINE__);
        }
        $this->exteriorColorName = $exteriorColorName;
        return $this;
    }
    /**
     * Get interiorColorName value
     * @return string|null
     */
    public function getInteriorColorName()
    {
        return $this->interiorColorName;
    }
    /**
     * Set interiorColorName value
     * @param string $interiorColorName
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setInteriorColorName($interiorColorName = null)
    {
        // validation for constraint: string
        if (!is_null($interiorColorName) && !is_string($interiorColorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interiorColorName, true), gettype($interiorColorName)), __LINE__);
        }
        $this->interiorColorName = $interiorColorName;
        return $this;
    }
    /**
     * Get nonFactoryEquipmentDescription value
     * @return string[]|null
     */
    public function getNonFactoryEquipmentDescription()
    {
        return $this->nonFactoryEquipmentDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setNonFactoryEquipmentDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNonFactoryEquipmentDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNonFactoryEquipmentDescriptionForArrayConstraintsFromSetNonFactoryEquipmentDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionRequestNonFactoryEquipmentDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($vehicleDescriptionRequestNonFactoryEquipmentDescriptionItem)) {
                $invalidValues[] = is_object($vehicleDescriptionRequestNonFactoryEquipmentDescriptionItem) ? get_class($vehicleDescriptionRequestNonFactoryEquipmentDescriptionItem) : sprintf('%s(%s)', gettype($vehicleDescriptionRequestNonFactoryEquipmentDescriptionItem), var_export($vehicleDescriptionRequestNonFactoryEquipmentDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nonFactoryEquipmentDescription property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nonFactoryEquipmentDescription value
     * @throws \InvalidArgumentException
     * @param string[] $nonFactoryEquipmentDescription
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setNonFactoryEquipmentDescription(array $nonFactoryEquipmentDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($nonFactoryEquipmentDescriptionArrayErrorMessage = self::validateNonFactoryEquipmentDescriptionForArrayConstraintsFromSetNonFactoryEquipmentDescription($nonFactoryEquipmentDescription))) {
            throw new \InvalidArgumentException($nonFactoryEquipmentDescriptionArrayErrorMessage, __LINE__);
        }
        $this->nonFactoryEquipmentDescription = $nonFactoryEquipmentDescription;
        return $this;
    }
    /**
     * Add item to nonFactoryEquipmentDescription value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VehicleDescriptionRequest
     */
    public function addToNonFactoryEquipmentDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The nonFactoryEquipmentDescription property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nonFactoryEquipmentDescription[] = $item;
        return $this;
    }
    /**
     * Get switch value
     * @return string[]|null
     */
    public function getSwitch()
    {
        return $this->switch;
    }
    /**
     * This method is responsible for validating the values passed to the setSwitch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSwitch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSwitchForArrayConstraintsFromSetSwitch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionRequestSwitchItem) {
            // validation for constraint: enumeration
            if (!\EnumType\_Switch::valueIsValid($vehicleDescriptionRequestSwitchItem)) {
                $invalidValues[] = is_object($vehicleDescriptionRequestSwitchItem) ? get_class($vehicleDescriptionRequestSwitchItem) : sprintf('%s(%s)', gettype($vehicleDescriptionRequestSwitchItem), var_export($vehicleDescriptionRequestSwitchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\_Switch', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\_Switch::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set switch value
     * @uses \EnumType\_Switch::valueIsValid()
     * @uses \EnumType\_Switch::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $switch
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setSwitch(array $switch = array())
    {
        // validation for constraint: array
        if ('' !== ($switchArrayErrorMessage = self::validateSwitchForArrayConstraintsFromSetSwitch($switch))) {
            throw new \InvalidArgumentException($switchArrayErrorMessage, __LINE__);
        }
        $this->switch = $switch;
        return $this;
    }
    /**
     * Add item to switch value
     * @uses \EnumType\_Switch::valueIsValid()
     * @uses \EnumType\_Switch::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VehicleDescriptionRequest
     */
    public function addToSwitch($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\_Switch::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\_Switch', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\_Switch::getValidValues())), __LINE__);
        }
        $this->switch[] = $item;
        return $this;
    }
    /**
     * Get vehicleProcessMode value
     * @return string|null
     */
    public function getVehicleProcessMode()
    {
        return $this->vehicleProcessMode;
    }
    /**
     * Set vehicleProcessMode value
     * @uses \EnumType\SwitchAvailability::valueIsValid()
     * @uses \EnumType\SwitchAvailability::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleProcessMode
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setVehicleProcessMode($vehicleProcessMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SwitchAvailability::valueIsValid($vehicleProcessMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SwitchAvailability', is_array($vehicleProcessMode) ? implode(', ', $vehicleProcessMode) : var_export($vehicleProcessMode, true), implode(', ', \EnumType\SwitchAvailability::getValidValues())), __LINE__);
        }
        $this->vehicleProcessMode = $vehicleProcessMode;
        return $this;
    }
    /**
     * Get optionsProcessMode value
     * @return string|null
     */
    public function getOptionsProcessMode()
    {
        return $this->optionsProcessMode;
    }
    /**
     * Set optionsProcessMode value
     * @uses \EnumType\SwitchAvailability::valueIsValid()
     * @uses \EnumType\SwitchAvailability::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsProcessMode
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setOptionsProcessMode($optionsProcessMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SwitchAvailability::valueIsValid($optionsProcessMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SwitchAvailability', is_array($optionsProcessMode) ? implode(', ', $optionsProcessMode) : var_export($optionsProcessMode, true), implode(', ', \EnumType\SwitchAvailability::getValidValues())), __LINE__);
        }
        $this->optionsProcessMode = $optionsProcessMode;
        return $this;
    }
    /**
     * Get includeMediaGallery value
     * @return string|null
     */
    public function getIncludeMediaGallery()
    {
        return $this->includeMediaGallery;
    }
    /**
     * Set includeMediaGallery value
     * @uses \EnumType\SwitchChromeMediaGallery::valueIsValid()
     * @uses \EnumType\SwitchChromeMediaGallery::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeMediaGallery
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setIncludeMediaGallery($includeMediaGallery = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SwitchChromeMediaGallery::valueIsValid($includeMediaGallery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SwitchChromeMediaGallery', is_array($includeMediaGallery) ? implode(', ', $includeMediaGallery) : var_export($includeMediaGallery, true), implode(', ', \EnumType\SwitchChromeMediaGallery::getValidValues())), __LINE__);
        }
        $this->includeMediaGallery = $includeMediaGallery;
        return $this;
    }
    /**
     * Get includeTechnicalSpecificationTitleId value
     * @return int[]|null
     */
    public function getIncludeTechnicalSpecificationTitleId()
    {
        return $this->includeTechnicalSpecificationTitleId;
    }
    /**
     * This method is responsible for validating the values passed to the setIncludeTechnicalSpecificationTitleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIncludeTechnicalSpecificationTitleId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIncludeTechnicalSpecificationTitleIdForArrayConstraintsFromSetIncludeTechnicalSpecificationTitleId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleDescriptionRequestIncludeTechnicalSpecificationTitleIdItem) {
            // validation for constraint: itemType
            if (!(is_int($vehicleDescriptionRequestIncludeTechnicalSpecificationTitleIdItem) || ctype_digit($vehicleDescriptionRequestIncludeTechnicalSpecificationTitleIdItem))) {
                $invalidValues[] = is_object($vehicleDescriptionRequestIncludeTechnicalSpecificationTitleIdItem) ? get_class($vehicleDescriptionRequestIncludeTechnicalSpecificationTitleIdItem) : sprintf('%s(%s)', gettype($vehicleDescriptionRequestIncludeTechnicalSpecificationTitleIdItem), var_export($vehicleDescriptionRequestIncludeTechnicalSpecificationTitleIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The includeTechnicalSpecificationTitleId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set includeTechnicalSpecificationTitleId value
     * @throws \InvalidArgumentException
     * @param int[] $includeTechnicalSpecificationTitleId
     * @return \StructType\VehicleDescriptionRequest
     */
    public function setIncludeTechnicalSpecificationTitleId(array $includeTechnicalSpecificationTitleId = array())
    {
        // validation for constraint: array
        if ('' !== ($includeTechnicalSpecificationTitleIdArrayErrorMessage = self::validateIncludeTechnicalSpecificationTitleIdForArrayConstraintsFromSetIncludeTechnicalSpecificationTitleId($includeTechnicalSpecificationTitleId))) {
            throw new \InvalidArgumentException($includeTechnicalSpecificationTitleIdArrayErrorMessage, __LINE__);
        }
        $this->includeTechnicalSpecificationTitleId = $includeTechnicalSpecificationTitleId;
        return $this;
    }
    /**
     * Add item to includeTechnicalSpecificationTitleId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\VehicleDescriptionRequest
     */
    public function addToIncludeTechnicalSpecificationTitleId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The includeTechnicalSpecificationTitleId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->includeTechnicalSpecificationTitleId[] = $item;
        return $this;
    }
}
