<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TechnicalSpecificationDefinition StructType
 * @subpackage Structs
 */
class TechnicalSpecificationDefinition extends AbstractStructBase
{
    /**
     * The group
     * @var \StructType\IdentifiedString
     */
    public $group;
    /**
     * The header
     * @var \StructType\IdentifiedString
     */
    public $header;
    /**
     * The title
     * @var \StructType\IdentifiedString
     */
    public $title;
    /**
     * The measurementUnit
     * @var string
     */
    public $measurementUnit;
    /**
     * Constructor method for TechnicalSpecificationDefinition
     * @uses TechnicalSpecificationDefinition::setGroup()
     * @uses TechnicalSpecificationDefinition::setHeader()
     * @uses TechnicalSpecificationDefinition::setTitle()
     * @uses TechnicalSpecificationDefinition::setMeasurementUnit()
     * @param \StructType\IdentifiedString $group
     * @param \StructType\IdentifiedString $header
     * @param \StructType\IdentifiedString $title
     * @param string $measurementUnit
     */
    public function __construct(\StructType\IdentifiedString $group = null, \StructType\IdentifiedString $header = null, \StructType\IdentifiedString $title = null, $measurementUnit = null)
    {
        $this
            ->setGroup($group)
            ->setHeader($header)
            ->setTitle($title)
            ->setMeasurementUnit($measurementUnit);
    }
    /**
     * Get group value
     * @return \StructType\IdentifiedString|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param \StructType\IdentifiedString $group
     * @return \StructType\TechnicalSpecificationDefinition
     */
    public function setGroup(\StructType\IdentifiedString $group = null)
    {
        $this->group = $group;
        return $this;
    }
    /**
     * Get header value
     * @return \StructType\IdentifiedString|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param \StructType\IdentifiedString $header
     * @return \StructType\TechnicalSpecificationDefinition
     */
    public function setHeader(\StructType\IdentifiedString $header = null)
    {
        $this->header = $header;
        return $this;
    }
    /**
     * Get title value
     * @return \StructType\IdentifiedString|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param \StructType\IdentifiedString $title
     * @return \StructType\TechnicalSpecificationDefinition
     */
    public function setTitle(\StructType\IdentifiedString $title = null)
    {
        $this->title = $title;
        return $this;
    }
    /**
     * Get measurementUnit value
     * @return string|null
     */
    public function getMeasurementUnit()
    {
        return $this->measurementUnit;
    }
    /**
     * Set measurementUnit value
     * @param string $measurementUnit
     * @return \StructType\TechnicalSpecificationDefinition
     */
    public function setMeasurementUnit($measurementUnit = null)
    {
        // validation for constraint: string
        if (!is_null($measurementUnit) && !is_string($measurementUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measurementUnit, true), gettype($measurementUnit)), __LINE__);
        }
        $this->measurementUnit = $measurementUnit;
        return $this;
    }
}
