<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Option StructType
 * @subpackage Structs
 */
class Option extends AbstractStructBase
{
    /**
     * The header
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IdentifiedString
     */
    public $header;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $description;
    /**
     * The oem_description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OemDescription[]
     */
    public $oem_description;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CategoryAssociation[]
     */
    public $category;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OptionPrice
     */
    public $price;
    /**
     * The styleId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $styleId;
    /**
     * The installed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InstallationCause
     */
    public $installed;
    /**
     * The ambiguousOption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Option[]
     */
    public $ambiguousOption;
    /**
     * The chromeCode
     * @var string
     */
    public $chromeCode;
    /**
     * The oemCode
     * @var string
     */
    public $oemCode;
    /**
     * The altOptionCode
     * @var string
     */
    public $altOptionCode;
    /**
     * The standard
     * @var bool
     */
    public $standard;
    /**
     * The optionKindId
     * @var int
     */
    public $optionKindId;
    /**
     * The utf
     * @var string
     */
    public $utf;
    /**
     * The fleetOnly
     * @var bool
     */
    public $fleetOnly;
    /**
     * Constructor method for Option
     * @uses Option::setHeader()
     * @uses Option::setDescription()
     * @uses Option::setOem_description()
     * @uses Option::setCategory()
     * @uses Option::setPrice()
     * @uses Option::setStyleId()
     * @uses Option::setInstalled()
     * @uses Option::setAmbiguousOption()
     * @uses Option::setChromeCode()
     * @uses Option::setOemCode()
     * @uses Option::setAltOptionCode()
     * @uses Option::setStandard()
     * @uses Option::setOptionKindId()
     * @uses Option::setUtf()
     * @uses Option::setFleetOnly()
     * @param \StructType\IdentifiedString $header
     * @param string[] $description
     * @param \StructType\OemDescription[] $oem_description
     * @param \StructType\CategoryAssociation[] $category
     * @param \StructType\OptionPrice $price
     * @param int[] $styleId
     * @param \StructType\InstallationCause $installed
     * @param \StructType\Option[] $ambiguousOption
     * @param string $chromeCode
     * @param string $oemCode
     * @param string $altOptionCode
     * @param bool $standard
     * @param int $optionKindId
     * @param string $utf
     * @param bool $fleetOnly
     */
    public function __construct(\StructType\IdentifiedString $header = null, array $description = array(), array $oem_description = array(), array $category = array(), \StructType\OptionPrice $price = null, array $styleId = array(), \StructType\InstallationCause $installed = null, array $ambiguousOption = array(), $chromeCode = null, $oemCode = null, $altOptionCode = null, $standard = null, $optionKindId = null, $utf = null, $fleetOnly = null)
    {
        $this
            ->setHeader($header)
            ->setDescription($description)
            ->setOem_description($oem_description)
            ->setCategory($category)
            ->setPrice($price)
            ->setStyleId($styleId)
            ->setInstalled($installed)
            ->setAmbiguousOption($ambiguousOption)
            ->setChromeCode($chromeCode)
            ->setOemCode($oemCode)
            ->setAltOptionCode($altOptionCode)
            ->setStandard($standard)
            ->setOptionKindId($optionKindId)
            ->setUtf($utf)
            ->setFleetOnly($fleetOnly);
    }
    /**
     * Get header value
     * @return \StructType\IdentifiedString|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param \StructType\IdentifiedString $header
     * @return \StructType\Option
     */
    public function setHeader(\StructType\IdentifiedString $header = null)
    {
        $this->header = $header;
        return $this;
    }
    /**
     * Get description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($optionDescriptionItem)) {
                $invalidValues[] = is_object($optionDescriptionItem) ? get_class($optionDescriptionItem) : sprintf('%s(%s)', gettype($optionDescriptionItem), var_export($optionDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The description property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \StructType\Option
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Add item to description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Option
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The description property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->description[] = $item;
        return $this;
    }
    /**
     * Get oem_description value
     * @return \StructType\OemDescription[]|null
     */
    public function getOem_description()
    {
        return $this->{'oem-description'};
    }
    /**
     * This method is responsible for validating the values passed to the setOem_description method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOem_description method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOem_descriptionForArrayConstraintsFromSetOem_description(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionOem_descriptionItem) {
            // validation for constraint: itemType
            if (!$optionOem_descriptionItem instanceof \StructType\OemDescription) {
                $invalidValues[] = is_object($optionOem_descriptionItem) ? get_class($optionOem_descriptionItem) : sprintf('%s(%s)', gettype($optionOem_descriptionItem), var_export($optionOem_descriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The oem_description property can only contain items of type \StructType\OemDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set oem_description value
     * @throws \InvalidArgumentException
     * @param \StructType\OemDescription[] $oem_description
     * @return \StructType\Option
     */
    public function setOem_description(array $oem_description = array())
    {
        // validation for constraint: array
        if ('' !== ($oem_descriptionArrayErrorMessage = self::validateOem_descriptionForArrayConstraintsFromSetOem_description($oem_description))) {
            throw new \InvalidArgumentException($oem_descriptionArrayErrorMessage, __LINE__);
        }
        $this->oem_description = $this->{'oem-description'} = $oem_description;
        return $this;
    }
    /**
     * Add item to oem_description value
     * @throws \InvalidArgumentException
     * @param \StructType\OemDescription $item
     * @return \StructType\Option
     */
    public function addToOem_description(\StructType\OemDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OemDescription) {
            throw new \InvalidArgumentException(sprintf('The oem_description property can only contain items of type \StructType\OemDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->oem_description[] = $this->{'oem-description'}[] = $item;
        return $this;
    }
    /**
     * Get category value
     * @return \StructType\CategoryAssociation[]|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * This method is responsible for validating the values passed to the setCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoryForArrayConstraintsFromSetCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionCategoryItem) {
            // validation for constraint: itemType
            if (!$optionCategoryItem instanceof \StructType\CategoryAssociation) {
                $invalidValues[] = is_object($optionCategoryItem) ? get_class($optionCategoryItem) : sprintf('%s(%s)', gettype($optionCategoryItem), var_export($optionCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The category property can only contain items of type \StructType\CategoryAssociation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAssociation[] $category
     * @return \StructType\Option
     */
    public function setCategory(array $category = array())
    {
        // validation for constraint: array
        if ('' !== ($categoryArrayErrorMessage = self::validateCategoryForArrayConstraintsFromSetCategory($category))) {
            throw new \InvalidArgumentException($categoryArrayErrorMessage, __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Add item to category value
     * @throws \InvalidArgumentException
     * @param \StructType\CategoryAssociation $item
     * @return \StructType\Option
     */
    public function addToCategory(\StructType\CategoryAssociation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CategoryAssociation) {
            throw new \InvalidArgumentException(sprintf('The category property can only contain items of type \StructType\CategoryAssociation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->category[] = $item;
        return $this;
    }
    /**
     * Get price value
     * @return \StructType\OptionPrice|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \StructType\OptionPrice $price
     * @return \StructType\Option
     */
    public function setPrice(\StructType\OptionPrice $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get styleId value
     * @return int[]|null
     */
    public function getStyleId()
    {
        return $this->styleId;
    }
    /**
     * This method is responsible for validating the values passed to the setStyleId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStyleId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStyleIdForArrayConstraintsFromSetStyleId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionStyleIdItem) {
            // validation for constraint: itemType
            if (!(is_int($optionStyleIdItem) || ctype_digit($optionStyleIdItem))) {
                $invalidValues[] = is_object($optionStyleIdItem) ? get_class($optionStyleIdItem) : sprintf('%s(%s)', gettype($optionStyleIdItem), var_export($optionStyleIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The styleId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set styleId value
     * @throws \InvalidArgumentException
     * @param int[] $styleId
     * @return \StructType\Option
     */
    public function setStyleId(array $styleId = array())
    {
        // validation for constraint: array
        if ('' !== ($styleIdArrayErrorMessage = self::validateStyleIdForArrayConstraintsFromSetStyleId($styleId))) {
            throw new \InvalidArgumentException($styleIdArrayErrorMessage, __LINE__);
        }
        $this->styleId = $styleId;
        return $this;
    }
    /**
     * Add item to styleId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\Option
     */
    public function addToStyleId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The styleId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->styleId[] = $item;
        return $this;
    }
    /**
     * Get installed value
     * @return \StructType\InstallationCause|null
     */
    public function getInstalled()
    {
        return $this->installed;
    }
    /**
     * Set installed value
     * @param \StructType\InstallationCause $installed
     * @return \StructType\Option
     */
    public function setInstalled(\StructType\InstallationCause $installed = null)
    {
        $this->installed = $installed;
        return $this;
    }
    /**
     * Get ambiguousOption value
     * @return \StructType\Option[]|null
     */
    public function getAmbiguousOption()
    {
        return $this->ambiguousOption;
    }
    /**
     * This method is responsible for validating the values passed to the setAmbiguousOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmbiguousOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmbiguousOptionForArrayConstraintsFromSetAmbiguousOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $optionAmbiguousOptionItem) {
            // validation for constraint: itemType
            if (!$optionAmbiguousOptionItem instanceof \StructType\Option) {
                $invalidValues[] = is_object($optionAmbiguousOptionItem) ? get_class($optionAmbiguousOptionItem) : sprintf('%s(%s)', gettype($optionAmbiguousOptionItem), var_export($optionAmbiguousOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ambiguousOption property can only contain items of type \StructType\Option, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ambiguousOption value
     * @throws \InvalidArgumentException
     * @param \StructType\Option[] $ambiguousOption
     * @return \StructType\Option
     */
    public function setAmbiguousOption(array $ambiguousOption = array())
    {
        // validation for constraint: array
        if ('' !== ($ambiguousOptionArrayErrorMessage = self::validateAmbiguousOptionForArrayConstraintsFromSetAmbiguousOption($ambiguousOption))) {
            throw new \InvalidArgumentException($ambiguousOptionArrayErrorMessage, __LINE__);
        }
        $this->ambiguousOption = $ambiguousOption;
        return $this;
    }
    /**
     * Add item to ambiguousOption value
     * @throws \InvalidArgumentException
     * @param \StructType\Option $item
     * @return \StructType\Option
     */
    public function addToAmbiguousOption(\StructType\Option $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Option) {
            throw new \InvalidArgumentException(sprintf('The ambiguousOption property can only contain items of type \StructType\Option, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ambiguousOption[] = $item;
        return $this;
    }
    /**
     * Get chromeCode value
     * @return string|null
     */
    public function getChromeCode()
    {
        return $this->chromeCode;
    }
    /**
     * Set chromeCode value
     * @param string $chromeCode
     * @return \StructType\Option
     */
    public function setChromeCode($chromeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chromeCode) && !is_string($chromeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chromeCode, true), gettype($chromeCode)), __LINE__);
        }
        $this->chromeCode = $chromeCode;
        return $this;
    }
    /**
     * Get oemCode value
     * @return string|null
     */
    public function getOemCode()
    {
        return $this->oemCode;
    }
    /**
     * Set oemCode value
     * @param string $oemCode
     * @return \StructType\Option
     */
    public function setOemCode($oemCode = null)
    {
        // validation for constraint: string
        if (!is_null($oemCode) && !is_string($oemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oemCode, true), gettype($oemCode)), __LINE__);
        }
        $this->oemCode = $oemCode;
        return $this;
    }
    /**
     * Get altOptionCode value
     * @return string|null
     */
    public function getAltOptionCode()
    {
        return $this->altOptionCode;
    }
    /**
     * Set altOptionCode value
     * @param string $altOptionCode
     * @return \StructType\Option
     */
    public function setAltOptionCode($altOptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($altOptionCode) && !is_string($altOptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altOptionCode, true), gettype($altOptionCode)), __LINE__);
        }
        $this->altOptionCode = $altOptionCode;
        return $this;
    }
    /**
     * Get standard value
     * @return bool|null
     */
    public function getStandard()
    {
        return $this->standard;
    }
    /**
     * Set standard value
     * @param bool $standard
     * @return \StructType\Option
     */
    public function setStandard($standard = null)
    {
        // validation for constraint: boolean
        if (!is_null($standard) && !is_bool($standard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($standard, true), gettype($standard)), __LINE__);
        }
        $this->standard = $standard;
        return $this;
    }
    /**
     * Get optionKindId value
     * @return int|null
     */
    public function getOptionKindId()
    {
        return $this->optionKindId;
    }
    /**
     * Set optionKindId value
     * @param int $optionKindId
     * @return \StructType\Option
     */
    public function setOptionKindId($optionKindId = null)
    {
        // validation for constraint: int
        if (!is_null($optionKindId) && !(is_int($optionKindId) || ctype_digit($optionKindId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionKindId, true), gettype($optionKindId)), __LINE__);
        }
        $this->optionKindId = $optionKindId;
        return $this;
    }
    /**
     * Get utf value
     * @return string|null
     */
    public function getUtf()
    {
        return $this->utf;
    }
    /**
     * Set utf value
     * @param string $utf
     * @return \StructType\Option
     */
    public function setUtf($utf = null)
    {
        // validation for constraint: string
        if (!is_null($utf) && !is_string($utf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utf, true), gettype($utf)), __LINE__);
        }
        $this->utf = $utf;
        return $this;
    }
    /**
     * Get fleetOnly value
     * @return bool|null
     */
    public function getFleetOnly()
    {
        return $this->fleetOnly;
    }
    /**
     * Set fleetOnly value
     * @param bool $fleetOnly
     * @return \StructType\Option
     */
    public function setFleetOnly($fleetOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($fleetOnly) && !is_bool($fleetOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fleetOnly, true), gettype($fleetOnly)), __LINE__);
        }
        $this->fleetOnly = $fleetOnly;
        return $this;
    }
}
