<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The conditionNote
     * @var string
     */
    public $conditionNote;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for item
     * @uses Item::setName()
     * @uses Item::setConditionNote()
     * @uses Item::setValue()
     * @param string $name
     * @param string $conditionNote
     * @param string $value
     */
    public function __construct($name = null, $conditionNote = null, $value = null)
    {
        $this
            ->setName($name)
            ->setConditionNote($conditionNote)
            ->setValue($value);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Item
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get conditionNote value
     * @return string|null
     */
    public function getConditionNote()
    {
        return $this->conditionNote;
    }
    /**
     * Set conditionNote value
     * @param string $conditionNote
     * @return \StructType\Item
     */
    public function setConditionNote($conditionNote = null)
    {
        // validation for constraint: string
        if (!is_null($conditionNote) && !is_string($conditionNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionNote, true), gettype($conditionNote)), __LINE__);
        }
        $this->conditionNote = $conditionNote;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\Item
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
