<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryAssociation StructType
 * @subpackage Structs
 */
class CategoryAssociation extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $id;
    /**
     * The removed
     * @var bool
     */
    public $removed;
    /**
     * Constructor method for CategoryAssociation
     * @uses CategoryAssociation::setId()
     * @uses CategoryAssociation::setRemoved()
     * @param int $id
     * @param bool $removed
     */
    public function __construct($id = null, $removed = null)
    {
        $this
            ->setId($id)
            ->setRemoved($removed);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\CategoryAssociation
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get removed value
     * @return bool|null
     */
    public function getRemoved()
    {
        return $this->removed;
    }
    /**
     * Set removed value
     * @param bool $removed
     * @return \StructType\CategoryAssociation
     */
    public function setRemoved($removed = null)
    {
        // validation for constraint: boolean
        if (!is_null($removed) && !is_bool($removed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removed, true), gettype($removed)), __LINE__);
        }
        $this->removed = $removed;
        return $this;
    }
}
