<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Switch EnumType
 * Meta information extracted from the WSDL
 * - documentation: Adding one or more switch strings to your request will change the behavior of ADS. Use the following switches to match output with your particular needs.
 * @subpackage Enumerations
 */
class _Switch extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DisableSafeStandards'
     * Meta information extracted from the WSDL
     * - documentation: By default, only equipment that could not have been upgraded or removed will be presented as installed. When you use this switch, any equipment that could be standard equipment will be installed even if they could have been removed
     * or upgraded.
     * @return string 'DisableSafeStandards'
     */
    const VALUE_DISABLE_SAFE_STANDARDS = 'DisableSafeStandards';
    /**
     * Constant for value 'ShowExtendedDescriptions'
     * Meta information extracted from the WSDL
     * - documentation: Causes ADS to provide additional description information for each piece of equipment.
     * @return string 'ShowExtendedDescriptions'
     */
    const VALUE_SHOW_EXTENDED_DESCRIPTIONS = 'ShowExtendedDescriptions';
    /**
     * Constant for value 'ShowAvailableEquipment'
     * Meta information extracted from the WSDL
     * - documentation: Causes ADS to show information about all equipment available for the vehicle, whether or not it is installed.
     * @return string 'ShowAvailableEquipment'
     */
    const VALUE_SHOW_AVAILABLE_EQUIPMENT = 'ShowAvailableEquipment';
    /**
     * Constant for value 'ShowConsumerInformation'
     * Meta information extracted from the WSDL
     * - documentation: Causes ADS to show normalized consumer information such as recalls, awards, and test results.
     * @return string 'ShowConsumerInformation'
     */
    const VALUE_SHOW_CONSUMER_INFORMATION = 'ShowConsumerInformation';
    /**
     * Constant for value 'ShowExtendedTechnicalSpecifications'
     * Meta information extracted from the WSDL
     * - documentation: Causes ADS to show all available technical specifications for the vehicle, and additional information about them.
     * @return string 'ShowExtendedTechnicalSpecifications'
     */
    const VALUE_SHOW_EXTENDED_TECHNICAL_SPECIFICATIONS = 'ShowExtendedTechnicalSpecifications';
    /**
     * Constant for value 'IncludeRegionalVehicles'
     * Meta information extracted from the WSDL
     * - documentation: By default, only vehicles sold nationally are considered for description. This switch causes ADS to also consider vehicles sold only regionally.
     * @return string 'IncludeRegionalVehicles'
     */
    const VALUE_INCLUDE_REGIONAL_VEHICLES = 'IncludeRegionalVehicles';
    /**
     * Constant for value 'UseDependencyOrderingLogic'
     * Meta information extracted from the WSDL
     * - documentation: By default, ADS describes and installs only equipment specifically known to exist (usually because of user input.) This switch causes ADS to consider ordering logic caused by the installed equipment itself in addition to the ordering
     * logic of the user-identified equipment.
     * @return string 'UseDependencyOrderingLogic'
     */
    const VALUE_USE_DEPENDENCY_ORDERING_LOGIC = 'UseDependencyOrderingLogic';
    /**
     * Constant for value 'IncludeDefinitions'
     * Meta information extracted from the WSDL
     * - documentation: Causes ADS to show Category and Technical Specification definitions in-line within a vehicle description.
     * @return string 'IncludeDefinitions'
     */
    const VALUE_INCLUDE_DEFINITIONS = 'IncludeDefinitions';
    /**
     * Constant for value 'IncludeOnlyOEMBuildDataDecode'
     * Meta information extracted from the WSDL
     * - documentation: The switch shall enable dealers that are VAR licensed for build data with ADS to receive a successful response if build data is returned.
     * @return string 'IncludeOnlyOEMBuildDataDecode'
     */
    const VALUE_INCLUDE_ONLY_OEMBUILD_DATA_DECODE = 'IncludeOnlyOEMBuildDataDecode';
    /**
     * Constant for value 'DisableStandardEquipment'
     * Meta information extracted from the WSDL
     * - documentation: By default ADS shows installed standards and those who do not want standards can use this switch to omit the standards.
     * @return string 'DisableStandardEquipment'
     */
    const VALUE_DISABLE_STANDARD_EQUIPMENT = 'DisableStandardEquipment';
    /**
     * Return allowed values
     * @uses self::VALUE_DISABLE_SAFE_STANDARDS
     * @uses self::VALUE_SHOW_EXTENDED_DESCRIPTIONS
     * @uses self::VALUE_SHOW_AVAILABLE_EQUIPMENT
     * @uses self::VALUE_SHOW_CONSUMER_INFORMATION
     * @uses self::VALUE_SHOW_EXTENDED_TECHNICAL_SPECIFICATIONS
     * @uses self::VALUE_INCLUDE_REGIONAL_VEHICLES
     * @uses self::VALUE_USE_DEPENDENCY_ORDERING_LOGIC
     * @uses self::VALUE_INCLUDE_DEFINITIONS
     * @uses self::VALUE_INCLUDE_ONLY_OEMBUILD_DATA_DECODE
     * @uses self::VALUE_DISABLE_STANDARD_EQUIPMENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DISABLE_SAFE_STANDARDS,
            self::VALUE_SHOW_EXTENDED_DESCRIPTIONS,
            self::VALUE_SHOW_AVAILABLE_EQUIPMENT,
            self::VALUE_SHOW_CONSUMER_INFORMATION,
            self::VALUE_SHOW_EXTENDED_TECHNICAL_SPECIFICATIONS,
            self::VALUE_INCLUDE_REGIONAL_VEHICLES,
            self::VALUE_USE_DEPENDENCY_ORDERING_LOGIC,
            self::VALUE_INCLUDE_DEFINITIONS,
            self::VALUE_INCLUDE_ONLY_OEMBUILD_DATA_DECODE,
            self::VALUE_DISABLE_STANDARD_EQUIPMENT,
        );
    }
}
