<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SwitchChromeMediaGallery EnumType
 * Meta information extracted from the WSDL
 * - documentation: Provides a Chrome Media Gallery URL's associated with the described vehicle. Your user license dictates which views (none, multi-view, colorMatch, or both) are available. The default value is the most your license permits (hopefully
 * "both.")
 * @subpackage Enumerations
 */
class SwitchChromeMediaGallery extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Multi-View'
     * Meta information extracted from the WSDL
     * - documentation: Provide Multi-view images, if the client license permits.
     * @return string 'Multi-View'
     */
    const VALUE_MULTI_VIEW = 'Multi-View';
    /**
     * Constant for value 'ColorMatch'
     * Meta information extracted from the WSDL
     * - documentation: Provide ColorMatch images, if the client license permits.
     * @return string 'ColorMatch'
     */
    const VALUE_COLOR_MATCH = 'ColorMatch';
    /**
     * Constant for value 'Both'
     * Meta information extracted from the WSDL
     * - documentation: Provide both image types, if the client license permits.
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Return allowed values
     * @uses self::VALUE_MULTI_VIEW
     * @uses self::VALUE_COLOR_MATCH
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MULTI_VIEW,
            self::VALUE_COLOR_MATCH,
            self::VALUE_BOTH,
        );
    }
}
