<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TSkrytkaPocztowa StructType
 * Meta information extracted from the WSDL
 * - documentation: Dane opisujące skrytkę pocztową
 * @subpackage Structs
 */
class TSkrytkaPocztowa extends AbstractStructBase
{
    /**
     * The KodPocztowy
     * Meta information extracted from the WSDL
     * - documentation: Kod pocztowy | Polski kod pocztowy
     * - base: adr:TKodPocztowy
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: \d{5}|(\d{2}\-\d{3})
     * @var string
     */
    public $KodPocztowy;
    /**
     * The NumerSkrytki
     * Meta information extracted from the WSDL
     * - documentation: Numer skrytki pocztowej
     * - base: xs:token
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $NumerSkrytki;
    /**
     * The Poczta
     * Meta information extracted from the WSDL
     * - documentation: Nazwa urzędu pocztowego
     * - base: xs:token
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Poczta;
    /**
     * Constructor method for TSkrytkaPocztowa
     * @uses TSkrytkaPocztowa::setKodPocztowy()
     * @uses TSkrytkaPocztowa::setNumerSkrytki()
     * @uses TSkrytkaPocztowa::setPoczta()
     * @param string $kodPocztowy
     * @param string $numerSkrytki
     * @param string $poczta
     */
    public function __construct($kodPocztowy = null, $numerSkrytki = null, $poczta = null)
    {
        $this
            ->setKodPocztowy($kodPocztowy)
            ->setNumerSkrytki($numerSkrytki)
            ->setPoczta($poczta);
    }
    /**
     * Get KodPocztowy value
     * @return string
     */
    public function getKodPocztowy()
    {
        return $this->KodPocztowy;
    }
    /**
     * Set KodPocztowy value
     * @param string $kodPocztowy
     * @return \StructType\TSkrytkaPocztowa
     */
    public function setKodPocztowy($kodPocztowy = null)
    {
        // validation for constraint: string
        if (!is_null($kodPocztowy) && !is_string($kodPocztowy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodPocztowy, true), gettype($kodPocztowy)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($kodPocztowy) && mb_strlen($kodPocztowy) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($kodPocztowy)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kodPocztowy) && mb_strlen($kodPocztowy) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kodPocztowy)), __LINE__);
        }
        // validation for constraint: pattern(\d{5}|(\d{2}\-\d{3}))
        if (!is_null($kodPocztowy) && !preg_match('/\\d{5}|(\\d{2}\\-\\d{3})/', $kodPocztowy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{5}|(\d{2}\-\d{3})', var_export($kodPocztowy, true)), __LINE__);
        }
        $this->KodPocztowy = $kodPocztowy;
        return $this;
    }
    /**
     * Get NumerSkrytki value
     * @return string
     */
    public function getNumerSkrytki()
    {
        return $this->NumerSkrytki;
    }
    /**
     * Set NumerSkrytki value
     * @param string $numerSkrytki
     * @return \StructType\TSkrytkaPocztowa
     */
    public function setNumerSkrytki($numerSkrytki = null)
    {
        // validation for constraint: string
        if (!is_null($numerSkrytki) && !is_string($numerSkrytki)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerSkrytki, true), gettype($numerSkrytki)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($numerSkrytki) && mb_strlen($numerSkrytki) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($numerSkrytki)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numerSkrytki) && mb_strlen($numerSkrytki) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numerSkrytki)), __LINE__);
        }
        $this->NumerSkrytki = $numerSkrytki;
        return $this;
    }
    /**
     * Get Poczta value
     * @return string
     */
    public function getPoczta()
    {
        return $this->Poczta;
    }
    /**
     * Set Poczta value
     * @param string $poczta
     * @return \StructType\TSkrytkaPocztowa
     */
    public function setPoczta($poczta = null)
    {
        // validation for constraint: string
        if (!is_null($poczta) && !is_string($poczta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poczta, true), gettype($poczta)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($poczta) && mb_strlen($poczta) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($poczta)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($poczta) && mb_strlen($poczta) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($poczta)), __LINE__);
        }
        $this->Poczta = $poczta;
        return $this;
    }
}
