<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TDokumentTozsamosci StructType
 * Meta information extracted from the WSDL
 * - documentation: Dane dokumentu tożsamosci
 * @subpackage Structs
 */
class TDokumentTozsamosci extends AbstractStructBase
{
    /**
     * The Numer
     * Meta information extracted from the WSDL
     * - documentation: Numer dokumentu | Numer dokumentu tożsamości
     * - base: xs:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Numer;
    /**
     * The Rodzaj
     * Meta information extracted from the WSDL
     * - documentation: Rodzaj dokumentu
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Rodzaj;
    /**
     * Constructor method for TDokumentTozsamosci
     * @uses TDokumentTozsamosci::setNumer()
     * @uses TDokumentTozsamosci::setRodzaj()
     * @param string $numer
     * @param string $rodzaj
     */
    public function __construct($numer = null, $rodzaj = null)
    {
        $this
            ->setNumer($numer)
            ->setRodzaj($rodzaj);
    }
    /**
     * Get Numer value
     * @return string
     */
    public function getNumer()
    {
        return $this->Numer;
    }
    /**
     * Set Numer value
     * @param string $numer
     * @return \StructType\TDokumentTozsamosci
     */
    public function setNumer($numer = null)
    {
        // validation for constraint: string
        if (!is_null($numer) && !is_string($numer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numer, true), gettype($numer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($numer) && mb_strlen($numer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($numer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numer) && mb_strlen($numer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numer)), __LINE__);
        }
        $this->Numer = $numer;
        return $this;
    }
    /**
     * Get Rodzaj value
     * @return string
     */
    public function getRodzaj()
    {
        return $this->Rodzaj;
    }
    /**
     * Set Rodzaj value
     * @uses \EnumType\TRodzajDokumentuTozsamosci::valueIsValid()
     * @uses \EnumType\TRodzajDokumentuTozsamosci::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rodzaj
     * @return \StructType\TDokumentTozsamosci
     */
    public function setRodzaj($rodzaj = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TRodzajDokumentuTozsamosci::valueIsValid($rodzaj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TRodzajDokumentuTozsamosci', is_array($rodzaj) ? implode(', ', $rodzaj) : var_export($rodzaj, true), implode(', ', \EnumType\TRodzajDokumentuTozsamosci::getValidValues())), __LINE__);
        }
        $this->Rodzaj = $rodzaj;
        return $this;
    }
}
