<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TDanePodmiotu StructType
 * Meta information extracted from the WSDL
 * - documentation: Podstawowe dane podmiotu
 * @subpackage Structs
 */
abstract class TDanePodmiotu extends AbstractStructBase
{
    /**
     * The AdresEmail
     * Meta information extracted from the WSDL
     * - documentation: Adres poczty elektronicznej podmiotu | Adres poczty elektronicznej
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: ([a-zA-Z0-9_\-\.]+)@([a-zA-Z0-9_\-\.]+)\.([a-zA-Z]{2,5})
     * @var string[]
     */
    public $AdresEmail;
    /**
     * The NIP
     * Meta information extracted from the WSDL
     * - documentation: Identyfikatorr NIP podmiotu | Identyfikator NIP
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [1-9]((\d[1-9])|([1-9]\d))\d{7}
     * @var string
     */
    public $NIP;
    /**
     * The Telefon
     * Meta information extracted from the WSDL
     * - documentation: Numer telefonu
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: (\+)?[0-9]{1,20}
     * @var string[]
     */
    public $Telefon;
    /**
     * The SkrytkaPocztowa
     * Meta information extracted from the WSDL
     * - documentation: Skrytka pocztowa podmiotu
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TSkrytkaPocztowa[]
     */
    public $SkrytkaPocztowa;
    /**
     * Constructor method for TDanePodmiotu
     * @uses TDanePodmiotu::setAdresEmail()
     * @uses TDanePodmiotu::setNIP()
     * @uses TDanePodmiotu::setTelefon()
     * @uses TDanePodmiotu::setSkrytkaPocztowa()
     * @param string[] $adresEmail
     * @param string $nIP
     * @param string[] $telefon
     * @param \StructType\TSkrytkaPocztowa[] $skrytkaPocztowa
     */
    public function __construct(array $adresEmail = array(), $nIP = null, array $telefon = array(), array $skrytkaPocztowa = array())
    {
        $this
            ->setAdresEmail($adresEmail)
            ->setNIP($nIP)
            ->setTelefon($telefon)
            ->setSkrytkaPocztowa($skrytkaPocztowa);
    }
    /**
     * Get AdresEmail value
     * @return string[]|null
     */
    public function getAdresEmail()
    {
        return $this->AdresEmail;
    }
    /**
     * This method is responsible for validating the values passed to the setAdresEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdresEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdresEmailForArrayConstraintsFromSetAdresEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tDanePodmiotuAdresEmailItem) {
            // validation for constraint: itemType
            if (!is_string($tDanePodmiotuAdresEmailItem)) {
                $invalidValues[] = is_object($tDanePodmiotuAdresEmailItem) ? get_class($tDanePodmiotuAdresEmailItem) : sprintf('%s(%s)', gettype($tDanePodmiotuAdresEmailItem), var_export($tDanePodmiotuAdresEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdresEmail property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdresEmail value
     * @throws \InvalidArgumentException
     * @param string[] $adresEmail
     * @return \StructType\TDanePodmiotu
     */
    public function setAdresEmail(array $adresEmail = array())
    {
        // validation for constraint: array
        if ('' !== ($adresEmailArrayErrorMessage = self::validateAdresEmailForArrayConstraintsFromSetAdresEmail($adresEmail))) {
            throw new \InvalidArgumentException($adresEmailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(([a-zA-Z0-9_\-\.]+)@([a-zA-Z0-9_\-\.]+)\.([a-zA-Z]{2,5}))
        if (!is_null($adresEmail) && !preg_match('/([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})/', $adresEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([a-zA-Z0-9_\-\.]+)@([a-zA-Z0-9_\-\.]+)\.([a-zA-Z]{2,5})', var_export($adresEmail, true)), __LINE__);
        }
        $this->AdresEmail = $adresEmail;
        return $this;
    }
    /**
     * Add item to AdresEmail value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TDanePodmiotu
     */
    public function addToAdresEmail($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AdresEmail property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: pattern(([a-zA-Z0-9_\-\.]+)@([a-zA-Z0-9_\-\.]+)\.([a-zA-Z]{2,5}))
        if (!preg_match('/([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([a-zA-Z0-9_\-\.]+)@([a-zA-Z0-9_\-\.]+)\.([a-zA-Z]{2,5})', var_export($item, true)), __LINE__);
        }
        $this->AdresEmail[] = $item;
        return $this;
    }
    /**
     * Get NIP value
     * @return string|null
     */
    public function getNIP()
    {
        return $this->NIP;
    }
    /**
     * Set NIP value
     * @param string $nIP
     * @return \StructType\TDanePodmiotu
     */
    public function setNIP($nIP = null)
    {
        // validation for constraint: string
        if (!is_null($nIP) && !is_string($nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nIP, true), gettype($nIP)), __LINE__);
        }
        // validation for constraint: pattern([1-9]((\d[1-9])|([1-9]\d))\d{7})
        if (!is_null($nIP) && !preg_match('/[1-9]((\\d[1-9])|([1-9]\\d))\\d{7}/', $nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]((\d[1-9])|([1-9]\d))\d{7}', var_export($nIP, true)), __LINE__);
        }
        $this->NIP = $nIP;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string[]|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * This method is responsible for validating the values passed to the setTelefon method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelefon method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelefonForArrayConstraintsFromSetTelefon(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tDanePodmiotuTelefonItem) {
            // validation for constraint: itemType
            if (!is_string($tDanePodmiotuTelefonItem)) {
                $invalidValues[] = is_object($tDanePodmiotuTelefonItem) ? get_class($tDanePodmiotuTelefonItem) : sprintf('%s(%s)', gettype($tDanePodmiotuTelefonItem), var_export($tDanePodmiotuTelefonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telefon property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telefon value
     * @throws \InvalidArgumentException
     * @param string[] $telefon
     * @return \StructType\TDanePodmiotu
     */
    public function setTelefon(array $telefon = array())
    {
        // validation for constraint: array
        if ('' !== ($telefonArrayErrorMessage = self::validateTelefonForArrayConstraintsFromSetTelefon($telefon))) {
            throw new \InvalidArgumentException($telefonArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern((\+)?[0-9]{1,20})
        if (!is_null($telefon) && !preg_match('/(\\+)?[0-9]{1,20}/', $telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (\+)?[0-9]{1,20}', var_export($telefon, true)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Add item to Telefon value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TDanePodmiotu
     */
    public function addToTelefon($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Telefon property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: pattern((\+)?[0-9]{1,20})
        if (!preg_match('/(\\+)?[0-9]{1,20}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (\+)?[0-9]{1,20}', var_export($item, true)), __LINE__);
        }
        $this->Telefon[] = $item;
        return $this;
    }
    /**
     * Get SkrytkaPocztowa value
     * @return \StructType\TSkrytkaPocztowa[]|null
     */
    public function getSkrytkaPocztowa()
    {
        return $this->SkrytkaPocztowa;
    }
    /**
     * This method is responsible for validating the values passed to the setSkrytkaPocztowa method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkrytkaPocztowa method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkrytkaPocztowaForArrayConstraintsFromSetSkrytkaPocztowa(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tDanePodmiotuSkrytkaPocztowaItem) {
            // validation for constraint: itemType
            if (!$tDanePodmiotuSkrytkaPocztowaItem instanceof \StructType\TSkrytkaPocztowa) {
                $invalidValues[] = is_object($tDanePodmiotuSkrytkaPocztowaItem) ? get_class($tDanePodmiotuSkrytkaPocztowaItem) : sprintf('%s(%s)', gettype($tDanePodmiotuSkrytkaPocztowaItem), var_export($tDanePodmiotuSkrytkaPocztowaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SkrytkaPocztowa property can only contain items of type \StructType\TSkrytkaPocztowa, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SkrytkaPocztowa value
     * @throws \InvalidArgumentException
     * @param \StructType\TSkrytkaPocztowa[] $skrytkaPocztowa
     * @return \StructType\TDanePodmiotu
     */
    public function setSkrytkaPocztowa(array $skrytkaPocztowa = array())
    {
        // validation for constraint: array
        if ('' !== ($skrytkaPocztowaArrayErrorMessage = self::validateSkrytkaPocztowaForArrayConstraintsFromSetSkrytkaPocztowa($skrytkaPocztowa))) {
            throw new \InvalidArgumentException($skrytkaPocztowaArrayErrorMessage, __LINE__);
        }
        $this->SkrytkaPocztowa = $skrytkaPocztowa;
        return $this;
    }
    /**
     * Add item to SkrytkaPocztowa value
     * @throws \InvalidArgumentException
     * @param \StructType\TSkrytkaPocztowa $item
     * @return \StructType\TDanePodmiotu
     */
    public function addToSkrytkaPocztowa(\StructType\TSkrytkaPocztowa $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TSkrytkaPocztowa) {
            throw new \InvalidArgumentException(sprintf('The SkrytkaPocztowa property can only contain items of type \StructType\TSkrytkaPocztowa, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SkrytkaPocztowa[] = $item;
        return $this;
    }
}
