<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAdresPolski StructType
 * Meta information extracted from the WSDL
 * - documentation: Informacje opisujące adres polski
 * @subpackage Structs
 */
class TAdresPolski extends AbstractStructBase
{
    /**
     * The Miejscowosc
     * Meta information extracted from the WSDL
     * - documentation: Nazwa miejscowości | Typ określający nazwę miejscowości
     * - base: xs:string
     * - maxLength: 90
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Miejscowosc;
    /**
     * The NrDomu
     * Meta information extracted from the WSDL
     * - documentation: Numer budynku
     * - base: xs:token
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $NrDomu;
    /**
     * The Gmina
     * Meta information extracted from the WSDL
     * - documentation: Nazwa gminy | Typ określający nazwę województwa, nazwę powiatu lub nazwę gminy
     * - base: xs:token
     * - maxLength: 36
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gmina;
    /**
     * The KodPocztowy
     * Meta information extracted from the WSDL
     * - documentation: Kod pocztowy polski | Kod pocztowy | Polski kod pocztowy
     * - base: adr:TKodPocztowy
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: \d{5}|(\d{2}\-\d{3})
     * @var string
     */
    public $KodPocztowy;
    /**
     * The NrLokalu
     * Meta information extracted from the WSDL
     * - documentation: Numer lokalu
     * - base: xs:token
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NrLokalu;
    /**
     * The Poczta
     * Meta information extracted from the WSDL
     * - documentation: Nazwa urzędu pocztowego
     * - base: xs:token
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Poczta;
    /**
     * The Powiat
     * Meta information extracted from the WSDL
     * - documentation: Powiat | Typ określający nazwę województwa, nazwę powiatu lub nazwę gminy
     * - base: xs:token
     * - maxLength: 36
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Powiat;
    /**
     * The Ulica
     * Meta information extracted from the WSDL
     * - documentation: Nazwa ulicy
     * - base: xs:token
     * - maxLength: 200
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ulica;
    /**
     * The Wojewodztwo
     * Meta information extracted from the WSDL
     * - documentation: Województwo | Typ określający nazwę województwa, nazwę powiatu lub nazwę gminy
     * - base: xs:token
     * - maxLength: 36
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Wojewodztwo;
    /**
     * Constructor method for TAdresPolski
     * @uses TAdresPolski::setMiejscowosc()
     * @uses TAdresPolski::setNrDomu()
     * @uses TAdresPolski::setGmina()
     * @uses TAdresPolski::setKodPocztowy()
     * @uses TAdresPolski::setNrLokalu()
     * @uses TAdresPolski::setPoczta()
     * @uses TAdresPolski::setPowiat()
     * @uses TAdresPolski::setUlica()
     * @uses TAdresPolski::setWojewodztwo()
     * @param string $miejscowosc
     * @param string $nrDomu
     * @param string $gmina
     * @param string $kodPocztowy
     * @param string $nrLokalu
     * @param string $poczta
     * @param string $powiat
     * @param string $ulica
     * @param string $wojewodztwo
     */
    public function __construct($miejscowosc = null, $nrDomu = null, $gmina = null, $kodPocztowy = null, $nrLokalu = null, $poczta = null, $powiat = null, $ulica = null, $wojewodztwo = null)
    {
        $this
            ->setMiejscowosc($miejscowosc)
            ->setNrDomu($nrDomu)
            ->setGmina($gmina)
            ->setKodPocztowy($kodPocztowy)
            ->setNrLokalu($nrLokalu)
            ->setPoczta($poczta)
            ->setPowiat($powiat)
            ->setUlica($ulica)
            ->setWojewodztwo($wojewodztwo);
    }
    /**
     * Get Miejscowosc value
     * @return string
     */
    public function getMiejscowosc()
    {
        return $this->Miejscowosc;
    }
    /**
     * Set Miejscowosc value
     * @param string $miejscowosc
     * @return \StructType\TAdresPolski
     */
    public function setMiejscowosc($miejscowosc = null)
    {
        // validation for constraint: string
        if (!is_null($miejscowosc) && !is_string($miejscowosc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($miejscowosc, true), gettype($miejscowosc)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen($miejscowosc)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($miejscowosc)), __LINE__);
        }
        $this->Miejscowosc = $miejscowosc;
        return $this;
    }
    /**
     * Get NrDomu value
     * @return string
     */
    public function getNrDomu()
    {
        return $this->NrDomu;
    }
    /**
     * Set NrDomu value
     * @param string $nrDomu
     * @return \StructType\TAdresPolski
     */
    public function setNrDomu($nrDomu = null)
    {
        // validation for constraint: string
        if (!is_null($nrDomu) && !is_string($nrDomu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrDomu, true), gettype($nrDomu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrDomu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrDomu)), __LINE__);
        }
        $this->NrDomu = $nrDomu;
        return $this;
    }
    /**
     * Get Gmina value
     * @return string|null
     */
    public function getGmina()
    {
        return $this->Gmina;
    }
    /**
     * Set Gmina value
     * @param string $gmina
     * @return \StructType\TAdresPolski
     */
    public function setGmina($gmina = null)
    {
        // validation for constraint: string
        if (!is_null($gmina) && !is_string($gmina)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gmina, true), gettype($gmina)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($gmina) && mb_strlen($gmina) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($gmina)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($gmina) && mb_strlen($gmina) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($gmina)), __LINE__);
        }
        $this->Gmina = $gmina;
        return $this;
    }
    /**
     * Get KodPocztowy value
     * @return string|null
     */
    public function getKodPocztowy()
    {
        return $this->KodPocztowy;
    }
    /**
     * Set KodPocztowy value
     * @param string $kodPocztowy
     * @return \StructType\TAdresPolski
     */
    public function setKodPocztowy($kodPocztowy = null)
    {
        // validation for constraint: string
        if (!is_null($kodPocztowy) && !is_string($kodPocztowy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodPocztowy, true), gettype($kodPocztowy)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($kodPocztowy) && mb_strlen($kodPocztowy) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($kodPocztowy)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kodPocztowy) && mb_strlen($kodPocztowy) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kodPocztowy)), __LINE__);
        }
        // validation for constraint: pattern(\d{5}|(\d{2}\-\d{3}))
        if (!is_null($kodPocztowy) && !preg_match('/\\d{5}|(\\d{2}\\-\\d{3})/', $kodPocztowy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{5}|(\d{2}\-\d{3})', var_export($kodPocztowy, true)), __LINE__);
        }
        $this->KodPocztowy = $kodPocztowy;
        return $this;
    }
    /**
     * Get NrLokalu value
     * @return string|null
     */
    public function getNrLokalu()
    {
        return $this->NrLokalu;
    }
    /**
     * Set NrLokalu value
     * @param string $nrLokalu
     * @return \StructType\TAdresPolski
     */
    public function setNrLokalu($nrLokalu = null)
    {
        // validation for constraint: string
        if (!is_null($nrLokalu) && !is_string($nrLokalu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrLokalu, true), gettype($nrLokalu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrLokalu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrLokalu)), __LINE__);
        }
        $this->NrLokalu = $nrLokalu;
        return $this;
    }
    /**
     * Get Poczta value
     * @return string|null
     */
    public function getPoczta()
    {
        return $this->Poczta;
    }
    /**
     * Set Poczta value
     * @param string $poczta
     * @return \StructType\TAdresPolski
     */
    public function setPoczta($poczta = null)
    {
        // validation for constraint: string
        if (!is_null($poczta) && !is_string($poczta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poczta, true), gettype($poczta)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($poczta) && mb_strlen($poczta) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($poczta)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($poczta) && mb_strlen($poczta) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($poczta)), __LINE__);
        }
        $this->Poczta = $poczta;
        return $this;
    }
    /**
     * Get Powiat value
     * @return string|null
     */
    public function getPowiat()
    {
        return $this->Powiat;
    }
    /**
     * Set Powiat value
     * @param string $powiat
     * @return \StructType\TAdresPolski
     */
    public function setPowiat($powiat = null)
    {
        // validation for constraint: string
        if (!is_null($powiat) && !is_string($powiat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($powiat, true), gettype($powiat)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($powiat) && mb_strlen($powiat) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($powiat)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($powiat) && mb_strlen($powiat) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($powiat)), __LINE__);
        }
        $this->Powiat = $powiat;
        return $this;
    }
    /**
     * Get Ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->Ulica;
    }
    /**
     * Set Ulica value
     * @param string $ulica
     * @return \StructType\TAdresPolski
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ulica) && mb_strlen($ulica) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($ulica)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ulica) && mb_strlen($ulica) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ulica)), __LINE__);
        }
        $this->Ulica = $ulica;
        return $this;
    }
    /**
     * Get Wojewodztwo value
     * @return string|null
     */
    public function getWojewodztwo()
    {
        return $this->Wojewodztwo;
    }
    /**
     * Set Wojewodztwo value
     * @param string $wojewodztwo
     * @return \StructType\TAdresPolski
     */
    public function setWojewodztwo($wojewodztwo = null)
    {
        // validation for constraint: string
        if (!is_null($wojewodztwo) && !is_string($wojewodztwo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wojewodztwo, true), gettype($wojewodztwo)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($wojewodztwo) && mb_strlen($wojewodztwo) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($wojewodztwo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wojewodztwo) && mb_strlen($wojewodztwo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wojewodztwo)), __LINE__);
        }
        $this->Wojewodztwo = $wojewodztwo;
        return $this;
    }
}
