<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAdres StructType
 * Meta information extracted from the WSDL
 * - documentation: Dane określające adres
 * @subpackage Structs
 */
class TAdres extends AbstractStructBase
{
    /**
     * The AdresZagraniczny
     * Meta information extracted from the WSDL
     * - documentation: Adres zagraniczny
     * - choice: AdresZagraniczny | AdresPolski
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TAdresZagraniczny
     */
    public $AdresZagraniczny;
    /**
     * The AdresPolski
     * Meta information extracted from the WSDL
     * - documentation: Adres polski
     * - choice: AdresZagraniczny | AdresPolski
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TAdresPolski
     */
    public $AdresPolski;
    /**
     * Constructor method for TAdres
     * @uses TAdres::setAdresZagraniczny()
     * @uses TAdres::setAdresPolski()
     * @param \StructType\TAdresZagraniczny $adresZagraniczny
     * @param \StructType\TAdresPolski $adresPolski
     */
    public function __construct(\StructType\TAdresZagraniczny $adresZagraniczny = null, \StructType\TAdresPolski $adresPolski = null)
    {
        $this
            ->setAdresZagraniczny($adresZagraniczny)
            ->setAdresPolski($adresPolski);
    }
    /**
     * Get AdresZagraniczny value
     * @return \StructType\TAdresZagraniczny
     */
    public function getAdresZagraniczny()
    {
        return isset($this->AdresZagraniczny) ? $this->AdresZagraniczny : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAdresZagraniczny method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdresZagraniczny method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAdresZagranicznyForChoiceConstraintsFromSetAdresZagraniczny($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AdresPolski',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AdresZagraniczny can\'t be set as the property %s is already set. Only one property must be set among these properties: AdresZagraniczny, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AdresZagraniczny value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TAdresZagraniczny $adresZagraniczny
     * @return \StructType\TAdres
     */
    public function setAdresZagraniczny(\StructType\TAdresZagraniczny $adresZagraniczny = null)
    {
        // validation for constraint: choice(AdresZagraniczny, AdresPolski)
        if ('' !== ($adresZagranicznyChoiceErrorMessage = self::validateAdresZagranicznyForChoiceConstraintsFromSetAdresZagraniczny($adresZagraniczny))) {
            throw new \InvalidArgumentException($adresZagranicznyChoiceErrorMessage, __LINE__);
        }
        if (is_null($adresZagraniczny) || (is_array($adresZagraniczny) && empty($adresZagraniczny))) {
            unset($this->AdresZagraniczny);
        } else {
            $this->AdresZagraniczny = $adresZagraniczny;
        }
        return $this;
    }
    /**
     * Get AdresPolski value
     * @return \StructType\TAdresPolski
     */
    public function getAdresPolski()
    {
        return isset($this->AdresPolski) ? $this->AdresPolski : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAdresPolski method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdresPolski method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAdresPolskiForChoiceConstraintsFromSetAdresPolski($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AdresZagraniczny',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AdresPolski can\'t be set as the property %s is already set. Only one property must be set among these properties: AdresPolski, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AdresPolski value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TAdresPolski $adresPolski
     * @return \StructType\TAdres
     */
    public function setAdresPolski(\StructType\TAdresPolski $adresPolski = null)
    {
        // validation for constraint: choice(AdresZagraniczny, AdresPolski)
        if ('' !== ($adresPolskiChoiceErrorMessage = self::validateAdresPolskiForChoiceConstraintsFromSetAdresPolski($adresPolski))) {
            throw new \InvalidArgumentException($adresPolskiChoiceErrorMessage, __LINE__);
        }
        if (is_null($adresPolski) || (is_array($adresPolski) && empty($adresPolski))) {
            unset($this->AdresPolski);
        } else {
            $this->AdresPolski = $adresPolski;
        }
        return $this;
    }
}
