<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpolkaIBeneficjenciGuiZgloszeniaTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Opisuje spółkę i beneficjentów rzeczywistych występujących w danym zgłoszeniu.
 * @subpackage Structs
 */
class SpolkaIBeneficjenciGuiZgloszeniaTyp extends AbstractStructBase
{
    /**
     * The DataICzasRejestracjiZgloszenia
     * Meta information extracted from the WSDL
     * - documentation: Data i czas przyjęcia dokumentu zgłoszenia do UBD.
     * @var string
     */
    public $DataICzasRejestracjiZgloszenia;
    /**
     * The NumerReferencyjny
     * Meta information extracted from the WSDL
     * - documentation: Numer referencyjny zgłoszenia nadany przez UBD .
     * @var string
     */
    public $NumerReferencyjny;
    /**
     * The DataZdarzenia
     * Meta information extracted from the WSDL
     * - documentation: Data zdarzenia zmieniającego którykolwiek z elementów zgłoszenia.
     * @var string
     */
    public $DataZdarzenia;
    /**
     * The Nazwa
     * Meta information extracted from the WSDL
     * - documentation: Pełna nazwa spółki.
     * - base: xs:string
     * - maxLength: 2000
     * - minLength: 1
     * @var string
     */
    public $Nazwa;
    /**
     * The NIP
     * Meta information extracted from the WSDL
     * - documentation: Numer NIP spółki. | Identyfikator NIP
     * - base: xs:string
     * - pattern: [1-9]((\d[1-9])|([1-9]\d))\d{7}
     * @var string
     */
    public $NIP;
    /**
     * The KRS
     * Meta information extracted from the WSDL
     * - documentation: Numer wpisu do KRS. | Numer Krajowego Rejestru Sądowego
     * - base: xs:token
     * - pattern: \d{10}
     * @var string
     */
    public $KRS;
    /**
     * The KodFormyOrganizacyjnej
     * Meta information extracted from the WSDL
     * - documentation: Kod formy organizacyjnej spółki.
     * @var string
     */
    public $KodFormyOrganizacyjnej;
    /**
     * The OpisFormyOrganizacyjnej
     * Meta information extracted from the WSDL
     * - documentation: Opis formy organizacyjnej spółki.
     * @var string
     */
    public $OpisFormyOrganizacyjnej;
    /**
     * The KodPocztowy
     * Meta information extracted from the WSDL
     * - documentation: Kod pocztowy miejscowości, w której mieści się siedziba spółki.
     * @var string
     */
    public $KodPocztowy;
    /**
     * The Miejscowosc
     * Meta information extracted from the WSDL
     * - documentation: Miejscowość, w której mieści się siedziba spółki. | Typ określający nazwę miejscowości
     * - base: xs:string
     * - maxLength: 90
     * - minLength: 1
     * @var string
     */
    public $Miejscowosc;
    /**
     * The Ulica
     * Meta information extracted from the WSDL
     * - documentation: Ulica, przy której znajduje się siedziba spółki (łącznie z nazwą rodzaju ulicy: ul., pl., al. itp.). | Nazwa ulicy
     * - base: xs:token
     * - maxLength: 200
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ulica;
    /**
     * The NrDomu
     * Meta information extracted from the WSDL
     * - documentation: Nr domu (posesji), pod którym mieści się siedziba spółki. | Numer budynku
     * - base: xs:token
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $NrDomu;
    /**
     * The NrLokalu
     * Meta information extracted from the WSDL
     * - documentation: Numer lokalu, w którym mieści się siedziba spółki. | Numer lokalu
     * - base: xs:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NrLokalu;
    /**
     * The ListaBeneficjentowRzeczywistych
     * Meta information extracted from the WSDL
     * - documentation: Lista beneficjentów rzeczywistych należących do spółki, dla której jest zarejestrowano zgłoszenie.
     * @var \StructType\ListaBeneficjentowRzeczywistychWymGuiZgloszeniaTyp
     */
    public $ListaBeneficjentowRzeczywistych;
    /**
     * Constructor method for SpolkaIBeneficjenciGuiZgloszeniaTyp
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setDataICzasRejestracjiZgloszenia()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setNumerReferencyjny()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setDataZdarzenia()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setNazwa()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setNIP()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setKRS()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setKodFormyOrganizacyjnej()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setOpisFormyOrganizacyjnej()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setKodPocztowy()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setMiejscowosc()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setUlica()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setNrDomu()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setNrLokalu()
     * @uses SpolkaIBeneficjenciGuiZgloszeniaTyp::setListaBeneficjentowRzeczywistych()
     * @param string $dataICzasRejestracjiZgloszenia
     * @param string $numerReferencyjny
     * @param string $dataZdarzenia
     * @param string $nazwa
     * @param string $nIP
     * @param string $kRS
     * @param string $kodFormyOrganizacyjnej
     * @param string $opisFormyOrganizacyjnej
     * @param string $kodPocztowy
     * @param string $miejscowosc
     * @param string $ulica
     * @param string $nrDomu
     * @param string $nrLokalu
     * @param \StructType\ListaBeneficjentowRzeczywistychWymGuiZgloszeniaTyp $listaBeneficjentowRzeczywistych
     */
    public function __construct($dataICzasRejestracjiZgloszenia = null, $numerReferencyjny = null, $dataZdarzenia = null, $nazwa = null, $nIP = null, $kRS = null, $kodFormyOrganizacyjnej = null, $opisFormyOrganizacyjnej = null, $kodPocztowy = null, $miejscowosc = null, $ulica = null, $nrDomu = null, $nrLokalu = null, \StructType\ListaBeneficjentowRzeczywistychWymGuiZgloszeniaTyp $listaBeneficjentowRzeczywistych = null)
    {
        $this
            ->setDataICzasRejestracjiZgloszenia($dataICzasRejestracjiZgloszenia)
            ->setNumerReferencyjny($numerReferencyjny)
            ->setDataZdarzenia($dataZdarzenia)
            ->setNazwa($nazwa)
            ->setNIP($nIP)
            ->setKRS($kRS)
            ->setKodFormyOrganizacyjnej($kodFormyOrganizacyjnej)
            ->setOpisFormyOrganizacyjnej($opisFormyOrganizacyjnej)
            ->setKodPocztowy($kodPocztowy)
            ->setMiejscowosc($miejscowosc)
            ->setUlica($ulica)
            ->setNrDomu($nrDomu)
            ->setNrLokalu($nrLokalu)
            ->setListaBeneficjentowRzeczywistych($listaBeneficjentowRzeczywistych);
    }
    /**
     * Get DataICzasRejestracjiZgloszenia value
     * @return string|null
     */
    public function getDataICzasRejestracjiZgloszenia()
    {
        return $this->DataICzasRejestracjiZgloszenia;
    }
    /**
     * Set DataICzasRejestracjiZgloszenia value
     * @param string $dataICzasRejestracjiZgloszenia
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setDataICzasRejestracjiZgloszenia($dataICzasRejestracjiZgloszenia = null)
    {
        // validation for constraint: string
        if (!is_null($dataICzasRejestracjiZgloszenia) && !is_string($dataICzasRejestracjiZgloszenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataICzasRejestracjiZgloszenia, true), gettype($dataICzasRejestracjiZgloszenia)), __LINE__);
        }
        $this->DataICzasRejestracjiZgloszenia = $dataICzasRejestracjiZgloszenia;
        return $this;
    }
    /**
     * Get NumerReferencyjny value
     * @return string|null
     */
    public function getNumerReferencyjny()
    {
        return $this->NumerReferencyjny;
    }
    /**
     * Set NumerReferencyjny value
     * @param string $numerReferencyjny
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setNumerReferencyjny($numerReferencyjny = null)
    {
        // validation for constraint: string
        if (!is_null($numerReferencyjny) && !is_string($numerReferencyjny)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerReferencyjny, true), gettype($numerReferencyjny)), __LINE__);
        }
        $this->NumerReferencyjny = $numerReferencyjny;
        return $this;
    }
    /**
     * Get DataZdarzenia value
     * @return string|null
     */
    public function getDataZdarzenia()
    {
        return $this->DataZdarzenia;
    }
    /**
     * Set DataZdarzenia value
     * @param string $dataZdarzenia
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setDataZdarzenia($dataZdarzenia = null)
    {
        // validation for constraint: string
        if (!is_null($dataZdarzenia) && !is_string($dataZdarzenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataZdarzenia, true), gettype($dataZdarzenia)), __LINE__);
        }
        $this->DataZdarzenia = $dataZdarzenia;
        return $this;
    }
    /**
     * Get Nazwa value
     * @return string|null
     */
    public function getNazwa()
    {
        return $this->Nazwa;
    }
    /**
     * Set Nazwa value
     * @param string $nazwa
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setNazwa($nazwa = null)
    {
        // validation for constraint: string
        if (!is_null($nazwa) && !is_string($nazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwa, true), gettype($nazwa)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($nazwa) && mb_strlen($nazwa) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($nazwa)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwa) && mb_strlen($nazwa) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwa)), __LINE__);
        }
        $this->Nazwa = $nazwa;
        return $this;
    }
    /**
     * Get NIP value
     * @return string|null
     */
    public function getNIP()
    {
        return $this->NIP;
    }
    /**
     * Set NIP value
     * @param string $nIP
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setNIP($nIP = null)
    {
        // validation for constraint: string
        if (!is_null($nIP) && !is_string($nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nIP, true), gettype($nIP)), __LINE__);
        }
        // validation for constraint: pattern([1-9]((\d[1-9])|([1-9]\d))\d{7})
        if (!is_null($nIP) && !preg_match('/[1-9]((\\d[1-9])|([1-9]\\d))\\d{7}/', $nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]((\d[1-9])|([1-9]\d))\d{7}', var_export($nIP, true)), __LINE__);
        }
        $this->NIP = $nIP;
        return $this;
    }
    /**
     * Get KRS value
     * @return string|null
     */
    public function getKRS()
    {
        return $this->KRS;
    }
    /**
     * Set KRS value
     * @param string $kRS
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setKRS($kRS = null)
    {
        // validation for constraint: string
        if (!is_null($kRS) && !is_string($kRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kRS, true), gettype($kRS)), __LINE__);
        }
        // validation for constraint: pattern(\d{10})
        if (!is_null($kRS) && !preg_match('/\\d{10}/', $kRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{10}', var_export($kRS, true)), __LINE__);
        }
        $this->KRS = $kRS;
        return $this;
    }
    /**
     * Get KodFormyOrganizacyjnej value
     * @return string|null
     */
    public function getKodFormyOrganizacyjnej()
    {
        return $this->KodFormyOrganizacyjnej;
    }
    /**
     * Set KodFormyOrganizacyjnej value
     * @param string $kodFormyOrganizacyjnej
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setKodFormyOrganizacyjnej($kodFormyOrganizacyjnej = null)
    {
        // validation for constraint: string
        if (!is_null($kodFormyOrganizacyjnej) && !is_string($kodFormyOrganizacyjnej)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodFormyOrganizacyjnej, true), gettype($kodFormyOrganizacyjnej)), __LINE__);
        }
        $this->KodFormyOrganizacyjnej = $kodFormyOrganizacyjnej;
        return $this;
    }
    /**
     * Get OpisFormyOrganizacyjnej value
     * @return string|null
     */
    public function getOpisFormyOrganizacyjnej()
    {
        return $this->OpisFormyOrganizacyjnej;
    }
    /**
     * Set OpisFormyOrganizacyjnej value
     * @param string $opisFormyOrganizacyjnej
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setOpisFormyOrganizacyjnej($opisFormyOrganizacyjnej = null)
    {
        // validation for constraint: string
        if (!is_null($opisFormyOrganizacyjnej) && !is_string($opisFormyOrganizacyjnej)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opisFormyOrganizacyjnej, true), gettype($opisFormyOrganizacyjnej)), __LINE__);
        }
        $this->OpisFormyOrganizacyjnej = $opisFormyOrganizacyjnej;
        return $this;
    }
    /**
     * Get KodPocztowy value
     * @return string|null
     */
    public function getKodPocztowy()
    {
        return $this->KodPocztowy;
    }
    /**
     * Set KodPocztowy value
     * @param string $kodPocztowy
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setKodPocztowy($kodPocztowy = null)
    {
        // validation for constraint: string
        if (!is_null($kodPocztowy) && !is_string($kodPocztowy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodPocztowy, true), gettype($kodPocztowy)), __LINE__);
        }
        $this->KodPocztowy = $kodPocztowy;
        return $this;
    }
    /**
     * Get Miejscowosc value
     * @return string|null
     */
    public function getMiejscowosc()
    {
        return $this->Miejscowosc;
    }
    /**
     * Set Miejscowosc value
     * @param string $miejscowosc
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setMiejscowosc($miejscowosc = null)
    {
        // validation for constraint: string
        if (!is_null($miejscowosc) && !is_string($miejscowosc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($miejscowosc, true), gettype($miejscowosc)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen($miejscowosc)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($miejscowosc)), __LINE__);
        }
        $this->Miejscowosc = $miejscowosc;
        return $this;
    }
    /**
     * Get Ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->Ulica;
    }
    /**
     * Set Ulica value
     * @param string $ulica
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ulica) && mb_strlen($ulica) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($ulica)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ulica) && mb_strlen($ulica) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ulica)), __LINE__);
        }
        $this->Ulica = $ulica;
        return $this;
    }
    /**
     * Get NrDomu value
     * @return string|null
     */
    public function getNrDomu()
    {
        return $this->NrDomu;
    }
    /**
     * Set NrDomu value
     * @param string $nrDomu
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setNrDomu($nrDomu = null)
    {
        // validation for constraint: string
        if (!is_null($nrDomu) && !is_string($nrDomu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrDomu, true), gettype($nrDomu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrDomu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrDomu)), __LINE__);
        }
        $this->NrDomu = $nrDomu;
        return $this;
    }
    /**
     * Get NrLokalu value
     * @return string|null
     */
    public function getNrLokalu()
    {
        return $this->NrLokalu;
    }
    /**
     * Set NrLokalu value
     * @param string $nrLokalu
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setNrLokalu($nrLokalu = null)
    {
        // validation for constraint: string
        if (!is_null($nrLokalu) && !is_string($nrLokalu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrLokalu, true), gettype($nrLokalu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrLokalu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrLokalu)), __LINE__);
        }
        $this->NrLokalu = $nrLokalu;
        return $this;
    }
    /**
     * Get ListaBeneficjentowRzeczywistych value
     * @return \StructType\ListaBeneficjentowRzeczywistychWymGuiZgloszeniaTyp|null
     */
    public function getListaBeneficjentowRzeczywistych()
    {
        return $this->ListaBeneficjentowRzeczywistych;
    }
    /**
     * Set ListaBeneficjentowRzeczywistych value
     * @param \StructType\ListaBeneficjentowRzeczywistychWymGuiZgloszeniaTyp $listaBeneficjentowRzeczywistych
     * @return \StructType\SpolkaIBeneficjenciGuiZgloszeniaTyp
     */
    public function setListaBeneficjentowRzeczywistych(\StructType\ListaBeneficjentowRzeczywistychWymGuiZgloszeniaTyp $listaBeneficjentowRzeczywistych = null)
    {
        $this->ListaBeneficjentowRzeczywistych = $listaBeneficjentowRzeczywistych;
        return $this;
    }
}
