<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpolkaIBeneficjenciApiZapytaniaTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Opisuje spółkę i beneficjentów rzeczywistych występujących w danym Zgłoszeniu.
 * @subpackage Structs
 */
class SpolkaIBeneficjenciApiZapytaniaTyp extends AbstractStructBase
{
    /**
     * The Nazwa
     * Meta information extracted from the WSDL
     * - documentation: Pełna nazwa spółki.
     * - base: xs:string
     * - maxLength: 2000
     * - minLength: 1
     * @var string
     */
    public $Nazwa;
    /**
     * The NIP
     * Meta information extracted from the WSDL
     * - documentation: Numer NIP spółki. | Identyfikator NIP
     * - base: xs:string
     * - pattern: [1-9]((\d[1-9])|([1-9]\d))\d{7}
     * @var string
     */
    public $NIP;
    /**
     * The KRS
     * Meta information extracted from the WSDL
     * - documentation: Numer wpisu do KRS. | Numer Krajowego Rejestru Sądowego
     * - base: xs:token
     * - pattern: \d{10}
     * @var string
     */
    public $KRS;
    /**
     * The KodFormyOrganizacyjnej
     * Meta information extracted from the WSDL
     * - documentation: Kod formy organizacyjnej spółki.
     * @var string
     */
    public $KodFormyOrganizacyjnej;
    /**
     * The OpisFormyOrganizacyjnej
     * Meta information extracted from the WSDL
     * - documentation: Opis formy organizacyjnej spółki.
     * @var string
     */
    public $OpisFormyOrganizacyjnej;
    /**
     * The KodPocztowy
     * Meta information extracted from the WSDL
     * - documentation: Kod pocztowy miejscowości, w której mieści się siedziba spółki.
     * @var string
     */
    public $KodPocztowy;
    /**
     * The Miejscowosc
     * Meta information extracted from the WSDL
     * - documentation: Miejscowość, w której mieści się siedziba spółki. | Typ określający nazwę miejscowości
     * - base: xs:string
     * - maxLength: 90
     * - minLength: 1
     * @var string
     */
    public $Miejscowosc;
    /**
     * The Ulica
     * Meta information extracted from the WSDL
     * - documentation: Ulica, przy której znajduje się siedziba spółki (łącznie z nazwą rodzaju ulicy: ul., pl., al. itp.). | Nazwa ulicy
     * - base: xs:token
     * - maxLength: 200
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ulica;
    /**
     * The NrDomu
     * Meta information extracted from the WSDL
     * - documentation: Nr domu (posesji), pod którym mieści się siedziba spółki. | Numer budynku
     * - base: xs:token
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $NrDomu;
    /**
     * The NrLokalu
     * Meta information extracted from the WSDL
     * - documentation: Numer lokalu, w którym mieści się siedziba spółki. | Numer lokalu
     * - base: xs:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NrLokalu;
    /**
     * The ListaBeneficjentowRzeczywistych
     * Meta information extracted from the WSDL
     * - documentation: Lista beneficjentów rzeczywistych należących do spółki, dla której jest zarejestrowano zgłoszenie.
     * - minOccurs: 0
     * @var \StructType\ListaBeneficjentowRzeczywistychWymApiZapytaniaTyp
     */
    public $ListaBeneficjentowRzeczywistych;
    /**
     * The ListaReprezentantow
     * Meta information extracted from the WSDL
     * - documentation: Lista osób reprezentujących spółkę.
     * - minOccurs: 0
     * @var \StructType\ListaReprezentantowTyp
     */
    public $ListaReprezentantow;
    /**
     * The DataPoczatkuPrezentacjiZgloszenia
     * Meta information extracted from the WSDL
     * - documentation: Data, od której prezentowane jest zgłoszenie.
     * - minOccurs: 0
     * @var string
     */
    public $DataPoczatkuPrezentacjiZgloszenia;
    /**
     * The DataKoncaPrezentacjiZgloszenia
     * Meta information extracted from the WSDL
     * - documentation: Data, do której prezentowane jest zgłoszenie.
     * - minOccurs: 0
     * @var string
     */
    public $DataKoncaPrezentacjiZgloszenia;
    /**
     * The Skorygowane
     * Meta information extracted from the WSDL
     * - documentation: Informacja o tym, czy i kiedy dane zgłoszenie było korygowane.
     * - minOccurs: 0
     * @var string
     */
    public $Skorygowane;
    /**
     * The NumerReferencyjny
     * Meta information extracted from the WSDL
     * - documentation: Numerr referencyjny zgłoszenia.
     * @var string
     */
    public $NumerReferencyjny;
    /**
     * The ListaInformacjiORozbieznosciach
     * Meta information extracted from the WSDL
     * - documentation: Lista informacji o rozbieżnościach.
     * - minOccurs: 0
     * @var \StructType\ListaInformacjiORozbieznosciachTyp
     */
    public $ListaInformacjiORozbieznosciach;
    /**
     * Constructor method for SpolkaIBeneficjenciApiZapytaniaTyp
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setNazwa()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setNIP()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setKRS()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setKodFormyOrganizacyjnej()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setOpisFormyOrganizacyjnej()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setKodPocztowy()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setMiejscowosc()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setUlica()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setNrDomu()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setNrLokalu()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setListaBeneficjentowRzeczywistych()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setListaReprezentantow()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setDataPoczatkuPrezentacjiZgloszenia()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setDataKoncaPrezentacjiZgloszenia()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setSkorygowane()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setNumerReferencyjny()
     * @uses SpolkaIBeneficjenciApiZapytaniaTyp::setListaInformacjiORozbieznosciach()
     * @param string $nazwa
     * @param string $nIP
     * @param string $kRS
     * @param string $kodFormyOrganizacyjnej
     * @param string $opisFormyOrganizacyjnej
     * @param string $kodPocztowy
     * @param string $miejscowosc
     * @param string $ulica
     * @param string $nrDomu
     * @param string $nrLokalu
     * @param \StructType\ListaBeneficjentowRzeczywistychWymApiZapytaniaTyp $listaBeneficjentowRzeczywistych
     * @param \StructType\ListaReprezentantowTyp $listaReprezentantow
     * @param string $dataPoczatkuPrezentacjiZgloszenia
     * @param string $dataKoncaPrezentacjiZgloszenia
     * @param string $skorygowane
     * @param string $numerReferencyjny
     * @param \StructType\ListaInformacjiORozbieznosciachTyp $listaInformacjiORozbieznosciach
     */
    public function __construct($nazwa = null, $nIP = null, $kRS = null, $kodFormyOrganizacyjnej = null, $opisFormyOrganizacyjnej = null, $kodPocztowy = null, $miejscowosc = null, $ulica = null, $nrDomu = null, $nrLokalu = null, \StructType\ListaBeneficjentowRzeczywistychWymApiZapytaniaTyp $listaBeneficjentowRzeczywistych = null, \StructType\ListaReprezentantowTyp $listaReprezentantow = null, $dataPoczatkuPrezentacjiZgloszenia = null, $dataKoncaPrezentacjiZgloszenia = null, $skorygowane = null, $numerReferencyjny = null, \StructType\ListaInformacjiORozbieznosciachTyp $listaInformacjiORozbieznosciach = null)
    {
        $this
            ->setNazwa($nazwa)
            ->setNIP($nIP)
            ->setKRS($kRS)
            ->setKodFormyOrganizacyjnej($kodFormyOrganizacyjnej)
            ->setOpisFormyOrganizacyjnej($opisFormyOrganizacyjnej)
            ->setKodPocztowy($kodPocztowy)
            ->setMiejscowosc($miejscowosc)
            ->setUlica($ulica)
            ->setNrDomu($nrDomu)
            ->setNrLokalu($nrLokalu)
            ->setListaBeneficjentowRzeczywistych($listaBeneficjentowRzeczywistych)
            ->setListaReprezentantow($listaReprezentantow)
            ->setDataPoczatkuPrezentacjiZgloszenia($dataPoczatkuPrezentacjiZgloszenia)
            ->setDataKoncaPrezentacjiZgloszenia($dataKoncaPrezentacjiZgloszenia)
            ->setSkorygowane($skorygowane)
            ->setNumerReferencyjny($numerReferencyjny)
            ->setListaInformacjiORozbieznosciach($listaInformacjiORozbieznosciach);
    }
    /**
     * Get Nazwa value
     * @return string|null
     */
    public function getNazwa()
    {
        return $this->Nazwa;
    }
    /**
     * Set Nazwa value
     * @param string $nazwa
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setNazwa($nazwa = null)
    {
        // validation for constraint: string
        if (!is_null($nazwa) && !is_string($nazwa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwa, true), gettype($nazwa)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($nazwa) && mb_strlen($nazwa) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($nazwa)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwa) && mb_strlen($nazwa) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwa)), __LINE__);
        }
        $this->Nazwa = $nazwa;
        return $this;
    }
    /**
     * Get NIP value
     * @return string|null
     */
    public function getNIP()
    {
        return $this->NIP;
    }
    /**
     * Set NIP value
     * @param string $nIP
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setNIP($nIP = null)
    {
        // validation for constraint: string
        if (!is_null($nIP) && !is_string($nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nIP, true), gettype($nIP)), __LINE__);
        }
        // validation for constraint: pattern([1-9]((\d[1-9])|([1-9]\d))\d{7})
        if (!is_null($nIP) && !preg_match('/[1-9]((\\d[1-9])|([1-9]\\d))\\d{7}/', $nIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [1-9]((\d[1-9])|([1-9]\d))\d{7}', var_export($nIP, true)), __LINE__);
        }
        $this->NIP = $nIP;
        return $this;
    }
    /**
     * Get KRS value
     * @return string|null
     */
    public function getKRS()
    {
        return $this->KRS;
    }
    /**
     * Set KRS value
     * @param string $kRS
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setKRS($kRS = null)
    {
        // validation for constraint: string
        if (!is_null($kRS) && !is_string($kRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kRS, true), gettype($kRS)), __LINE__);
        }
        // validation for constraint: pattern(\d{10})
        if (!is_null($kRS) && !preg_match('/\\d{10}/', $kRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{10}', var_export($kRS, true)), __LINE__);
        }
        $this->KRS = $kRS;
        return $this;
    }
    /**
     * Get KodFormyOrganizacyjnej value
     * @return string|null
     */
    public function getKodFormyOrganizacyjnej()
    {
        return $this->KodFormyOrganizacyjnej;
    }
    /**
     * Set KodFormyOrganizacyjnej value
     * @param string $kodFormyOrganizacyjnej
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setKodFormyOrganizacyjnej($kodFormyOrganizacyjnej = null)
    {
        // validation for constraint: string
        if (!is_null($kodFormyOrganizacyjnej) && !is_string($kodFormyOrganizacyjnej)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodFormyOrganizacyjnej, true), gettype($kodFormyOrganizacyjnej)), __LINE__);
        }
        $this->KodFormyOrganizacyjnej = $kodFormyOrganizacyjnej;
        return $this;
    }
    /**
     * Get OpisFormyOrganizacyjnej value
     * @return string|null
     */
    public function getOpisFormyOrganizacyjnej()
    {
        return $this->OpisFormyOrganizacyjnej;
    }
    /**
     * Set OpisFormyOrganizacyjnej value
     * @param string $opisFormyOrganizacyjnej
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setOpisFormyOrganizacyjnej($opisFormyOrganizacyjnej = null)
    {
        // validation for constraint: string
        if (!is_null($opisFormyOrganizacyjnej) && !is_string($opisFormyOrganizacyjnej)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opisFormyOrganizacyjnej, true), gettype($opisFormyOrganizacyjnej)), __LINE__);
        }
        $this->OpisFormyOrganizacyjnej = $opisFormyOrganizacyjnej;
        return $this;
    }
    /**
     * Get KodPocztowy value
     * @return string|null
     */
    public function getKodPocztowy()
    {
        return $this->KodPocztowy;
    }
    /**
     * Set KodPocztowy value
     * @param string $kodPocztowy
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setKodPocztowy($kodPocztowy = null)
    {
        // validation for constraint: string
        if (!is_null($kodPocztowy) && !is_string($kodPocztowy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodPocztowy, true), gettype($kodPocztowy)), __LINE__);
        }
        $this->KodPocztowy = $kodPocztowy;
        return $this;
    }
    /**
     * Get Miejscowosc value
     * @return string|null
     */
    public function getMiejscowosc()
    {
        return $this->Miejscowosc;
    }
    /**
     * Set Miejscowosc value
     * @param string $miejscowosc
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setMiejscowosc($miejscowosc = null)
    {
        // validation for constraint: string
        if (!is_null($miejscowosc) && !is_string($miejscowosc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($miejscowosc, true), gettype($miejscowosc)), __LINE__);
        }
        // validation for constraint: maxLength(90)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) > 90) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 90', mb_strlen($miejscowosc)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($miejscowosc) && mb_strlen($miejscowosc) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($miejscowosc)), __LINE__);
        }
        $this->Miejscowosc = $miejscowosc;
        return $this;
    }
    /**
     * Get Ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->Ulica;
    }
    /**
     * Set Ulica value
     * @param string $ulica
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($ulica) && mb_strlen($ulica) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($ulica)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ulica) && mb_strlen($ulica) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ulica)), __LINE__);
        }
        $this->Ulica = $ulica;
        return $this;
    }
    /**
     * Get NrDomu value
     * @return string|null
     */
    public function getNrDomu()
    {
        return $this->NrDomu;
    }
    /**
     * Set NrDomu value
     * @param string $nrDomu
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setNrDomu($nrDomu = null)
    {
        // validation for constraint: string
        if (!is_null($nrDomu) && !is_string($nrDomu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrDomu, true), gettype($nrDomu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrDomu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrDomu) && mb_strlen($nrDomu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrDomu)), __LINE__);
        }
        $this->NrDomu = $nrDomu;
        return $this;
    }
    /**
     * Get NrLokalu value
     * @return string|null
     */
    public function getNrLokalu()
    {
        return $this->NrLokalu;
    }
    /**
     * Set NrLokalu value
     * @param string $nrLokalu
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setNrLokalu($nrLokalu = null)
    {
        // validation for constraint: string
        if (!is_null($nrLokalu) && !is_string($nrLokalu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrLokalu, true), gettype($nrLokalu)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($nrLokalu)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nrLokalu) && mb_strlen($nrLokalu) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nrLokalu)), __LINE__);
        }
        $this->NrLokalu = $nrLokalu;
        return $this;
    }
    /**
     * Get ListaBeneficjentowRzeczywistych value
     * @return \StructType\ListaBeneficjentowRzeczywistychWymApiZapytaniaTyp|null
     */
    public function getListaBeneficjentowRzeczywistych()
    {
        return $this->ListaBeneficjentowRzeczywistych;
    }
    /**
     * Set ListaBeneficjentowRzeczywistych value
     * @param \StructType\ListaBeneficjentowRzeczywistychWymApiZapytaniaTyp $listaBeneficjentowRzeczywistych
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setListaBeneficjentowRzeczywistych(\StructType\ListaBeneficjentowRzeczywistychWymApiZapytaniaTyp $listaBeneficjentowRzeczywistych = null)
    {
        $this->ListaBeneficjentowRzeczywistych = $listaBeneficjentowRzeczywistych;
        return $this;
    }
    /**
     * Get ListaReprezentantow value
     * @return \StructType\ListaReprezentantowTyp|null
     */
    public function getListaReprezentantow()
    {
        return $this->ListaReprezentantow;
    }
    /**
     * Set ListaReprezentantow value
     * @param \StructType\ListaReprezentantowTyp $listaReprezentantow
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setListaReprezentantow(\StructType\ListaReprezentantowTyp $listaReprezentantow = null)
    {
        $this->ListaReprezentantow = $listaReprezentantow;
        return $this;
    }
    /**
     * Get DataPoczatkuPrezentacjiZgloszenia value
     * @return string|null
     */
    public function getDataPoczatkuPrezentacjiZgloszenia()
    {
        return $this->DataPoczatkuPrezentacjiZgloszenia;
    }
    /**
     * Set DataPoczatkuPrezentacjiZgloszenia value
     * @param string $dataPoczatkuPrezentacjiZgloszenia
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setDataPoczatkuPrezentacjiZgloszenia($dataPoczatkuPrezentacjiZgloszenia = null)
    {
        // validation for constraint: string
        if (!is_null($dataPoczatkuPrezentacjiZgloszenia) && !is_string($dataPoczatkuPrezentacjiZgloszenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPoczatkuPrezentacjiZgloszenia, true), gettype($dataPoczatkuPrezentacjiZgloszenia)), __LINE__);
        }
        $this->DataPoczatkuPrezentacjiZgloszenia = $dataPoczatkuPrezentacjiZgloszenia;
        return $this;
    }
    /**
     * Get DataKoncaPrezentacjiZgloszenia value
     * @return string|null
     */
    public function getDataKoncaPrezentacjiZgloszenia()
    {
        return $this->DataKoncaPrezentacjiZgloszenia;
    }
    /**
     * Set DataKoncaPrezentacjiZgloszenia value
     * @param string $dataKoncaPrezentacjiZgloszenia
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setDataKoncaPrezentacjiZgloszenia($dataKoncaPrezentacjiZgloszenia = null)
    {
        // validation for constraint: string
        if (!is_null($dataKoncaPrezentacjiZgloszenia) && !is_string($dataKoncaPrezentacjiZgloszenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataKoncaPrezentacjiZgloszenia, true), gettype($dataKoncaPrezentacjiZgloszenia)), __LINE__);
        }
        $this->DataKoncaPrezentacjiZgloszenia = $dataKoncaPrezentacjiZgloszenia;
        return $this;
    }
    /**
     * Get Skorygowane value
     * @return string|null
     */
    public function getSkorygowane()
    {
        return $this->Skorygowane;
    }
    /**
     * Set Skorygowane value
     * @param string $skorygowane
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setSkorygowane($skorygowane = null)
    {
        // validation for constraint: string
        if (!is_null($skorygowane) && !is_string($skorygowane)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skorygowane, true), gettype($skorygowane)), __LINE__);
        }
        $this->Skorygowane = $skorygowane;
        return $this;
    }
    /**
     * Get NumerReferencyjny value
     * @return string|null
     */
    public function getNumerReferencyjny()
    {
        return $this->NumerReferencyjny;
    }
    /**
     * Set NumerReferencyjny value
     * @param string $numerReferencyjny
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setNumerReferencyjny($numerReferencyjny = null)
    {
        // validation for constraint: string
        if (!is_null($numerReferencyjny) && !is_string($numerReferencyjny)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerReferencyjny, true), gettype($numerReferencyjny)), __LINE__);
        }
        $this->NumerReferencyjny = $numerReferencyjny;
        return $this;
    }
    /**
     * Get ListaInformacjiORozbieznosciach value
     * @return \StructType\ListaInformacjiORozbieznosciachTyp|null
     */
    public function getListaInformacjiORozbieznosciach()
    {
        return $this->ListaInformacjiORozbieznosciach;
    }
    /**
     * Set ListaInformacjiORozbieznosciach value
     * @param \StructType\ListaInformacjiORozbieznosciachTyp $listaInformacjiORozbieznosciach
     * @return \StructType\SpolkaIBeneficjenciApiZapytaniaTyp
     */
    public function setListaInformacjiORozbieznosciach(\StructType\ListaInformacjiORozbieznosciachTyp $listaInformacjiORozbieznosciach = null)
    {
        $this->ListaInformacjiORozbieznosciach = $listaInformacjiORozbieznosciach;
        return $this;
    }
}
