<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListaReprezentantowTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Lista osób reprezentujących spółkę.
 * @subpackage Structs
 */
class ListaReprezentantowTyp extends AbstractStructBase
{
    /**
     * The Reprezentant
     * Meta information extracted from the WSDL
     * - documentation: Osoba reprezentująca spółkę.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReprezentantTyp[]
     */
    public $Reprezentant;
    /**
     * Constructor method for ListaReprezentantowTyp
     * @uses ListaReprezentantowTyp::setReprezentant()
     * @param \StructType\ReprezentantTyp[] $reprezentant
     */
    public function __construct(array $reprezentant = array())
    {
        $this
            ->setReprezentant($reprezentant);
    }
    /**
     * Get Reprezentant value
     * @return \StructType\ReprezentantTyp[]|null
     */
    public function getReprezentant()
    {
        return $this->Reprezentant;
    }
    /**
     * This method is responsible for validating the values passed to the setReprezentant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReprezentant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReprezentantForArrayConstraintsFromSetReprezentant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaReprezentantowTypReprezentantItem) {
            // validation for constraint: itemType
            if (!$listaReprezentantowTypReprezentantItem instanceof \StructType\ReprezentantTyp) {
                $invalidValues[] = is_object($listaReprezentantowTypReprezentantItem) ? get_class($listaReprezentantowTypReprezentantItem) : sprintf('%s(%s)', gettype($listaReprezentantowTypReprezentantItem), var_export($listaReprezentantowTypReprezentantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Reprezentant property can only contain items of type \StructType\ReprezentantTyp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Reprezentant value
     * @throws \InvalidArgumentException
     * @param \StructType\ReprezentantTyp[] $reprezentant
     * @return \StructType\ListaReprezentantowTyp
     */
    public function setReprezentant(array $reprezentant = array())
    {
        // validation for constraint: array
        if ('' !== ($reprezentantArrayErrorMessage = self::validateReprezentantForArrayConstraintsFromSetReprezentant($reprezentant))) {
            throw new \InvalidArgumentException($reprezentantArrayErrorMessage, __LINE__);
        }
        $this->Reprezentant = $reprezentant;
        return $this;
    }
    /**
     * Add item to Reprezentant value
     * @throws \InvalidArgumentException
     * @param \StructType\ReprezentantTyp $item
     * @return \StructType\ListaReprezentantowTyp
     */
    public function addToReprezentant(\StructType\ReprezentantTyp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReprezentantTyp) {
            throw new \InvalidArgumentException(sprintf('The Reprezentant property can only contain items of type \StructType\ReprezentantTyp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Reprezentant[] = $item;
        return $this;
    }
}
