<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WlasnoscUdzialuTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Ilość i jednostki ilości dla wielkości udziałów.
 * @subpackage Structs
 */
class WlasnoscUdzialuTyp extends AbstractStructBase
{
    /**
     * The KodUprawnienWlascicielskich
     * Meta information extracted from the WSDL
     * - documentation: Kod rodzaju uprawnień właścicielskich.
     * @var string
     */
    public $KodUprawnienWlascicielskich;
    /**
     * The RodzajUprawnienWlascicielskich
     * Meta information extracted from the WSDL
     * - documentation: Rodzaj uprawnień właścicielskich.
     * @var string
     */
    public $RodzajUprawnienWlascicielskich;
    /**
     * The KodJednostkiMiary
     * Meta information extracted from the WSDL
     * - documentation: Kod jednostki miary udziału.
     * @var string
     */
    public $KodJednostkiMiary;
    /**
     * The JednostkaMiary
     * Meta information extracted from the WSDL
     * - documentation: Opis jednostki miary udziału.
     * @var string
     */
    public $JednostkaMiary;
    /**
     * The Ilosc
     * Meta information extracted from the WSDL
     * - documentation: Liczba określająca wielkość własności w jednostkach miary udziału.
     * @var float
     */
    public $Ilosc;
    /**
     * The InformacjaOUprzywilejowaniu
     * Meta information extracted from the WSDL
     * - documentation: Rodzaj i opis uprzywilejowania.
     * @var \StructType\InformacjaOUprzywilejowaniuTyp
     */
    public $InformacjaOUprzywilejowaniu;
    /**
     * Constructor method for WlasnoscUdzialuTyp
     * @uses WlasnoscUdzialuTyp::setKodUprawnienWlascicielskich()
     * @uses WlasnoscUdzialuTyp::setRodzajUprawnienWlascicielskich()
     * @uses WlasnoscUdzialuTyp::setKodJednostkiMiary()
     * @uses WlasnoscUdzialuTyp::setJednostkaMiary()
     * @uses WlasnoscUdzialuTyp::setIlosc()
     * @uses WlasnoscUdzialuTyp::setInformacjaOUprzywilejowaniu()
     * @param string $kodUprawnienWlascicielskich
     * @param string $rodzajUprawnienWlascicielskich
     * @param string $kodJednostkiMiary
     * @param string $jednostkaMiary
     * @param float $ilosc
     * @param \StructType\InformacjaOUprzywilejowaniuTyp $informacjaOUprzywilejowaniu
     */
    public function __construct($kodUprawnienWlascicielskich = null, $rodzajUprawnienWlascicielskich = null, $kodJednostkiMiary = null, $jednostkaMiary = null, $ilosc = null, \StructType\InformacjaOUprzywilejowaniuTyp $informacjaOUprzywilejowaniu = null)
    {
        $this
            ->setKodUprawnienWlascicielskich($kodUprawnienWlascicielskich)
            ->setRodzajUprawnienWlascicielskich($rodzajUprawnienWlascicielskich)
            ->setKodJednostkiMiary($kodJednostkiMiary)
            ->setJednostkaMiary($jednostkaMiary)
            ->setIlosc($ilosc)
            ->setInformacjaOUprzywilejowaniu($informacjaOUprzywilejowaniu);
    }
    /**
     * Get KodUprawnienWlascicielskich value
     * @return string|null
     */
    public function getKodUprawnienWlascicielskich()
    {
        return $this->KodUprawnienWlascicielskich;
    }
    /**
     * Set KodUprawnienWlascicielskich value
     * @param string $kodUprawnienWlascicielskich
     * @return \StructType\WlasnoscUdzialuTyp
     */
    public function setKodUprawnienWlascicielskich($kodUprawnienWlascicielskich = null)
    {
        // validation for constraint: string
        if (!is_null($kodUprawnienWlascicielskich) && !is_string($kodUprawnienWlascicielskich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodUprawnienWlascicielskich, true), gettype($kodUprawnienWlascicielskich)), __LINE__);
        }
        $this->KodUprawnienWlascicielskich = $kodUprawnienWlascicielskich;
        return $this;
    }
    /**
     * Get RodzajUprawnienWlascicielskich value
     * @return string|null
     */
    public function getRodzajUprawnienWlascicielskich()
    {
        return $this->RodzajUprawnienWlascicielskich;
    }
    /**
     * Set RodzajUprawnienWlascicielskich value
     * @param string $rodzajUprawnienWlascicielskich
     * @return \StructType\WlasnoscUdzialuTyp
     */
    public function setRodzajUprawnienWlascicielskich($rodzajUprawnienWlascicielskich = null)
    {
        // validation for constraint: string
        if (!is_null($rodzajUprawnienWlascicielskich) && !is_string($rodzajUprawnienWlascicielskich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rodzajUprawnienWlascicielskich, true), gettype($rodzajUprawnienWlascicielskich)), __LINE__);
        }
        $this->RodzajUprawnienWlascicielskich = $rodzajUprawnienWlascicielskich;
        return $this;
    }
    /**
     * Get KodJednostkiMiary value
     * @return string|null
     */
    public function getKodJednostkiMiary()
    {
        return $this->KodJednostkiMiary;
    }
    /**
     * Set KodJednostkiMiary value
     * @param string $kodJednostkiMiary
     * @return \StructType\WlasnoscUdzialuTyp
     */
    public function setKodJednostkiMiary($kodJednostkiMiary = null)
    {
        // validation for constraint: string
        if (!is_null($kodJednostkiMiary) && !is_string($kodJednostkiMiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodJednostkiMiary, true), gettype($kodJednostkiMiary)), __LINE__);
        }
        $this->KodJednostkiMiary = $kodJednostkiMiary;
        return $this;
    }
    /**
     * Get JednostkaMiary value
     * @return string|null
     */
    public function getJednostkaMiary()
    {
        return $this->JednostkaMiary;
    }
    /**
     * Set JednostkaMiary value
     * @param string $jednostkaMiary
     * @return \StructType\WlasnoscUdzialuTyp
     */
    public function setJednostkaMiary($jednostkaMiary = null)
    {
        // validation for constraint: string
        if (!is_null($jednostkaMiary) && !is_string($jednostkaMiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jednostkaMiary, true), gettype($jednostkaMiary)), __LINE__);
        }
        $this->JednostkaMiary = $jednostkaMiary;
        return $this;
    }
    /**
     * Get Ilosc value
     * @return float|null
     */
    public function getIlosc()
    {
        return $this->Ilosc;
    }
    /**
     * Set Ilosc value
     * @param float $ilosc
     * @return \StructType\WlasnoscUdzialuTyp
     */
    public function setIlosc($ilosc = null)
    {
        // validation for constraint: float
        if (!is_null($ilosc) && !(is_float($ilosc) || is_numeric($ilosc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ilosc, true), gettype($ilosc)), __LINE__);
        }
        $this->Ilosc = $ilosc;
        return $this;
    }
    /**
     * Get InformacjaOUprzywilejowaniu value
     * @return \StructType\InformacjaOUprzywilejowaniuTyp|null
     */
    public function getInformacjaOUprzywilejowaniu()
    {
        return $this->InformacjaOUprzywilejowaniu;
    }
    /**
     * Set InformacjaOUprzywilejowaniu value
     * @param \StructType\InformacjaOUprzywilejowaniuTyp $informacjaOUprzywilejowaniu
     * @return \StructType\WlasnoscUdzialuTyp
     */
    public function setInformacjaOUprzywilejowaniu(\StructType\InformacjaOUprzywilejowaniuTyp $informacjaOUprzywilejowaniu = null)
    {
        $this->InformacjaOUprzywilejowaniu = $informacjaOUprzywilejowaniu;
        return $this;
    }
}
