<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TPodmiot StructType
 * Meta information extracted from the WSDL
 * - documentation: Podstawowe dane podmiotu
 * @subpackage Structs
 */
class TPodmiot extends AbstractStructBase
{
    /**
     * The Organizacja
     * Meta information extracted from the WSDL
     * - documentation: Podmiot będący organizacją
     * - choice: Organizacja | OsobaFizyczna
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TOrganizacja
     */
    public $Organizacja;
    /**
     * The OsobaFizyczna
     * Meta information extracted from the WSDL
     * - documentation: Podmiot będący osobą fizyczną
     * - choice: Organizacja | OsobaFizyczna
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TOsobaFizyczna
     */
    public $OsobaFizyczna;
    /**
     * Constructor method for TPodmiot
     * @uses TPodmiot::setOrganizacja()
     * @uses TPodmiot::setOsobaFizyczna()
     * @param \StructType\TOrganizacja $organizacja
     * @param \StructType\TOsobaFizyczna $osobaFizyczna
     */
    public function __construct(\StructType\TOrganizacja $organizacja = null, \StructType\TOsobaFizyczna $osobaFizyczna = null)
    {
        $this
            ->setOrganizacja($organizacja)
            ->setOsobaFizyczna($osobaFizyczna);
    }
    /**
     * Get Organizacja value
     * @return \StructType\TOrganizacja
     */
    public function getOrganizacja()
    {
        return isset($this->Organizacja) ? $this->Organizacja : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrganizacja method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganizacja method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrganizacjaForChoiceConstraintsFromSetOrganizacja($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OsobaFizyczna',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Organizacja can\'t be set as the property %s is already set. Only one property must be set among these properties: Organizacja, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Organizacja value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TOrganizacja $organizacja
     * @return \StructType\TPodmiot
     */
    public function setOrganizacja(\StructType\TOrganizacja $organizacja = null)
    {
        // validation for constraint: choice(Organizacja, OsobaFizyczna)
        if ('' !== ($organizacjaChoiceErrorMessage = self::validateOrganizacjaForChoiceConstraintsFromSetOrganizacja($organizacja))) {
            throw new \InvalidArgumentException($organizacjaChoiceErrorMessage, __LINE__);
        }
        if (is_null($organizacja) || (is_array($organizacja) && empty($organizacja))) {
            unset($this->Organizacja);
        } else {
            $this->Organizacja = $organizacja;
        }
        return $this;
    }
    /**
     * Get OsobaFizyczna value
     * @return \StructType\TOsobaFizyczna
     */
    public function getOsobaFizyczna()
    {
        return isset($this->OsobaFizyczna) ? $this->OsobaFizyczna : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOsobaFizyczna method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOsobaFizyczna method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOsobaFizycznaForChoiceConstraintsFromSetOsobaFizyczna($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Organizacja',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OsobaFizyczna can\'t be set as the property %s is already set. Only one property must be set among these properties: OsobaFizyczna, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OsobaFizyczna value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TOsobaFizyczna $osobaFizyczna
     * @return \StructType\TPodmiot
     */
    public function setOsobaFizyczna(\StructType\TOsobaFizyczna $osobaFizyczna = null)
    {
        // validation for constraint: choice(Organizacja, OsobaFizyczna)
        if ('' !== ($osobaFizycznaChoiceErrorMessage = self::validateOsobaFizycznaForChoiceConstraintsFromSetOsobaFizyczna($osobaFizyczna))) {
            throw new \InvalidArgumentException($osobaFizycznaChoiceErrorMessage, __LINE__);
        }
        if (is_null($osobaFizyczna) || (is_array($osobaFizyczna) && empty($osobaFizyczna))) {
            unset($this->OsobaFizyczna);
        } else {
            $this->OsobaFizyczna = $osobaFizyczna;
        }
        return $this;
    }
}
