<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TOsobaFizyczna StructType
 * Meta information extracted from the WSDL
 * - documentation: Dane osoby fizycznej
 * @subpackage Structs
 */
class TOsobaFizyczna extends TDanePodmiotu
{
    /**
     * The DataUrodzenia
     * Meta information extracted from the WSDL
     * - documentation: Data urodzenia | Typ daty
     * - base: xs:date
     * - maxOccurs: 1
     * - minInclusive: 1900-01-01
     * - minOccurs: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $DataUrodzenia;
    /**
     * The Imie
     * Meta information extracted from the WSDL
     * - documentation: Imię
     * - base: xs:token
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Imie;
    /**
     * The Nazwisko
     * Meta information extracted from the WSDL
     * - documentation: Nazwisko
     * - base: xs:token
     * - maxLength: 300
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Nazwisko;
    /**
     * The Plec
     * Meta information extracted from the WSDL
     * - documentation: Płeć
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Plec;
    /**
     * The ImieDrugie
     * Meta information extracted from the WSDL
     * - documentation: Drugie imię | Imię
     * - base: xs:token
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImieDrugie;
    /**
     * The ImieMatki
     * Meta information extracted from the WSDL
     * - documentation: Imię matki | Imię
     * - base: xs:token
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImieMatki;
    /**
     * The ImieOjca
     * Meta information extracted from the WSDL
     * - documentation: Imię ojca | Imię
     * - base: xs:token
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImieOjca;
    /**
     * The MiejsceUrodzenia
     * Meta information extracted from the WSDL
     * - documentation: Miejsce urodzenia
     * - base: xs:string
     * - maxLength: 112
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiejsceUrodzenia;
    /**
     * The NazwiskoRodowe
     * Meta information extracted from the WSDL
     * - documentation: Nazwisko rodowe | Nazwisko
     * - base: xs:token
     * - maxLength: 300
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NazwiskoRodowe;
    /**
     * The Obywatelstwo
     * Meta information extracted from the WSDL
     * - documentation: Obywatelstwo | Kod kraju
     * - base: xs:string
     * - length: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z][A-Z]
     * @var string
     */
    public $Obywatelstwo;
    /**
     * The PESEL
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator w rejestrze PESEL | Numer w rejestrze PESEL
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{11}
     * @var string
     */
    public $PESEL;
    /**
     * The AdresZamieszkania
     * Meta information extracted from the WSDL
     * - documentation: Adres zamieszkania osoby
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TAdres
     */
    public $AdresZamieszkania;
    /**
     * The DokumentTozsamosci
     * Meta information extracted from the WSDL
     * - documentation: Dokument tożsamości osoby
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TDokumentTozsamosci[]
     */
    public $DokumentTozsamosci;
    /**
     * The DzialalnoscGospodarcza
     * Meta information extracted from the WSDL
     * - documentation: Działalność gosopodarcza prowadzona przez osobę fizyczną
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TDzialanoscGospodarcza
     */
    public $DzialalnoscGospodarcza;
    /**
     * Constructor method for TOsobaFizyczna
     * @uses TOsobaFizyczna::setDataUrodzenia()
     * @uses TOsobaFizyczna::setImie()
     * @uses TOsobaFizyczna::setNazwisko()
     * @uses TOsobaFizyczna::setPlec()
     * @uses TOsobaFizyczna::setImieDrugie()
     * @uses TOsobaFizyczna::setImieMatki()
     * @uses TOsobaFizyczna::setImieOjca()
     * @uses TOsobaFizyczna::setMiejsceUrodzenia()
     * @uses TOsobaFizyczna::setNazwiskoRodowe()
     * @uses TOsobaFizyczna::setObywatelstwo()
     * @uses TOsobaFizyczna::setPESEL()
     * @uses TOsobaFizyczna::setAdresZamieszkania()
     * @uses TOsobaFizyczna::setDokumentTozsamosci()
     * @uses TOsobaFizyczna::setDzialalnoscGospodarcza()
     * @param string $dataUrodzenia
     * @param string $imie
     * @param string $nazwisko
     * @param string $plec
     * @param string $imieDrugie
     * @param string $imieMatki
     * @param string $imieOjca
     * @param string $miejsceUrodzenia
     * @param string $nazwiskoRodowe
     * @param string $obywatelstwo
     * @param string $pESEL
     * @param \StructType\TAdres $adresZamieszkania
     * @param \StructType\TDokumentTozsamosci[] $dokumentTozsamosci
     * @param \StructType\TDzialanoscGospodarcza $dzialalnoscGospodarcza
     */
    public function __construct($dataUrodzenia = null, $imie = null, $nazwisko = null, $plec = null, $imieDrugie = null, $imieMatki = null, $imieOjca = null, $miejsceUrodzenia = null, $nazwiskoRodowe = null, $obywatelstwo = null, $pESEL = null, \StructType\TAdres $adresZamieszkania = null, array $dokumentTozsamosci = array(), \StructType\TDzialanoscGospodarcza $dzialalnoscGospodarcza = null)
    {
        $this
            ->setDataUrodzenia($dataUrodzenia)
            ->setImie($imie)
            ->setNazwisko($nazwisko)
            ->setPlec($plec)
            ->setImieDrugie($imieDrugie)
            ->setImieMatki($imieMatki)
            ->setImieOjca($imieOjca)
            ->setMiejsceUrodzenia($miejsceUrodzenia)
            ->setNazwiskoRodowe($nazwiskoRodowe)
            ->setObywatelstwo($obywatelstwo)
            ->setPESEL($pESEL)
            ->setAdresZamieszkania($adresZamieszkania)
            ->setDokumentTozsamosci($dokumentTozsamosci)
            ->setDzialalnoscGospodarcza($dzialalnoscGospodarcza);
    }
    /**
     * Get DataUrodzenia value
     * @return string
     */
    public function getDataUrodzenia()
    {
        return $this->DataUrodzenia;
    }
    /**
     * Set DataUrodzenia value
     * @param string $dataUrodzenia
     * @return \StructType\TOsobaFizyczna
     */
    public function setDataUrodzenia($dataUrodzenia = null)
    {
        // validation for constraint: string
        if (!is_null($dataUrodzenia) && !is_string($dataUrodzenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataUrodzenia, true), gettype($dataUrodzenia)), __LINE__);
        }
        // validation for constraint: minInclusive(1900-01-01)
        if (!is_null($dataUrodzenia) && false !== mb_strpos($dataUrodzenia, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $dataUrodzenia)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', '900-01-01')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to 1900-01-01', var_export($dataUrodzenia, true)), __LINE__);
        }
        $this->DataUrodzenia = $dataUrodzenia;
        return $this;
    }
    /**
     * Get Imie value
     * @return string
     */
    public function getImie()
    {
        return $this->Imie;
    }
    /**
     * Set Imie value
     * @param string $imie
     * @return \StructType\TOsobaFizyczna
     */
    public function setImie($imie = null)
    {
        // validation for constraint: string
        if (!is_null($imie) && !is_string($imie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imie, true), gettype($imie)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($imie) && mb_strlen($imie) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($imie)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($imie) && mb_strlen($imie) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($imie)), __LINE__);
        }
        $this->Imie = $imie;
        return $this;
    }
    /**
     * Get Nazwisko value
     * @return string
     */
    public function getNazwisko()
    {
        return $this->Nazwisko;
    }
    /**
     * Set Nazwisko value
     * @param string $nazwisko
     * @return \StructType\TOsobaFizyczna
     */
    public function setNazwisko($nazwisko = null)
    {
        // validation for constraint: string
        if (!is_null($nazwisko) && !is_string($nazwisko)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwisko, true), gettype($nazwisko)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($nazwisko) && mb_strlen($nazwisko) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($nazwisko)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwisko) && mb_strlen($nazwisko) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwisko)), __LINE__);
        }
        $this->Nazwisko = $nazwisko;
        return $this;
    }
    /**
     * Get Plec value
     * @return string
     */
    public function getPlec()
    {
        return $this->Plec;
    }
    /**
     * Set Plec value
     * @uses \EnumType\TPlec::valueIsValid()
     * @uses \EnumType\TPlec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $plec
     * @return \StructType\TOsobaFizyczna
     */
    public function setPlec($plec = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TPlec::valueIsValid($plec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TPlec', is_array($plec) ? implode(', ', $plec) : var_export($plec, true), implode(', ', \EnumType\TPlec::getValidValues())), __LINE__);
        }
        $this->Plec = $plec;
        return $this;
    }
    /**
     * Get ImieDrugie value
     * @return string|null
     */
    public function getImieDrugie()
    {
        return $this->ImieDrugie;
    }
    /**
     * Set ImieDrugie value
     * @param string $imieDrugie
     * @return \StructType\TOsobaFizyczna
     */
    public function setImieDrugie($imieDrugie = null)
    {
        // validation for constraint: string
        if (!is_null($imieDrugie) && !is_string($imieDrugie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imieDrugie, true), gettype($imieDrugie)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($imieDrugie) && mb_strlen($imieDrugie) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($imieDrugie)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($imieDrugie) && mb_strlen($imieDrugie) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($imieDrugie)), __LINE__);
        }
        $this->ImieDrugie = $imieDrugie;
        return $this;
    }
    /**
     * Get ImieMatki value
     * @return string|null
     */
    public function getImieMatki()
    {
        return $this->ImieMatki;
    }
    /**
     * Set ImieMatki value
     * @param string $imieMatki
     * @return \StructType\TOsobaFizyczna
     */
    public function setImieMatki($imieMatki = null)
    {
        // validation for constraint: string
        if (!is_null($imieMatki) && !is_string($imieMatki)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imieMatki, true), gettype($imieMatki)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($imieMatki) && mb_strlen($imieMatki) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($imieMatki)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($imieMatki) && mb_strlen($imieMatki) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($imieMatki)), __LINE__);
        }
        $this->ImieMatki = $imieMatki;
        return $this;
    }
    /**
     * Get ImieOjca value
     * @return string|null
     */
    public function getImieOjca()
    {
        return $this->ImieOjca;
    }
    /**
     * Set ImieOjca value
     * @param string $imieOjca
     * @return \StructType\TOsobaFizyczna
     */
    public function setImieOjca($imieOjca = null)
    {
        // validation for constraint: string
        if (!is_null($imieOjca) && !is_string($imieOjca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imieOjca, true), gettype($imieOjca)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($imieOjca) && mb_strlen($imieOjca) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($imieOjca)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($imieOjca) && mb_strlen($imieOjca) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($imieOjca)), __LINE__);
        }
        $this->ImieOjca = $imieOjca;
        return $this;
    }
    /**
     * Get MiejsceUrodzenia value
     * @return string|null
     */
    public function getMiejsceUrodzenia()
    {
        return $this->MiejsceUrodzenia;
    }
    /**
     * Set MiejsceUrodzenia value
     * @param string $miejsceUrodzenia
     * @return \StructType\TOsobaFizyczna
     */
    public function setMiejsceUrodzenia($miejsceUrodzenia = null)
    {
        // validation for constraint: string
        if (!is_null($miejsceUrodzenia) && !is_string($miejsceUrodzenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($miejsceUrodzenia, true), gettype($miejsceUrodzenia)), __LINE__);
        }
        // validation for constraint: maxLength(112)
        if (!is_null($miejsceUrodzenia) && mb_strlen($miejsceUrodzenia) > 112) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 112', mb_strlen($miejsceUrodzenia)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($miejsceUrodzenia) && mb_strlen($miejsceUrodzenia) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($miejsceUrodzenia)), __LINE__);
        }
        $this->MiejsceUrodzenia = $miejsceUrodzenia;
        return $this;
    }
    /**
     * Get NazwiskoRodowe value
     * @return string|null
     */
    public function getNazwiskoRodowe()
    {
        return $this->NazwiskoRodowe;
    }
    /**
     * Set NazwiskoRodowe value
     * @param string $nazwiskoRodowe
     * @return \StructType\TOsobaFizyczna
     */
    public function setNazwiskoRodowe($nazwiskoRodowe = null)
    {
        // validation for constraint: string
        if (!is_null($nazwiskoRodowe) && !is_string($nazwiskoRodowe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwiskoRodowe, true), gettype($nazwiskoRodowe)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($nazwiskoRodowe) && mb_strlen($nazwiskoRodowe) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($nazwiskoRodowe)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nazwiskoRodowe) && mb_strlen($nazwiskoRodowe) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nazwiskoRodowe)), __LINE__);
        }
        $this->NazwiskoRodowe = $nazwiskoRodowe;
        return $this;
    }
    /**
     * Get Obywatelstwo value
     * @return string|null
     */
    public function getObywatelstwo()
    {
        return $this->Obywatelstwo;
    }
    /**
     * Set Obywatelstwo value
     * @param string $obywatelstwo
     * @return \StructType\TOsobaFizyczna
     */
    public function setObywatelstwo($obywatelstwo = null)
    {
        // validation for constraint: string
        if (!is_null($obywatelstwo) && !is_string($obywatelstwo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obywatelstwo, true), gettype($obywatelstwo)), __LINE__);
        }
        // validation for constraint: length(2)
        if (!is_null($obywatelstwo) && mb_strlen($obywatelstwo) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 2', mb_strlen($obywatelstwo)), __LINE__);
        }
        // validation for constraint: pattern([A-Z][A-Z])
        if (!is_null($obywatelstwo) && !preg_match('/[A-Z][A-Z]/', $obywatelstwo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z][A-Z]', var_export($obywatelstwo, true)), __LINE__);
        }
        $this->Obywatelstwo = $obywatelstwo;
        return $this;
    }
    /**
     * Get PESEL value
     * @return string|null
     */
    public function getPESEL()
    {
        return $this->PESEL;
    }
    /**
     * Set PESEL value
     * @param string $pESEL
     * @return \StructType\TOsobaFizyczna
     */
    public function setPESEL($pESEL = null)
    {
        // validation for constraint: string
        if (!is_null($pESEL) && !is_string($pESEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pESEL, true), gettype($pESEL)), __LINE__);
        }
        // validation for constraint: pattern(\d{11})
        if (!is_null($pESEL) && !preg_match('/\\d{11}/', $pESEL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{11}', var_export($pESEL, true)), __LINE__);
        }
        $this->PESEL = $pESEL;
        return $this;
    }
    /**
     * Get AdresZamieszkania value
     * @return \StructType\TAdres|null
     */
    public function getAdresZamieszkania()
    {
        return $this->AdresZamieszkania;
    }
    /**
     * Set AdresZamieszkania value
     * @param \StructType\TAdres $adresZamieszkania
     * @return \StructType\TOsobaFizyczna
     */
    public function setAdresZamieszkania(\StructType\TAdres $adresZamieszkania = null)
    {
        $this->AdresZamieszkania = $adresZamieszkania;
        return $this;
    }
    /**
     * Get DokumentTozsamosci value
     * @return \StructType\TDokumentTozsamosci[]|null
     */
    public function getDokumentTozsamosci()
    {
        return $this->DokumentTozsamosci;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentTozsamosci method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentTozsamosci method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentTozsamosciForArrayConstraintsFromSetDokumentTozsamosci(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tOsobaFizycznaDokumentTozsamosciItem) {
            // validation for constraint: itemType
            if (!$tOsobaFizycznaDokumentTozsamosciItem instanceof \StructType\TDokumentTozsamosci) {
                $invalidValues[] = is_object($tOsobaFizycznaDokumentTozsamosciItem) ? get_class($tOsobaFizycznaDokumentTozsamosciItem) : sprintf('%s(%s)', gettype($tOsobaFizycznaDokumentTozsamosciItem), var_export($tOsobaFizycznaDokumentTozsamosciItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DokumentTozsamosci property can only contain items of type \StructType\TDokumentTozsamosci, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DokumentTozsamosci value
     * @throws \InvalidArgumentException
     * @param \StructType\TDokumentTozsamosci[] $dokumentTozsamosci
     * @return \StructType\TOsobaFizyczna
     */
    public function setDokumentTozsamosci(array $dokumentTozsamosci = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentTozsamosciArrayErrorMessage = self::validateDokumentTozsamosciForArrayConstraintsFromSetDokumentTozsamosci($dokumentTozsamosci))) {
            throw new \InvalidArgumentException($dokumentTozsamosciArrayErrorMessage, __LINE__);
        }
        $this->DokumentTozsamosci = $dokumentTozsamosci;
        return $this;
    }
    /**
     * Add item to DokumentTozsamosci value
     * @throws \InvalidArgumentException
     * @param \StructType\TDokumentTozsamosci $item
     * @return \StructType\TOsobaFizyczna
     */
    public function addToDokumentTozsamosci(\StructType\TDokumentTozsamosci $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TDokumentTozsamosci) {
            throw new \InvalidArgumentException(sprintf('The DokumentTozsamosci property can only contain items of type \StructType\TDokumentTozsamosci, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DokumentTozsamosci[] = $item;
        return $this;
    }
    /**
     * Get DzialalnoscGospodarcza value
     * @return \StructType\TDzialanoscGospodarcza|null
     */
    public function getDzialalnoscGospodarcza()
    {
        return $this->DzialalnoscGospodarcza;
    }
    /**
     * Set DzialalnoscGospodarcza value
     * @param \StructType\TDzialanoscGospodarcza $dzialalnoscGospodarcza
     * @return \StructType\TOsobaFizyczna
     */
    public function setDzialalnoscGospodarcza(\StructType\TDzialanoscGospodarcza $dzialalnoscGospodarcza = null)
    {
        $this->DzialalnoscGospodarcza = $dzialalnoscGospodarcza;
        return $this;
    }
}
